package com.elitesland.fin.application.facade.param.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/27
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "accountBalanceParam",description = "标准账户余额入参")
public class AccountBalanceParam implements Serializable {
    private static final long serialVersionUID = 1942636585361157037L;

    @ApiModelProperty(value = "公司编码")
    @NotBlank(message = "公司编码不能为空")
    private String ouCode;

    @ApiModelProperty("客户编码")
    @NotBlank(message = "客户编码不能为空")
    private String custCode;

    @ApiModelProperty("订单金额")
    private BigDecimal amt;

    @ApiModelProperty("扣款单据")
    private String optDoc;

    @ApiModelProperty("扣款单据状态")
    private String optDocStatus;

    @ApiModelProperty("扣款单据类型")
    private String optDocType;

}
