package com.elitesland.fin.application.web.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowDealerParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/28
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/accountFlow/dealer")
@RequiredArgsConstructor
@Api(value = "账户流水经销商端", tags = {"账户流水经销商端"})
public class AccountFlowDealerController {
    private final AccountFlowService accountFlowService;

    @PostMapping("/page")
    @ApiOperation("经销商端账户流水分页查询")
    public ApiResult<PagingVO<AccountFlowVO>> dealerPage(@RequestBody AccountFlowPageParam pageParam) {
        var ret = accountFlowService.dealerPage(pageParam);
        return ApiResult.ok(ret);
    }

    @PostMapping("/selectAmt")
    @ApiOperation("经销商端查询入账/使用金额")
    public ApiResult<AccountFlowDealerVO> dealerSelectAmt(@RequestBody AccountFlowPageParam pageParam) {
        var ret = accountFlowService.dealerSelectAmt(pageParam);
        return ApiResult.ok(ret);
    }

    /*@PostMapping("/selectAccAmt")
    @ApiOperation("经销商端查询储值/返利账户金额")
    public ApiResult<AccountFlowDealerVO> dealerSelectAccAmt(@RequestBody AccountFlowDealerParam param) {
        var ret = accountFlowService.dealerSelectAccAmt(param);
        return ApiResult.ok(ret);
    }*/

}
