/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.excel.flowrepair.AccountFlowRepairImportEntity;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.flowrepair.AccountFlowRepairDO;
import com.elitesland.fin.repo.flowrepair.AccountFlowRepairRepo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountFlowRepairImportServiceImpl
implements DataImport<AccountFlowRepairImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowRepairImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final AccountFlowService accountFlowService;
    private final AccountFlowRepairRepo accountFlowRepairRepo;

    public String getTmplCode() {
        return "account_flow_repair_import";
    }

    public List<String> executeImport(List<AccountFlowRepairImportEntity> dataList, int rowId) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<AccountFlowRepairImportEntity> flowRepairImportList = new ArrayList<AccountFlowRepairImportEntity>();
        List<String> repairFlowNoList = dataList.stream().map(AccountFlowRepairImportEntity::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<AccountFlowVO> flowVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(repairFlowNoList)) {
            AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
            flowQueryParam.setFlowNoList(repairFlowNoList);
            flowVOList = this.accountFlowService.selectListByQueryParam(flowQueryParam);
        }
        List flowNoList = flowVOList.stream().map(AccountFlowVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<String> errorResult = new ArrayList<String>();
        for (AccountFlowRepairImportEntity data : dataList) {
            ArrayList<String> errorList = new ArrayList<String>();
            int finalRowId = rowId;
            data.setRowId(rowId);
            String flowNo = data.getFlowNo();
            if (StringUtils.isBlank((CharSequence)flowNo)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6d41\u6c34\u53f7", "\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (!flowNoList.contains(flowNo)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6d41\u6c34\u53f7", "\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6d41\u6c34\u53f7"));
            }
            BigDecimal actualAmount = data.getActualAmount();
            if (Objects.isNull(actualAmount)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5b9e\u9645\u91d1\u989d", "\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isNotBlank((CharSequence)flowNo) && Objects.nonNull(actualAmount)) {
                flowRepairImportList.stream().filter(v -> Objects.equals(flowNo, v.getFlowNo()) && actualAmount.compareTo(v.getActualAmount()) == 0).findFirst().ifPresent(flowExcel -> errorList.add(MessageFormat.format(ERROR_TEMPLATE, finalRowId, "\u6574\u884c", "\u5bfc\u5165\u91cd\u590d\u6570\u636e,\u4e0e\u7b2c" + flowExcel.getRowId() + "\u884c\u91cd\u590d")));
            }
            if (CollectionUtils.isEmpty(errorList)) {
                flowRepairImportList.add(data);
                errorResult.add(null);
            } else {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(flowRepairImportList)) {
            this.saveData(flowRepairImportList, flowVOList);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void saveData(List<AccountFlowRepairImportEntity> saveList, List<AccountFlowVO> flowVOList) {
        SysUserDTO sysUserDTO = this.getUser();
        ArrayList flowRepairDOList = new ArrayList();
        Map<String, List<AccountFlowRepairImportEntity>> saveListMap = saveList.stream().collect(Collectors.groupingBy(AccountFlowRepairImportEntity::getFlowNo));
        for (String flowNo : saveListMap.keySet()) {
            List<AccountFlowRepairImportEntity> repairFlowList = saveListMap.get(flowNo);
            AccountFlowVO accountFlowVO = flowVOList.stream().filter(flowVO -> Objects.equals(flowVO.getFlowNo(), flowNo)).findFirst().get();
            List accountFlowRepairDOList = repairFlowList.stream().map(flowExcel -> {
                AccountFlowRepairDO flowRepairDO = new AccountFlowRepairDO();
                flowRepairDO.setFlowNo(flowExcel.getFlowNo());
                flowRepairDO.setActualAmount(flowExcel.getActualAmount());
                flowRepairDO.setAmount(accountFlowVO.getAmount());
                flowRepairDO.setOpenAccountEntityCode(null);
                flowRepairDO.setOpenAccountEntityName(accountFlowVO.getAccountHolderName());
                flowRepairDO.setAccountType(accountFlowVO.getAccountType());
                flowRepairDO.setAccountCode(accountFlowVO.getAccountCode());
                flowRepairDO.setAccountName(accountFlowVO.getAccountName());
                flowRepairDO.setSourceNo(accountFlowVO.getSourceNo());
                flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
                flowRepairDO.setRecalculationReason(UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode());
                flowRepairDO.setRecalculationUserId(sysUserDTO.getId());
                flowRepairDO.setRecalculationUser(sysUserDTO.getUsername());
                return flowRepairDO;
            }).collect(Collectors.toList());
            flowRepairDOList.addAll(accountFlowRepairDOList);
        }
        this.accountFlowRepairRepo.saveAll(flowRepairDOList);
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        if (Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    public AccountFlowRepairImportServiceImpl(AccountFlowService accountFlowService, AccountFlowRepairRepo accountFlowRepairRepo) {
        this.accountFlowService = accountFlowService;
        this.accountFlowRepairRepo = accountFlowRepairRepo;
    }
}

