package com.elitesland.fin.application.facade.param.account;

import com.elitesland.fin.application.facade.param.common.FinQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sunxw
 * @description 账户储值查询条件param
 * @Date 2023/5/18
 */
@Data
public class AccountStorageParam extends FinQueryParam {

    @ApiModelProperty("单据类型")
    private String receiptType;

    @ApiModelProperty("单据状态")
    private String receiptStatus;

    @ApiModelProperty("收款账户名称")
    private String accName;

    @ApiModelProperty("收款账号编码")
    private String accCode;

    private Long ouId;

    @ApiModelProperty("收款公司")
    private String ouName;

    @ApiModelProperty("汇款主体名称")
    private String remitter;

    @ApiModelProperty("汇款账户名称")
    private String remitterName;

    @ApiModelProperty("汇款账号")
    private String remitterAccount;

    @ApiModelProperty("汇款起始日期")
    private String remitterTimeStart;

    @ApiModelProperty("汇款终止日期")
    private String remitterTimeEnd;

    @ApiModelProperty("审核起始日期")
    private String checkTimeStart;

    @ApiModelProperty("审核终止日期")
    private String checkTimeEnd;

    @ApiModelProperty("支付方式")
    private String payMode;

    /** 加盟商编码 */
    private String franchisee;

}
