package com.elitesland.fin.application.facade.param.arorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.arorder
 * @date 2022/4/12 17:27
 */
@Data
public class ArAgingReportParam implements Serializable {

    private static final long serialVersionUID = 1432210533944691244L;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("业务日期开始")
    private LocalDateTime startBuDate;

    @ApiModelProperty("业务日期结束")
    private LocalDateTime endBuDate;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("超账期标识")
    private Boolean exceedPaymentPeriodFlag;

    private Integer pageSize=10;

    private Integer page=0;

}
