package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.saleinv
 * @date 2022/5/6 15:22
 */
@Component
@RequiredArgsConstructor
public class SaleInvDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;


    public List<SaleInvDtlDTO> getList(Long masId) {
        List<Predicate> predicates = new ArrayList<>();
        if (null != masId) {
            predicates.add(qSaleInvDtlDO.masId.eq(masId));
        }
        predicates.add(qSaleInvDtlDO.deleteFlag.eq(0));
        List<SaleInvDtlDTO> res = jpaQueryFactory.select(Projections.bean(SaleInvDtlDTO.class,
                        qSaleInvDtlDO.id,
                        qSaleInvDtlDO.masId,
                        qSaleInvDtlDO.taxName,
                        qSaleInvDtlDO.taxCode,
                        qSaleInvDtlDO.invNature,
                        qSaleInvDtlDO.sourceNo,
                        qSaleInvDtlDO.sourceId,
                        qSaleInvDtlDO.sourceLine,
                        qSaleInvDtlDO.sourceLineId,
                        qSaleInvDtlDO.soSource,
                        qSaleInvDtlDO.itemId,
                        qSaleInvDtlDO.itemName,
                        qSaleInvDtlDO.itemCode,
                        qSaleInvDtlDO.itemType,
                        qSaleInvDtlDO.uom,
                        qSaleInvDtlDO.uomName,
                        qSaleInvDtlDO.qty,
                        qSaleInvDtlDO.price,
                        qSaleInvDtlDO.totalAmt,
                        qSaleInvDtlDO.totalCurAmt,
                        qSaleInvDtlDO.taxRate,
                        qSaleInvDtlDO.taxAmt,
                        qSaleInvDtlDO.taxCurAmt,
                        qSaleInvDtlDO.exclTaxAmt,
                        qSaleInvDtlDO.exclTaxCurAmt,
                        qSaleInvDtlDO.invType,
                        qSaleInvDtlDO.invKind,
                        qSaleInvDtlDO.examType,
                        qSaleInvDtlDO.agentName,
                        qSaleInvDtlDO.recvContactName,
                        qSaleInvDtlDO.recvContactTel,
                        qSaleInvDtlDO.recvDetailaddr,
                        qSaleInvDtlDO.giftsFlag,
                        qSaleInvDtlDO.flDeductionAmt,
                        qSaleInvDtlDO.invDiscount,
                        qSaleInvDtlDO.invDiscountAmt,
                        qSaleInvDtlDO.discountAmt,
                        qSaleInvDtlDO.invAmt,
                        qSaleInvDtlDO.custCode,
                        qSaleInvDtlDO.custName,
                        qSaleInvDtlDO.docNo,
                        qSaleInvDtlDO.invoiceAwaitId,
                        qSaleInvDtlDO.rootDocId,
                        qSaleInvDtlDO.rootDocDId,
                        qSaleInvDtlDO.rootDocNo
                )).from(qSaleInvDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
        return res;
    }

    public List<SaleInvDtlDTO> getList2(List<Long> masIdList) {
        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(masIdList)) {
            predicates.add(qSaleInvDtlDO.masId.in(masIdList));
        }
        predicates.add(qSaleInvDtlDO.deleteFlag.eq(0));
        return jpaQueryFactory.select(Projections.bean(SaleInvDtlDTO.class,
                        qSaleInvDtlDO.id,
                        qSaleInvDtlDO.rootDocNo
                )).from(qSaleInvDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }

    public void delByMasId(List<Long> masIds) {
        if (CollUtil.isEmpty(masIds)) {
            return;
        }
        jpaQueryFactory.update(qSaleInvDtlDO)
                .set(qSaleInvDtlDO.deleteFlag, 1)
                .where(qSaleInvDtlDO.masId.in(masIds))
                .execute();
    }

    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();

        predicates.add(qSaleInvDtlDO.deleteFlag.eq(0));
        predicates.add(qSaleInvDtlDO.masId.eq(saleInvDtlPageParam.getMasId()));

        JPAQuery<SaleInvDtlDTO> query = select(SaleInvDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        saleInvDtlPageParam.setPaging(query);
        saleInvDtlPageParam.fillOrders(query, qSaleInvDtlDO);
        return PagingVO.<SaleInvDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleInvDtlDO.id,
                qSaleInvDtlDO.masId,
                qSaleInvDtlDO.taxName,
                qSaleInvDtlDO.taxCode,
                qSaleInvDtlDO.invNature,
                qSaleInvDtlDO.sourceNo,
                qSaleInvDtlDO.sourceId,
                qSaleInvDtlDO.sourceLine,
                qSaleInvDtlDO.sourceLineId,
                qSaleInvDtlDO.soSource,
                qSaleInvDtlDO.itemId,
                qSaleInvDtlDO.itemName,
                qSaleInvDtlDO.itemCode,
                qSaleInvDtlDO.itemType,
                qSaleInvDtlDO.uom,
                qSaleInvDtlDO.uomName,
                qSaleInvDtlDO.qty,
                qSaleInvDtlDO.price,
                qSaleInvDtlDO.totalAmt,
                qSaleInvDtlDO.totalCurAmt,
                qSaleInvDtlDO.taxRate,
                qSaleInvDtlDO.taxAmt,
                qSaleInvDtlDO.taxCurAmt,
                qSaleInvDtlDO.exclTaxAmt,
                qSaleInvDtlDO.exclTaxCurAmt,
                qSaleInvDtlDO.invType,
                qSaleInvDtlDO.invKind,
                qSaleInvDtlDO.examType,
                qSaleInvDtlDO.agentName,
                qSaleInvDtlDO.recvContactName,
                qSaleInvDtlDO.recvContactTel,
                qSaleInvDtlDO.recvDetailaddr,
                qSaleInvDtlDO.giftsFlag,
                qSaleInvDtlDO.flDeductionAmt,
                qSaleInvDtlDO.invDiscount,
                qSaleInvDtlDO.invDiscountAmt,
                qSaleInvDtlDO.discountAmt,
                qSaleInvDtlDO.invAmt,
                qSaleInvDtlDO.docNo,
                qSaleInvDtlDO.invoiceAwaitId,
                qSaleInvDtlDO.invNo

//                qSaleInvDtlDO.examType,
//                qSaleInvDtlDO.uom2,
//                qSaleInvDtlDO.uom2Name,
//                qSaleInvDtlDO.qty2,
//                qSaleInvDtlDO.es5,
//                qSaleInvDtlDO.price2,
//                qSaleInvDtlDO.es7,
//                qSaleInvDtlDO.discountAmt,
//                qSaleInvDtlDO.es9,
//                qSaleInvDtlDO.es10,
//                qSaleInvDtlDO.es11,
//                qSaleInvDtlDO.es12,
//                qSaleInvDtlDO.es13,
//                qSaleInvDtlDO.es14,
//                qSaleInvDtlDO.es15,
//                qSaleInvDtlDO.es16,
//                qSaleInvDtlDO.es17,
//                qSaleInvDtlDO.es18,
//                qSaleInvDtlDO.es19
        )).from(qSaleInvDtlDO);
    }

    public List<SaleInvDtlDTO> queryByMasId(Long id) {
        return select(SaleInvDtlDTO.class)
                .where(qSaleInvDtlDO.masId.eq(id)).fetch();
    }
}
