package com.elitesland.fin.repo.invoice;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitDetailPageParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.entity.invoice.QInvoiceAwaitDDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Component
@RequiredArgsConstructor
public class InvoiceAwaitDRepoProc {
    private static final QInvoiceAwaitDDO qInvoiceAwaitDDO = QInvoiceAwaitDDO.invoiceAwaitDDO;
    private final JPAQueryFactory jpaQueryFactory;


    public void updateDeleteFlagByMasIdBatch(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qInvoiceAwaitDDO)
                .set(qInvoiceAwaitDDO.deleteFlag, deleteFlag)
                .where(qInvoiceAwaitDDO.masId.in(masIds))
                .execute();
    }


    public PagingVO<InvoiceAwaitDVO> page(InvoiceAwaitDetailPageParam param) {
        List<Predicate> where = buildWhereClause(param);

        JPAQuery<InvoiceAwaitDVO> query = jpaQueryFactory.select(Projections.bean(InvoiceAwaitDVO.class,
                        qInvoiceAwaitDDO.id,
                        qInvoiceAwaitDDO.masId,
                        qInvoiceAwaitDDO.lineNo,
                        qInvoiceAwaitDDO.itemCode,
                        qInvoiceAwaitDDO.itemName,
                        qInvoiceAwaitDDO.itemId,
                        qInvoiceAwaitDDO.taxType,
                        qInvoiceAwaitDDO.serviceName,
                        qInvoiceAwaitDDO.itemSpec,
                        qInvoiceAwaitDDO.uom,
                        qInvoiceAwaitDDO.qty,
                        qInvoiceAwaitDDO.originAmt,
                        qInvoiceAwaitDDO.amt,
                        qInvoiceAwaitDDO.taxRate,
                        qInvoiceAwaitDDO.tax,
                        qInvoiceAwaitDDO.netAmt,
                        qInvoiceAwaitDDO.agentName,
                        qInvoiceAwaitDDO.recvContactName,
                        qInvoiceAwaitDDO.recvContactTel,
                        qInvoiceAwaitDDO.recvDetailaddr,
                        qInvoiceAwaitDDO.soSource,
                        qInvoiceAwaitDDO.giftsFlag,
                        qInvoiceAwaitDDO.flDeductionAmt,
                        qInvoiceAwaitDDO.invDiscount,
                        qInvoiceAwaitDDO.invDiscountAmt,
                        qInvoiceAwaitDDO.discountAmt,
                        qInvoiceAwaitDDO.mainPrice,
                        qInvoiceAwaitDDO.invAmt,
                        qInvoiceAwaitDDO.invTaxAmt,
                        qInvoiceAwaitDDO.invNetAmt,
                        qInvoiceAwaitDDO.custCode,
                        qInvoiceAwaitDDO.custName,
                        qInvoiceAwaitDDO.custId,
                        qInvoiceAwaitDDO.docNo,
                        qInvoiceAwaitDDO.relateDocDid,
                        qInvoiceAwaitDDO.rootDocTime,
                        qInvoiceAwaitDDO.remark,
                        qInvoiceAwaitDDO.deleteFlag
                ))
                .from(qInvoiceAwaitDDO)
                .where(ExpressionUtils.allOf(where));

        param.setPaging(query);
        param.fillOrders(query, qInvoiceAwaitDDO);

        return PagingVO.<InvoiceAwaitDVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> buildWhereClause(InvoiceAwaitDetailPageParam param) {
        List<Predicate> predicates = new ArrayList<>();

        // 根据具体业务需求添加查询条件
        if (Objects.nonNull(param.getMasId())) {
            predicates.add(qInvoiceAwaitDDO.masId.eq(param.getMasId()));
        }

        return predicates;
    }

}
