package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 保存参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "保存参数")
public class FinArRecVerApplyRecSaveDTO implements Serializable {

    private static final long serialVersionUID = -2961960466643509169L;

    /**
     * 收款单ID
     */
    @ApiModelProperty(value = "收款单ID")
    private Long recId;

    /**
     * 收款单号
     */
    @ApiModelProperty(value = "应收单号")
    private String recDocNo;

    /**
     * 第三方收款单号
     */
    @ApiModelProperty(value = "第三方收款单号")
    private String outRecDocNo;

    /**
     * 收款单明细ID
     */
    @ApiModelProperty(value = "收款单明细ID")
    @NotNull(message = "收款单明细ID不能为空")
    private Long recDId;

    /**
     * 外部收款单明细ID
     */
    @ApiModelProperty(value = "外部收款单明细ID")
    private String outRecDId;

    /**
     * 应收单类型ID
     */
    @ApiModelProperty(value = "收款单类型ID")
    private Long recTypeId;

    /**
     * 应收单类型编码
     */
    @ApiModelProperty(value = "收款单类型编码")
    private String recTypeCode;

    /**
     * 应收单类型名称
     */
    @ApiModelProperty(value = "收款单类型名称")
    private String recTypeName;

    /**
     * 公司ID
     */
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 部门ID
     */
    @ApiModelProperty(value = "部门ID")
    private Long buId;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String buCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String buName;

    /**
     * 业务员ID
     */
    @ApiModelProperty(value = "业务员ID")
    private Long salesmanId;

    /**
     * 业务员编码
     */
    @ApiModelProperty(value = "业务员编码")
    private String salesmanCode;

    /**
     * 业务员名称
     */
    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    /**
     * 发票号
     */
    @ApiModelProperty(value = "发票号")
    private String invoiceNumber;

    /**
     * 开票日期
     */
    @ApiModelProperty(value = "开票日期")
    private LocalDateTime invDate;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;

    /**
     * 客户ID
     */
    @ApiModelProperty(value = "客户ID")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 收款业务类型
     */
    @ApiModelProperty(value = "收款业务类型")
    private String recBuType;

    /**
     * 收款性质
     */
    @ApiModelProperty(value = "收款性质")
    private String recNat;

    /**
     * 含税总金额
     */
    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    /**
     * 收款银行账户
     */
    @ApiModelProperty(value = "收款银行账户")
    private String recBank;

    /**
     * 付款银行账户
     */
    @ApiModelProperty(value = "付款银行账户")
    private String payBank;

    /**
     * 收款单单据日期
     */
    @ApiModelProperty(value = "收款单单据日期")
    private LocalDateTime recDate;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 未核销金额
     */
    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;

    /**
     * 本次核销金额
     */
    @ApiModelProperty(value = "本次核销金额")
    @NotNull(message = "核销金额不能为空")
    private BigDecimal verAmt;

    /**
     * 本次核销原始金额
     */
    private BigDecimal origVerAmt;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
}
