/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.invoice;

import com.elitesland.fin.application.facade.param.invoice.PaymentOrderParam;
import com.elitesland.fin.application.facade.vo.invoice.PaymentOrderPageRespVo;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.entity.invoice.PaymentOrderFiledDo;
import com.elitesland.fin.entity.invoice.QPaymentOrderFiledDo;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PaymentOrderFiledRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPaymentOrderFiledDo qPaymentOrderFiledDo = QPaymentOrderFiledDo.paymentOrderFiledDo;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;
    private final QBean<PaymentOrderPageRespVo> appList;

    public long countPaymentOrderRpc(PaymentOrderParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qPayOrderDO.count()).from((EntityPath)this.qPayOrderDO)).leftJoin((EntityPath)this.qPaymentOrderFiledDo)).on((Predicate)this.qPayOrderDO.id.eq(this.qPaymentOrderFiledDo.masId));
        jpaQuery.where(this.whereRecOrderRpc(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<PaymentOrderPageRespVo> queryPaymentOrderPrc(PaymentOrderParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.appList).from((EntityPath)this.qPayOrderDO)).leftJoin((EntityPath)this.qPaymentOrderFiledDo)).on((Predicate)this.qPayOrderDO.id.eq(this.qPaymentOrderFiledDo.masId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.qPayOrderDO);
        jpaQuery.where(this.whereRecOrderRpc(paramVO));
        return jpaQuery.fetch();
    }

    public PaymentOrderPageRespVo queryPaymentOrderPrcDetail(Long id) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.appList).from((EntityPath)this.qPayOrderDO)).leftJoin((EntityPath)this.qPaymentOrderFiledDo)).on((Predicate)this.qPayOrderDO.id.eq(this.qPaymentOrderFiledDo.masId))).where((Predicate)this.qPayOrderDO.id.eq((Object)id));
        return (PaymentOrderPageRespVo)jpaQuery.fetchOne();
    }

    private Predicate whereRecOrderRpc(PaymentOrderParam paramVO) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getPayOrderNo())) {
            likeStr = SqlUtil.toSqlLikeString(paramVO.getPayOrderNo());
            predicates.add(this.qPayOrderDO.payOrderNo.like(likeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getShopName())) {
            likeStr = SqlUtil.toSqlLikeString(paramVO.getShopName());
            predicates.add(this.qPaymentOrderFiledDo.shopName.like(likeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getPayTypeCode())) {
            likeStr = SqlUtil.toSqlLikeString(paramVO.getPayTypeCode());
            predicates.add(this.qPayOrderDO.payTypeCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getShopCode())) {
            likeStr = SqlUtil.toSqlLikeString(paramVO.getShopCode());
            predicates.add(this.qPaymentOrderFiledDo.shopCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getOrderState())) {
            predicates.add(this.qPayOrderDO.orderState.eq((Object)paramVO.getOrderState()));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getCreator())) {
            likeStr = SqlUtil.toSqlLikeString(paramVO.getCreator());
            predicates.add(this.qPayOrderDO.creator.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getApDateStart())) {
            predicates.add(this.qPayOrderDO.apDate.after((Comparable)paramVO.getApDateStart()).or((Predicate)this.qPayOrderDO.apDate.after((Comparable)paramVO.getApDateStart())));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getApDateEnd())) {
            predicates.add(this.qPayOrderDO.apDate.before((Comparable)paramVO.getApDateEnd()).or((Predicate)this.qPayOrderDO.apDate.before((Comparable)paramVO.getApDateEnd())));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getSuppCode())) {
            predicates.add(this.qPayOrderDO.suppCode.eq((Object)paramVO.getSuppCode()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getSuppName())) {
            predicates.add(this.qPayOrderDO.suppName.in((Object[])new String[]{paramVO.getSuppName()}));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public Long masIdUpdateFiled(PaymentOrderFiledDo rec) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.qPaymentOrderFiledDo.id.eq((Object)rec.getMasId()));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qPaymentOrderFiledDo).set((Path)this.qPaymentOrderFiledDo.shopName, (Object)rec.getShopName()).set((Path)this.qPaymentOrderFiledDo.shopCode, (Object)rec.getShopCode()).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public PaymentOrderFiledRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.appList = Projections.bean(PaymentOrderPageRespVo.class, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.suppName, this.qPayOrderDO.suppCode, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName, this.qPayOrderDO.orderState, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.totalAmt, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouId, this.qPaymentOrderFiledDo.shopCode, this.qPaymentOrderFiledDo.shopName, this.qPaymentOrderFiledDo.masId, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.currCode, this.qPaymentOrderFiledDo.applyFile, this.qPayOrderDO.orderState, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.remark, this.qPayOrderDO.creator, this.qPayOrderDO.createTime});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

