/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.saleinvd;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.saleinvd.SaleInvdService;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdPageParam;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.saleinvd.SaleInvdDomainService;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvdServiceImpl
implements SaleInvdService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvdServiceImpl.class);
    private final SaleInvdDomainService saleInvdDomainService;
    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<SaleInvdDtlVO> page(SaleInvdPageParam param) {
        PagingVO<SaleInvdDtlVO> page = this.saleInvdDtlRepoProc.getPage(param);
        if (CollectionUtil.isNotEmpty((Collection)page.getRecords())) {
            Map invRedBlueType = this.udcProvider.getValueMapByUdcCode("yst-fin", "INV_RED_BLUE_TYPE");
            Map invState = this.udcProvider.getValueMapByUdcCode("yst-fin", "INV_STATE");
            page.getRecords().forEach(saleInvdDtlVO -> {
                saleInvdDtlVO.setRedBlueTypeName((String)invRedBlueType.get(saleInvdDtlVO.getRedBlueType()));
                saleInvdDtlVO.setInvStateName((String)invState.get(saleInvdDtlVO.getInvState()));
            });
        }
        return page;
    }

    @Override
    public void cancel(Long id) {
        this.saleInvdDomainService.cancel(id);
    }

    @Override
    public void red(Long id) {
        this.saleInvdDomainService.red(id);
    }

    @Override
    @Transactional
    public InvoiceRedraftPageVO redraft(Long id) {
        return this.saleInvdDomainService.redraft(id);
    }

    @Override
    public void update(SaleInvdParam param) {
        this.saleInvdDomainService.update(param);
    }

    @Override
    @SysCodeProc
    public SaleInvDetailAppVO appGet(Long id) {
        return this.saleInvdDomainService.appGet(id);
    }

    public SaleInvdServiceImpl(SaleInvdDomainService saleInvdDomainService, SaleInvdDtlRepoProc saleInvdDtlRepoProc, UdcProvider udcProvider) {
        this.saleInvdDomainService = saleInvdDomainService;
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.udcProvider = udcProvider;
    }
}

