package com.elitesland.fin.application.service.excel.imp;

import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.facade.dto.mq.AdjustOrderSubmitProcessMqMessageDTO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.config.JobConstant;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.fin.utils.TransactionCommitHandler;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 调整单定时提交任务
 * 每分钟扫描草稿状态的调整单并提交
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class AdjustOrderSubmitJob {

    private final AdjustOrderRepo adjustOrderRepo;
    private final TransactionCommitHandler transactionCommitHandler;
    private final MessageQueueTemplate messageQueueTemplate;

    /**
     * 每分钟执行一次，扫描并提交草稿状态的调整单
     */
    @XxlJob(JobConstant.IMPORT_ADJUST_ORDER_AUTO_SUBMIT)
    public ReturnT<String> submitDraftAdjustOrders(String param) {
        try {
            log.info("开始扫描草稿状态的调整单...");
            // 查询草稿状态的调整单,并且处理状态是待处理的
            List<AdjustOrderDO> draftOrders = adjustOrderRepo.findAllByStateAndProcessStatus(UdcEnum.APPLY_STATUS_DRAFT.getValueCode(), "TODO");
            if (draftOrders != null && !draftOrders.isEmpty()) {
                log.info("找到 {} 条草稿状态并且待处理的调整单，开始提交...", draftOrders.size());
                // 提交每个草稿订单
                for (AdjustOrderDO draftOrder : draftOrders) {
                    AdjustOrderSubmitProcessMqMessageDTO messageDTO = new AdjustOrderSubmitProcessMqMessageDTO();
                    messageDTO.setId(draftOrder.getId());
                    messageDTO.setBusinessKey(draftOrder.getDocNo());
                    try {
                        messageQueueTemplate.publishMessage(Application.NAME, AdjustOrderSubmitProcessMqMessageDTO.SUBMIT_CHANNEL, messageDTO);
                    } catch (Exception e) {
                        log.error("发送mq消息，处理导入调整单失败,同步内容{}, 失败原因：{}", messageDTO, e.getMessage());
                    }
                }
            } else {
                log.info("未找到草稿状态的调整单");
            }
        } catch (Exception e) {
            log.error("定时提交草稿调整单时发生异常", e);
        }
        return ReturnT.SUCCESS;
    }
}
