package com.elitesland.fin.application.service.writeoff;


import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinArRecVerApplyArService {

    /**
     * 批量插入.
     *
     * @param masId    主表ID
     * @param saveList 数据集合
     */
    void createBatch(Long masId, List<FinArRecVerApplyArSaveDTO> saveList);

    /**
     * 批量删除.
     *
     * @param masIds 主表ID集合
     */
    void deleteByMasId(Collection<Long> masIds);

    /**
     * 数据查询.
     *
     * @param masIds 主表ID集合
     * @return 数据集合
     */
    List<FinArRecVerApplyArVO> listByMasIds(Collection<Long> masIds);

	/**
	 * 根据条件查询核销应收单明细
	 * @param query
	 * @return
	 */
	List<FinArRecVerApplyArVO> listByQuery(FinArRecVerApplyArQuery query);

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	List<FinArRecVerApplyArVO> listByOutArDocNoOrDId(FinArRecVerApplyQuery applyQuery);

}
