package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计期间明细")
public class FinAccountPeriodLineParam extends BaseModelParam {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("期间格式")
    private String periodStyle;

    @ApiModelProperty("年份")
    private String year;

    @ApiModelProperty("季度")
    private String quarter;

    @ApiModelProperty("月份")
    private String month;

    @ApiModelProperty("起始有效日期")
    private LocalDateTime activeStartTime;

    @ApiModelProperty("终止有效日期")
    private LocalDateTime activeEndTime;
}
