/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.workflow;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.service.unionpay.entity.enums.DocStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.SourceTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.StoredOrderTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepoProc;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SVO_OFFLINEPAY/callBack"})
@Transactional
public class OfflinePayWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OfflinePayWorkflowCallBackController.class);
    private final RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;
    private final AccountStorageRepoProc accountStorageRepoProc;
    private final AccountFlowRpcService accountFlowRpcService;
    private final AccountStorageRepo accountStorageRepo;
    private final WorkflowService workflowService;

    private RecOrderRpcPageRespVo getRecOrderRpcPageRespVo(String businessKey) {
        String sourceNo = businessKey.split("#")[0].trim();
        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setSourceNo(sourceNo);
        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = this.recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
        Assert.notEmpty(recOrderRpcPageRespVoList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355", (Object[])new Object[0]);
        Assert.isTrue((recOrderRpcPageRespVoList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u5230\u591a\u6761\u6536\u6b3e\u5355", (Object[])new Object[0]);
        return recOrderRpcPageRespVoList.get(0);
    }

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03:{}", (Object)payload.toString());
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String tenantId = payload.getTenantId();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CommentInfo commentInfo = payload.getCommentInfo();
        RecOrderRpcPageRespVo recOrderRpcPageRespVo = this.getRecOrderRpcPageRespVo(payload.getBusinessKey());
        SendPayReq accountStorage = new SendPayReq();
        accountStorage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());
        SendPayReq recOrder = new SendPayReq();
        recOrder.setWorkflowProcInstStatus(procInstStatus);
        recOrder.setId(recOrderRpcPageRespVo.getId());
        switch (procInstStatus) {
            case NOTSUBMIT: {
                break;
            }
            case INTERRUPT: {
                break;
            }
            case REJECTED: {
                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_REJECT.getCode());
                accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_REJECT.getCode());
                break;
            }
            case INVALID: {
                break;
            }
            case APPROVING: {
                break;
            }
            case APPROVED: {
                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_SUCCESS.getCode());
                recOrder.setReceiptStatus(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
                accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_SUCCESS.getCode());
                recOrder.setWorkflowEndTime(LocalDateTime.now());
            }
        }
        this.recOrderRpcFiledRepoProc.updateRecOrder(recOrder);
        this.accountStorageRepoProc.updateAccountStorage(accountStorage);
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(recOrder.getReceiptStatus()) && DocStatusEnum.SVO_APPROVE_SUCCESS.getCode().equals(accountStorage.getReceiptStatus())) {
            this.generateAccountFlow(accountStorage);
        }
        return WorkflowResult.success(null);
    }

    private void generateAccountFlow(SendPayReq accountStorage) {
        List<AccountStorageDO> accountStorageDOList = this.accountStorageRepo.findByPayOrderId(accountStorage.getPayOrderId());
        Assert.notEmpty(accountStorageDOList, (String)"\u50a8\u503c\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.equals((Object)accountStorageDOList.size(), (Object)1, (String)"\u5b58\u5728\u591a\u6761\u50a8\u503c\u5355", (Object[])new Object[0]);
        AccountStorageDO accountStorageDO = accountStorageDOList.get(0);
        AccountFlowRpcParam rpcParam = new AccountFlowRpcParam();
        rpcParam.setSourceId(accountStorageDO.getId());
        rpcParam.setSourceDoc(SourceTypeEnum.SVO.getCode());
        rpcParam.setSourceDocType(StoredOrderTypeEnum.PREPAY.getCode());
        rpcParam.setSourceDocStatus(accountStorageDO.getReceiptStatus());
        rpcParam.setSourceDocAmount(accountStorageDO.getRemitterAmt());
        rpcParam.setSourceNo(accountStorageDO.getId().toString());
        rpcParam.setAccountHolderName(accountStorageDO.getRemitter());
        rpcParam.setAccountCode(accountStorageDO.getAccCode());
        try {
            ApiResult apiResult = this.accountFlowRpcService.generateAccountFlow(rpcParam);
            log.info("\u50a8\u503c\u8ba2\u5355\u8d26\u6237\u6d41\u6c34 req is {},resp is{}", (Object)rpcParam, (Object)apiResult);
        }
        catch (Exception e) {
            log.error("\u50a8\u503c\u8ba2\u5355\u8c03\u7528\u8d26\u6237\u6d41\u6c34\u903b\u8f91\u53d1\u751f\u9519\u8bef\uff0creq is {}\uff0c\u9519\u8bef\u4fe1\u606f is :{}", (Object)rpcParam, (Object)e);
        }
    }

    @PostMapping(value={"/reject"})
    @ApiOperation(value="\u5ba1\u6279\u62d2\u7edd")
    public ApiResult<Void> reject(@RequestBody RecOrderRpcPageRespVo recOrderRpcPageRespVo) {
        this.checkRejectParam(recOrderRpcPageRespVo);
        SendPayReq accountStorage = new SendPayReq();
        accountStorage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());
        accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_REJECT.getCode());
        this.accountStorageRepoProc.updateAccountStorage(accountStorage);
        SendPayReq recOrder = new SendPayReq();
        recOrder.setWorkflowProcInstStatus(ProcInstStatus.INVALID);
        recOrder.setId(recOrderRpcPageRespVo.getId());
        recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_REJECT.getCode());
        this.recOrderRpcFiledRepoProc.updateRecOrder(recOrder);
        DeleteProcessPayload deleteProcessPayload = new DeleteProcessPayload();
        deleteProcessPayload.setProcInstId(recOrderRpcPageRespVo.getWorkflowProcInstId());
        this.workflowService.deleteProcess(deleteProcessPayload);
        return ApiResult.ok();
    }

    private void checkRejectParam(RecOrderRpcPageRespVo recOrderRpcPageRespVo) {
        Assert.notEmpty((CharSequence)recOrderRpcPageRespVo.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)recOrderRpcPageRespVo.getId(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)recOrderRpcPageRespVo.getWorkflowProcInstId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u5fc5\u586b", (Object[])new Object[0]);
    }

    public OfflinePayWorkflowCallBackController(RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc, AccountStorageRepoProc accountStorageRepoProc, AccountFlowRpcService accountFlowRpcService, AccountStorageRepo accountStorageRepo, WorkflowService workflowService) {
        this.recOrderRpcFiledRepoProc = recOrderRpcFiledRepoProc;
        this.accountStorageRepoProc = accountStorageRepoProc;
        this.accountFlowRpcService = accountFlowRpcService;
        this.accountStorageRepo = accountStorageRepo;
        this.workflowService = workflowService;
    }
}

