package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecHeadVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecHeadDO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepo;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyRecHeadServiceImpl implements FinArRecVerApplyRecHeadService {

    private final FinArRecVerApplyRecHeadRepoProc finArRecVerApplyRecHeadRepoProc;

    private final FinArRecVerApplyRecHeadRepo finArRecVerApplyRecHeadRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public Long create(Long masId, FinArRecVerApplyRecHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinArRecVerApplyRecHeadDO entity = FinArRecVerApplyRecHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);

        if (StringUtils.isBlank(entity.getInOutCust()) || StringUtils.isBlank(entity.getRelevanceOuCode())){
            List<RecOrderDTO> recOrderDTOList = recOrderRepoProc.selectInOutCustByRecOrderNo(Collections.singletonList(entity.getRecOrderNo()));
            Map<String, RecOrderDTO> recOrderMap = CollectionUtil.isEmpty(recOrderDTOList) ? new HashMap<>() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1));
            RecOrderDTO recOrderDTO = recOrderMap.get(entity.getRecOrderNo());
            if (Objects.nonNull(recOrderDTO)){
                String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? recOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
        }

        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AR_REC_VER_APPLY_REC_HEAD, entity);
        return finArRecVerApplyRecHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyRecHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = finArRecVerApplyRecHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finArRecVerApplyRecHeadVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyRecHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finArRecVerApplyRecHeadVOList;
    }

	@Override
	public List<FinArRecVerApplyRecHeadVO> listByIds(Collection<Long> ids, FinArRecVerApplyQuery query) {
		return finArRecVerApplyRecHeadRepoProc.listByIds(ids,query)
				.stream()
				.map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
