package com.elitesland.fin.application.web.workflow;


import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.enums.InvTitleTypeEnum;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "INVOICE_REDRAFT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class InvoiceRedraftCallbackController implements WorkflowCallBack {

    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceService invoiceService;
    private final InvoiceSaveService invoiceSaveService;
    /**
     * 查询单据
     */
    private InvoiceRedraftDO getInvRedraftDO(String businessKey) {
        Long masId = Long.valueOf(businessKey.split("#")[1].trim());
        Optional<InvoiceRedraftDO> byId = invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new RuntimeException("重新开票(id:" + masId + ")不存在，无法审批");
        }
        return byId.get();
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(new ArrayList<>());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}", payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    private static String getDecryptedData(String encryptedData) {
        // 解密秘钥
        String key = "12345678";
        // 将16进制字符串转换为字节数组
        byte[] encryptedBytes = InvoiceIssueUtil.parseHexStr2Byte(encryptedData);
        if (encryptedBytes == null) {
            throw new RuntimeException("解密失败,加密数据格式错误，加密数据:" + encryptedData);
        }
        // 解密数据
        try {
            byte[] decryptedBytes = InvoiceIssueUtil.decrypt(encryptedBytes, key);
            return InvoiceIssueUtil.byteToHexString(decryptedBytes);
        } catch (Exception e) {
            throw new RuntimeException("解密失败,解密过程异常，加密数据:" + encryptedData, e);
        }
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        /**
         * 验证数据
         */
        //1,单据是否存在
        InvoiceRedraftDO invoiceRedraftDO = getInvRedraftDO(payload.getBusinessKey());

        /**
         * 修改单据
         */
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qdo)
                .set(qdo.workflowProcInstStatus, procInstStatus) //审批状态
                .where(qdo.id.eq(invoiceRedraftDO.getId()));

        JPAUpdateClause saleInvdDtlDOJpaUpdateClause = jpaQueryFactory.update(qSaleInvdDtlDO)
                .where(qSaleInvdDtlDO.invNo.eq(invoiceRedraftDO.getInvoiceNo()));

        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//未生效

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//草稿
                jpaUpdateClause.setNull(qdo.workflowProcInstId);//清空流程实例ID
                jpaUpdateClause.setNull(qdo.workflowProcInstStatus);//清空流程实例状态

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_REJECTED.getValueCode());//未生效
//                jpaUpdateClause.set(QFranchiseeApplyDO.franchiseeApplyDO.workflowRejectedMessage, commentInfo.getComment());
//                jpaUpdateClause.setNull(qFranchiseeApplyDO.workflowProcInstId);//清空流程实例ID
                //messageHandleUtils.sendFranchiseeApplyRejectMsg(franchiseeApplyDO);
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.REJECTED);

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//已作废

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DOING.getValueCode());//未生效
                //审批状态
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.APPROVING);

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DOING.getValueCode());
                break;
            case APPROVED: // 审批通过
                //查询票易通该单据的状态，若为红冲状态，则进行重新开票的生成
                jpaUpdateClause.setNull(qdo.workflowCurrentNodeName);//清空当前审批节点名称
                jpaUpdateClause.setNull(qdo.workflowCurrentNodeKey);//清空当前审批节点key
                jpaUpdateClause.setNull(qdo.workflowCurrentUserIds);//清空当前审批人
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());//已生效
                jpaUpdateClause.set(qdo.workflowEndTime, LocalDateTime.now());//审批完成时间
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.APPROVED);//审批状态

                // 调用航信接口，发送红冲请求
                SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                InvoiceApplyParam param = new InvoiceApplyParam();

                param.setInvType(invoiceRedraftDO.getInvoiceType());
                param.setInvTitleType(invoiceRedraftDO.getInvTitleType());
                param.setCustInvTitle(invoiceRedraftDO.getInvTitle());
                if (Objects.equals(invoiceRedraftDO.getInvTitleType(), InvTitleTypeEnum.ENTERPRISE.getCode())) {
                    param.setCustTaxNo(invoiceRedraftDO.getTaxerNo());
                } else if (Objects.equals(invoiceRedraftDO.getInvTitleType(), InvTitleTypeEnum.PERSONAL.getCode())) {
                    // 个人类型不传税号
                    param.setCustTaxNo(null);
                }
                param.setCustBank(saleInvDO.getCustBank());
                param.setCustBankAcc(saleInvDO.getCustBankAcc());
                param.setCustTel(saleInvDO.getCustTel());
                param.setInvType(saleInvDO.getInvType());
                param.setRemark(saleInvDO.getRemark());
                param.setInvCustName(saleInvDO.getInvCustName());
                param.setInvCustCode(saleInvDO.getInvCustCode());
                param.setInvCustId(saleInvDO.getInvCustId());
                param.setCustAdd(saleInvDO.getCustAdd());
                param.setInvEmail(saleInvDO.getInvEmail());
                param.setInvPicName(saleInvDO.getInvPicName());
                param.setInvPicPhone(saleInvDO.getInvPicPhone());
                invoiceSaveService.save(param);
                break;
        }
        //执行
        jpaUpdateClause.execute();
        saleInvdDtlDOJpaUpdateClause.execute();

        return WorkflowResult.success(null);
    }
}
