package com.elitesland.fin.infr.repo.paymentperiod;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.QReceiptPaymentAgreementDtlDO;
import com.elitesland.fin.infr.dto.paymentperiod.ReceiptPaymentAgreementDtlDTO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ReceiptPaymentAgreementDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QReceiptPaymentAgreementDtlDO qReceiptPaymentAgreementDtlDO = QReceiptPaymentAgreementDtlDO.receiptPaymentAgreementDtlDO;

    public PagingVO<ReceiptPaymentAgreementDtlDTO> page(ReceiptPaymentAgreementDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ReceiptPaymentAgreementDtlDTO> query = select(ReceiptPaymentAgreementDtlDTO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qReceiptPaymentAgreementDtlDO);
        return PagingVO.<ReceiptPaymentAgreementDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<ReceiptPaymentAgreementDtlVO> selectListByParam(ReceiptPaymentAgreementDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ReceiptPaymentAgreementDtlVO> query = select(ReceiptPaymentAgreementDtlVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }


    private List<Predicate> where(ReceiptPaymentAgreementDtlPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();


        if (!StringUtils.isEmpty(pageParam.getPeriodType())) {
            predicates.add(qReceiptPaymentAgreementDtlDO.periodType.eq(pageParam.getPeriodType()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getPeriodTypeList())){
            predicates.add(qReceiptPaymentAgreementDtlDO.periodType.in(pageParam.getPeriodTypeList()));
        }

        if (Objects.nonNull(pageParam.getId())){
            predicates.add(qReceiptPaymentAgreementDtlDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qReceiptPaymentAgreementDtlDO.id.in(pageParam.getIdList()));
        }
        if (Objects.nonNull(pageParam.getMasId())){
            predicates.add(qReceiptPaymentAgreementDtlDO.masId.eq(pageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIdList())) {
            predicates.add(qReceiptPaymentAgreementDtlDO.masId.in(pageParam.getMasIdList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qReceiptPaymentAgreementDtlDO.id,
                qReceiptPaymentAgreementDtlDO.masId,
                qReceiptPaymentAgreementDtlDO.lineNo,
                qReceiptPaymentAgreementDtlDO.periodType,
                qReceiptPaymentAgreementDtlDO.collectionInstallments,
                qReceiptPaymentAgreementDtlDO.collectionRatio,
                qReceiptPaymentAgreementDtlDO.startEffectiveDate,
                qReceiptPaymentAgreementDtlDO.validityDateDelayDays,
                qReceiptPaymentAgreementDtlDO.periodDays,
                qReceiptPaymentAgreementDtlDO.effectiveAdditionalMonth,
                qReceiptPaymentAgreementDtlDO.effectiveDate,
                qReceiptPaymentAgreementDtlDO.remark,
                qReceiptPaymentAgreementDtlDO.createTime,
                qReceiptPaymentAgreementDtlDO.createUserId,
                qReceiptPaymentAgreementDtlDO.creator,
                qReceiptPaymentAgreementDtlDO.modifyTime,
                qReceiptPaymentAgreementDtlDO.modifyUserId,
                qReceiptPaymentAgreementDtlDO.updater,
                qReceiptPaymentAgreementDtlDO.deleteFlag
        )).from(qReceiptPaymentAgreementDtlDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qReceiptPaymentAgreementDtlDO)
                .set(qReceiptPaymentAgreementDtlDO.deleteFlag, deleteFlag)
                .where(qReceiptPaymentAgreementDtlDO.masId.in(masIds))
                .execute();
    }

}
