package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinJournalConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.repo.accountingengine.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinJournalServiceImpl implements FinJournalService {


    private final FinJournalRepo finJournalRepo;

    private final FinJournalRepoProc finJournalRepoProc;
    private final FinSetOfBookService finSetOfBookService;
    private final FinSetOfBookLineService finSetOfBookLineService;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleRepo finFlexibleRepo;



    @SysCodeProc
    @Override
    public PagingVO<FinJournalVO> page(FinJournalParam finJournalParam) {
        PagingVO<FinJournalVO> finJournalVOPagingVO = FinJournalConvert.INSTANCE.DTOToVO(finJournalRepoProc.page(finJournalParam));
        if(CollectionUtils.isEmpty(finJournalVOPagingVO.getRecords())){
            return finJournalVOPagingVO;
        }
      /*  List<Long> accEngDetDataIds = finJournalVOPagingVO.getRecords().stream().map(v -> v.getAccEngDetDataId()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(accEngDetDataIds)){
            return finJournalVOPagingVO;
        }
        //查询配置
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOS = finAccEngDetDataLineRepo.findByMasIdInAndSourceType(accEngDetDataIds, UdcEnum.SOURCE_TYPE_FLEXIBLE.getValueCode());
        if(CollectionUtils.isEmpty(finAccEngDetDataLineDOS)){
            return finJournalVOPagingVO;
        }
        Map<Long, List<FinAccEngDetDataLineDO>> finAccEngDetDataLineMap = finAccEngDetDataLineDOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        List<String> flexibleValueCodes = finAccEngDetDataLineDOS.stream().filter(v -> StringUtils.isNotBlank(v.getFlexibleCode())).map(v->v.getFlexibleCode()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(flexibleValueCodes)){
            return finJournalVOPagingVO;
        }*/
       /* List<FinFlexibleValueDO> finFlexibleValueDOS = finFlexibleValueRepo.findByFlexibleValueCodeIn(flexibleValueCodes);
        if(CollectionUtils.isEmpty(finFlexibleValueDOS)){
            return finJournalVOPagingVO;
        }*/
        //Map<Long, List<FinFlexibleValueDO>> finFlexibleValueDOMap = finFlexibleValueDOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        //查询账簿配置
        List<String> sobCodes = finJournalVOPagingVO.getRecords().stream().map(v -> v.getSobLedgerCode()).collect(Collectors.toList());
        List<FinSetOfBookDTO> finSetOfBookDTOS = finSetOfBookService.findBySobCodes(sobCodes);
        if(CollectionUtils.isEmpty(finSetOfBookDTOS)){
            return finJournalVOPagingVO;
        }
        List<Long> sobIds = finSetOfBookDTOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = finSetOfBookLineService.findByMasIds(sobIds);
        if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
            return finJournalVOPagingVO;
        }
        finSetOfBookLineDTOList=finSetOfBookLineDTOList.stream().filter(v->Boolean.TRUE.equals(v.getFlexibleFlag())&& StringUtils.isNotBlank(v.getFlexibleCode())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
            return finJournalVOPagingVO;
        }
        List<String> flexibleCodes = finSetOfBookLineDTOList.stream().filter(v -> StringUtils.isNotBlank(v.getFlexibleCode())).map(v -> v.getFlexibleCode()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(flexibleCodes)){
            return finJournalVOPagingVO;
        }
        List<FinFlexibleDO> finFlexibleDOS = finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        if(CollectionUtils.isEmpty(finFlexibleDOS)){
            return finJournalVOPagingVO;
        }
        List<Long> finFlexibleIds = finFlexibleDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinFlexibleValueDO> finFlexibleValueDOS = finFlexibleValueRepo.findAllByMasIdIn(finFlexibleIds);
        if(CollectionUtils.isEmpty(finFlexibleValueDOS)){
            return finJournalVOPagingVO;
        }
        Map<Long, List<FinFlexibleValueDO>> finFlexibleValueMap = finFlexibleValueDOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        Map<String, Long>  finFlexibleMap= finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> v.getId(), (o, n) -> n));
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOListFinal = finSetOfBookLineDTOList;
        Map<String, Map<String, String>> setOfBookLineMap = finSetOfBookDTOS.stream().collect(Collectors.toMap(v -> v.getSobCode(), v -> finSetOfBookLineDTOListFinal.stream().filter(w -> v.getId().equals(w.getMasId())).collect(Collectors.toMap(j -> j.getColumnName(), j -> j.getFlexibleCode()))));
            for (FinJournalVO record : finJournalVOPagingVO.getRecords()) {
               /* Long accEngDetDataId = record.getAccEngDetDataId();
                if(accEngDetDataId==null){
                    continue;
                }*/
                /*List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOS1 = finAccEngDetDataLineMap.get(accEngDetDataId);
                if(CollectionUtils.isEmpty(finAccEngDetDataLineDOS1)){
                    continue;
                }*/
                String sobLedgerCode = record.getSobLedgerCode();
                Map<String, String> stringFinSetOfBookLineDTOMap = setOfBookLineMap.get(sobLedgerCode);
                if(stringFinSetOfBookLineDTOMap==null){
                    continue;
                }
                Set<String> columnNames = stringFinSetOfBookLineDTOMap.keySet();
                for (String columnName : columnNames) {
                    String flexibleCode = stringFinSetOfBookLineDTOMap.get(columnName);
                    if(StringUtils.isBlank(flexibleCode)){
                        continue;
                    }
                    Long  finFlexibleId= finFlexibleMap.get(flexibleCode);
                    if(finFlexibleId==null){
                        continue;
                    }
                    List<FinFlexibleValueDO> finFlexibleValueDOS1 = finFlexibleValueMap.get(finFlexibleId);
                    if(CollectionUtils.isEmpty(finFlexibleValueDOS1)){
                        continue;
                    }
                    Map<String, String> finFlexibleValueMap1 = finFlexibleValueDOS1.stream().collect(Collectors.toMap(v -> v.getFlexibleValueCode(), v -> v.getFlexibleValueName(), (o, n) -> n));
                    String finFlexibleValueCode1 = record.getField(columnName);
                    if(StringUtils.isBlank(finFlexibleValueCode1)){
                        continue;
                    }
                    String finFlexibleValue1=finFlexibleValueMap1.get(finFlexibleValueCode1);
                    if(StringUtils.isBlank(finFlexibleValue1)){
                        continue;
                    }
                    record.setField(columnName,finFlexibleValueCode1+"-"+finFlexibleValue1);
                }
            /*    for (FinAccEngDetDataLineDO finAccEngDetDataLineDO : finAccEngDetDataLineDOS1) {
                    String columnName = finAccEngDetDataLineDO.getColumnName();
                    String flexibleValueCode = finAccEngDetDataLineDO.getFlexibleCode();
                    if(StringUtils.isBlank(flexibleValueCode)){
                        continue;
                    }
                    String flexibleCode = stringFinSetOfBookLineDTOMap.get(columnName).getFlexibleCode();
                    if(StringUtils.isBlank(flexibleCode)){
                        continue;
                    }
                    Long finFlexibleId = finFlexibleMap.get(flexibleCode);
                    List<FinFlexibleValueDO> finFlexibleValueDOS1 = finFlexibleValueDOMap.get(finFlexibleId);
                    if(CollectionUtils.isEmpty(finFlexibleValueDOS1)){
                        continue;
                    }
                    Optional<FinFlexibleValueDO> first = finFlexibleValueDOS1.stream().filter(v -> flexibleValueCode.equals(v.getFlexibleValueCode())).findFirst();
                    if(first.isPresent()){
                        record.setField(columnName,first.get().getFlexibleValueName());
                    }
                }*/
            }
        return finJournalVOPagingVO;
    }

}
