/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.application.facade.dto.mq.AdjustOrderSubmitProcessMqMessageDTO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.fin.utils.TransactionCommitHandler;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdjustOrderSubmitJob {
    private static final Logger log = LoggerFactory.getLogger(AdjustOrderSubmitJob.class);
    private final AdjustOrderRepo adjustOrderRepo;
    private final TransactionCommitHandler transactionCommitHandler;
    private final MessageQueueTemplate messageQueueTemplate;

    @XxlJob(value="importAdjustOrderAutoSubmit")
    public ReturnT<String> submitDraftAdjustOrders(String param) {
        try {
            log.info("\u5f00\u59cb\u626b\u63cf\u8349\u7a3f\u72b6\u6001\u7684\u8c03\u6574\u5355...");
            List<AdjustOrderDO> draftOrders = this.adjustOrderRepo.findAllByStateAndProcessStatus(UdcEnum.APPLY_STATUS_DRAFT.getValueCode(), "TODO");
            if (draftOrders != null && !draftOrders.isEmpty()) {
                log.info("\u627e\u5230 {} \u6761\u8349\u7a3f\u72b6\u6001\u5e76\u4e14\u5f85\u5904\u7406\u7684\u8c03\u6574\u5355\uff0c\u5f00\u59cb\u63d0\u4ea4...", (Object)draftOrders.size());
                for (AdjustOrderDO draftOrder : draftOrders) {
                    AdjustOrderSubmitProcessMqMessageDTO messageDTO = new AdjustOrderSubmitProcessMqMessageDTO();
                    messageDTO.setId(draftOrder.getId());
                    messageDTO.setBusinessKey(draftOrder.getDocNo());
                    try {
                        this.messageQueueTemplate.publishMessage("yst-fin", "adjust_order_submit_process", (Serializable)messageDTO);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u5904\u7406\u5bfc\u5165\u8c03\u6574\u5355\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
                    }
                }
            } else {
                log.info("\u672a\u627e\u5230\u8349\u7a3f\u72b6\u6001\u7684\u8c03\u6574\u5355");
            }
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u63d0\u4ea4\u8349\u7a3f\u8c03\u6574\u5355\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return ReturnT.SUCCESS;
    }

    public AdjustOrderSubmitJob(AdjustOrderRepo adjustOrderRepo, TransactionCommitHandler transactionCommitHandler, MessageQueueTemplate messageQueueTemplate) {
        this.adjustOrderRepo = adjustOrderRepo;
        this.transactionCommitHandler = transactionCommitHandler;
        this.messageQueueTemplate = messageQueueTemplate;
    }
}

