/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.recorder;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtl;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.factory.recorder.RecOrderFactory;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.fin.utils.BigDecimalUtils;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderDomainServiceImpl
implements RecOrderDomainService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderDomainServiceImpl.class);
    private final AccountService accountService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderFactory recOrderFactory;
    private final RecOrderRepo recOrderRepo;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final RecOrderDtlRepo recOrderDtlRepo;
    private final SeqNumProvider sysNumberRuleService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RmiSaleRpcService rmiSaleRpcService;

    @Override
    public PagingVO<RecOrderDTO> page(RecOrderPageParam param) {
        if (param.getReDateStart() == null || param.getReDateEnd() == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u6536\u6b3e\u65e5\u671f!");
        }
        return this.recOrderFactory.recOrderPage(param);
    }

    @Override
    public PagingVO<RecOrderDTO> writeoffPage(RecOrderPageParam param) {
        return this.recOrderFactory.writeoffPage(param);
    }

    @Override
    public RecOrderDTO queryById(Long id, Boolean flag) {
        if (flag.booleanValue()) {
            RecOrderDTO payOrderDTO = this.recOrderRepoProc.queryById(id);
            List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasId(id);
            payOrderDTO.setDtlDTOS(recOrderDtlDTOS);
            return payOrderDTO;
        }
        return this.recOrderRepoProc.queryById(id);
    }

    @Override
    public List<RecOrderDTO> queryByIds(List<Long> ids, Boolean flag) {
        if (flag.booleanValue()) {
            List<RecOrderDTO> recOrderDTOS = this.recOrderRepoProc.queryByIds(ids);
            List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasIds(ids);
            Map<Long, List<RecOrderDtlDTO>> dtlGroupData = recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getMasId()));
            for (RecOrderDTO recOrderDTO : recOrderDTOS) {
                if (!dtlGroupData.containsKey(recOrderDTO.getId())) continue;
                recOrderDTO.setDtlDTOS(dtlGroupData.get(recOrderDTO.getId()));
            }
            return recOrderDTOS;
        }
        return this.recOrderRepoProc.queryByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        List<RecOrderDTO> recOrderDTOS = this.recOrderRepoProc.queryByIds(ids);
        recOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u8349\u7a3f\u7684\u6536\u6b3e\u5355!");
            }
            if (Objects.nonNull(dto.getRedSourceNo())) {
                this.recOrderRepoProc.setRedFlag(dto.getRedSourceId(), false);
            }
        });
        this.recOrderRepoProc.deleteById(ids);
        this.recOrderDtlRepoProc.deleteByMasId(ids);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RecOrder recOrder) {
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            String recOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "SKD", null);
            recOrder.setRecOrderNo(recOrderNo);
        }
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        recOrder.checkNotNull(recOrder.getCreateMode());
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            if (recOrder.getId() == null) {
                recOrder.setSoDef();
                recOrder.checkDtl(false);
                recOrder.countBySo();
                recOrder.checkTotalMoney();
            }
        } else {
            recOrder.checkTotalMoney();
        }
        if (StrUtil.isBlank((CharSequence)recOrder.getOrderState())) {
            recOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        this.handleRecOrder(recOrder);
        return this.updateOrSave(recOrder).getId();
    }

    private void handleRecOrder(RecOrder recOrder) {
        CustBaseDTO crmCustBaseDTO;
        Map<String, CustBaseDTO> custMap;
        if (StringUtils.isBlank((CharSequence)recOrder.getRecOuCode())) {
            recOrder.setRecOuCode(recOrder.getOuCode());
        }
        if (StringUtils.isBlank((CharSequence)recOrder.getCurrCode())) {
            recOrder.setCurrCode("CNY");
        }
        if ((StringUtils.isBlank((CharSequence)recOrder.getInOutCust()) || StringUtils.isBlank((CharSequence)recOrder.getRelevanceOuCode())) && MapUtil.isNotEmpty(custMap = this.rmiSaleRpcService.findBaseCustMapByCodes(Collections.singletonList(recOrder.getCustCode()))) && custMap.containsKey(recOrder.getCustCode()) && Objects.nonNull(crmCustBaseDTO = custMap.get(recOrder.getCustCode()))) {
            if (StringUtils.isBlank((CharSequence)recOrder.getInOutCust()) && StringUtils.isNotBlank((CharSequence)crmCustBaseDTO.getInOutCust())) {
                recOrder.setInOutCust(crmCustBaseDTO.getInOutCust());
            }
            if (Objects.equals(crmCustBaseDTO.getCustType2(), "C") && StringUtils.isBlank((CharSequence)recOrder.getRelevanceOuCode())) {
                recOrder.setRelevanceOuCode(crmCustBaseDTO.getCorBusinCode());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(RecOrder recOrder, Boolean auto) {
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "SKD", null);
            recOrder.setRecOrderNo(payOrderNo);
        }
        recOrder.checkNotNull(recOrder.getCreateMode());
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            recOrder.checkTotalMoney();
        }
        recOrder.checkMoney();
        recOrder.checkDtl(true);
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        if (auto.booleanValue()) {
            recOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
            recOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            recOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        this.handleRecOrder(recOrder);
        RecOrderDO recOrderDO = this.updateOrSave(recOrder);
        return recOrderDO.getId();
    }

    @Override
    public List<RecOrderDTO> queryByRecTypeId(List<Long> recTypeId) {
        return this.recOrderRepoProc.queryByRecTypeId(recTypeId);
    }

    @Override
    public List<RecOrderDTO> queryByParam(RecOrderParam recOrderParam) {
        return this.recOrderRepoProc.getRecOrderList(recOrderParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = this.recOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = this.recOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0L) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u6536\u6b3e\u5355\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.recOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    @Override
    public RecOrder redPunchCreate(Long id) {
        RecOrderDO recOrderDO = (RecOrderDO)this.recOrderRepo.getReferenceById(id);
        recOrderDO.setRedState(Boolean.TRUE);
        this.recOrderRepo.save(recOrderDO);
        RecOrder newRecOrder = (RecOrder)BeanUtils.toBean((Object)recOrderDO, RecOrder.class);
        newRecOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newRecOrder.setProcInstId(null);
        newRecOrder.setProcInstStatus(null);
        newRecOrder.setRedState(null);
        newRecOrder.setRedSourceNo(recOrderDO.getRecOrderNo());
        newRecOrder.setRedSourceId(recOrderDO.getId());
        newRecOrder.setTaxAmt(BigDecimalUtils.negate(newRecOrder.getTaxAmt()));
        newRecOrder.setTotalAmt(BigDecimalUtils.negate(newRecOrder.getTotalAmt()));
        newRecOrder.setRealRecAmt(BigDecimalUtils.negate(newRecOrder.getRealRecAmt()));
        newRecOrder.setTotalCurAmt(BigDecimalUtils.negate(newRecOrder.getTotalCurAmt()));
        newRecOrder.setTaxCurAmt(BigDecimalUtils.negate(newRecOrder.getTaxCurAmt()));
        newRecOrder.setRealRecCurAmt(BigDecimalUtils.negate(newRecOrder.getRealRecCurAmt()));
        newRecOrder.setId(null);
        newRecOrder.setRecOrderNo(null);
        newRecOrder.setProposedStatus(null);
        newRecOrder.setAuditUser(null);
        newRecOrder.setApprovedTime(null);
        newRecOrder.setAuditUserId(null);
        newRecOrder.setRemark(null);
        List<RecOrderDtlDO> dtls = this.recOrderDtlRepo.findAllByMasId(id);
        List<RecOrderDtl> newDtls = dtls.stream().map(dtl -> {
            RecOrderDtl dtlDO = (RecOrderDtl)BeanUtils.toBean((Object)dtl, RecOrderDtl.class);
            dtlDO.setId(null);
            dtlDO.setTaxAmt(BigDecimalUtils.negate(dtl.getTaxAmt()));
            dtlDO.setTotalAmt(BigDecimalUtils.negate(dtl.getTotalAmt()));
            dtlDO.setRealRecAmt(BigDecimalUtils.negate(dtl.getRealRecAmt()));
            dtlDO.setTotalCurAmt(BigDecimalUtils.negate(dtl.getTotalCurAmt()));
            dtlDO.setTaxCurAmt(BigDecimalUtils.negate(dtl.getTaxCurAmt()));
            dtlDO.setRealRecCurAmt(BigDecimalUtils.negate(dtl.getRealRecCurAmt()));
            return dtlDO;
        }).collect(Collectors.toList());
        newRecOrder.setDtlList(newDtls);
        newRecOrder.setCheck(false);
        return newRecOrder;
    }

    @Override
    public void createFinFlow(RecOrderDTO recOrderDTO) {
        log.info("\u6536\u6b3e\u5355\u751f\u6210\u6d41\u6c34:{}", (Object)JSONUtil.toJsonStr((Object)recOrderDTO));
        AccountParam accountParam = new AccountParam();
        accountParam.setSecOuCode(recOrderDTO.getOuCode());
        accountParam.setAccountHolderCode(recOrderDTO.getCustCode());
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountDTO> accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
        Optional<AccountDTO> storeAccountOptional = accountDTOList.stream().filter(e -> "STORE".equals(e.getAccountType())).findFirst();
        if (storeAccountOptional.isEmpty()) {
            log.info("\u4e0d\u5b58\u5728\u50a8\u503c\u8d26\u6237,\u4e0d\u751f\u6210\u6d41\u6c34");
            return;
        }
        AccountDTO accountDTO = storeAccountOptional.get();
        ArrayList<GenerateAccountFlowRpcParam> params = new ArrayList<GenerateAccountFlowRpcParam>();
        params.add(this.createGenerateAccountFlowRpcParam("SKD", "SKD", "COMPLETE", recOrderDTO.getRecOrderNo(), recOrderDTO.getId(), "STORE", accountDTO.getAccountTypeName(), accountDTO.getAccountCode(), accountDTO.getAccountName(), recOrderDTO.getTotalAmt()));
        log.info("\u8c03\u7528\u8d22\u52a1\u57df\u751f\u6210\u8d26\u6237\u6d41\u6c34,\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(params));
        List<GenerateAccountFlowRpcDTO> generateAccountFlowRpcDTOS = this.generateAccountFlow(params, Boolean.TRUE);
        log.info("\u8c03\u7528\u8d22\u52a1\u57df\u751f\u6210\u8d26\u6237\u6d41\u6c34,\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(generateAccountFlowRpcDTOS));
    }

    @Override
    public PagingVO<RecOrderEntity> exportRecOrder(RecOrderPageParam param) {
        Long count = this.recOrderRepoProc.countExportRecOrder(param);
        if (count > 0L) {
            List<RecOrderEntity> payOrderDTOS = this.recOrderRepoProc.exportRecOrder(param);
            return new PagingVO(count.longValue(), payOrderDTOS);
        }
        return new PagingVO();
    }

    private List<GenerateAccountFlowRpcDTO> generateAccountFlow(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList, Boolean needMerge) {
        ApiResult refundResult;
        log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u53c2\u6570(\u5408\u5e76\u524d)\uff1a{}", (Object)JSONUtil.toJsonStr(generateAccountFlowRpcParamList));
        GenerateAccountFlowRpcService rpcService = (GenerateAccountFlowRpcService)SpringUtil.getBean(GenerateAccountFlowRpcService.class);
        if (needMerge.booleanValue()) {
            List<GenerateAccountFlowRpcParam> params = RecOrderDomainServiceImpl.mergeParams(generateAccountFlowRpcParamList);
            log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u53c2\u6570(\u5408\u5e76\u540e)\uff1a{}", (Object)JSONUtil.toJsonStr(params));
            refundResult = rpcService.generateAccountFlow(params);
        } else {
            refundResult = rpcService.generateAccountFlow(generateAccountFlowRpcParamList);
        }
        log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr((Object)refundResult));
        if (!refundResult.isSuccess()) {
            throw new BusinessException("\u8d22\u52a1\u57df\u751f\u6210\u6d41\u6c34\u62a5\u9519\uff1a" + refundResult.getMsg());
        }
        return (List)refundResult.getData();
    }

    private static List<GenerateAccountFlowRpcParam> mergeParams(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList) {
        HashMap<CallSite, GenerateAccountFlowRpcParam> generateAccountFlowRpcParamMap = new HashMap<CallSite, GenerateAccountFlowRpcParam>();
        for (GenerateAccountFlowRpcParam generateAccountFlowRpcParam : generateAccountFlowRpcParamList) {
            String key = generateAccountFlowRpcParam.getAccountType() + "-" + generateAccountFlowRpcParam.getAccountCode();
            if (!generateAccountFlowRpcParamMap.containsKey(key)) {
                generateAccountFlowRpcParamMap.put((CallSite)((Object)key), generateAccountFlowRpcParam);
                continue;
            }
            GenerateAccountFlowRpcParam param = (GenerateAccountFlowRpcParam)generateAccountFlowRpcParamMap.get(key);
            param.setDocAmount(param.getDocAmount().add(generateAccountFlowRpcParam.getDocAmount()));
        }
        return new ArrayList<GenerateAccountFlowRpcParam>(generateAccountFlowRpcParamMap.values());
    }

    private GenerateAccountFlowRpcParam createGenerateAccountFlowRpcParam(String docNo, String docType, String docStatus, String soDocNo, Long sourceId, String accountType, String accountTypeName, String payAccNo, String payAccName, BigDecimal docAmount) {
        GenerateAccountFlowRpcParam param = new GenerateAccountFlowRpcParam();
        param.setDoc(docNo);
        param.setDocType(docType);
        param.setDocStatus(docStatus);
        param.setDocAmount(docAmount);
        param.setSourceId(sourceId);
        param.setSourceNo(soDocNo);
        param.setAccountType(accountType);
        param.setAccountTypeName(accountTypeName);
        param.setAccountCode(payAccNo);
        param.setAccountName(payAccName);
        log.info("\u6d41\u6c34\u6784\u9020\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private RecOrderDO updateOrSave(RecOrder recOrder) {
        RecOrderDO recOrderDO = RecOrderConvert.INSTANCE.convertToDo(recOrder);
        if (recOrder.getId() != null) {
            this.recOrderDtlRepoProc.deleteByMasIds(List.of(recOrder.getId()));
        } else {
            recOrderDO.setAuditDataVersion(0);
        }
        this.flexFieldUtilService.handFlexFieldValueFeference("REC_ORDER", (Object)recOrderDO);
        RecOrderDO save = (RecOrderDO)this.recOrderRepo.saveAndFlush(recOrderDO);
        List<RecOrderDtlDO> recOrderDtlDOS = RecOrderDtlConvert.INSTANCE.convertToDO(recOrder.getDtlList());
        String sourceNo = recOrder.getSourceNo();
        recOrderDtlDOS.forEach(dtl -> {
            dtl.setMasId(save.getId());
            if (dtl.getId() == null) {
                dtl.setAuditDataVersion(0);
            }
            dtl.setUnVerAmt(dtl.getTotalAmt());
            dtl.setVerAmt(BigDecimal.ZERO);
            dtl.setApplyVerAmTing(BigDecimal.ZERO);
            if (StrUtil.isNotBlank((CharSequence)sourceNo)) {
                dtl.setSourceNo(sourceNo);
            }
        });
        this.recOrderDtlRepo.saveAllAndFlush(recOrderDtlDOS);
        return save;
    }

    public RecOrderDomainServiceImpl(AccountService accountService, RecOrderRepoProc recOrderRepoProc, RecOrderFactory recOrderFactory, RecOrderRepo recOrderRepo, RecOrderDtlRepoProc recOrderDtlRepoProc, RecOrderDtlRepo recOrderDtlRepo, SeqNumProvider sysNumberRuleService, FlexFieldUtilService flexFieldUtilService, RmiSaleRpcService rmiSaleRpcService) {
        this.accountService = accountService;
        this.recOrderRepoProc = recOrderRepoProc;
        this.recOrderFactory = recOrderFactory;
        this.recOrderRepo = recOrderRepo;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.recOrderDtlRepo = recOrderDtlRepo;
        this.sysNumberRuleService = sysNumberRuleService;
        this.flexFieldUtilService = flexFieldUtilService;
        this.rmiSaleRpcService = rmiSaleRpcService;
    }
}

