/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.paytype;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.paytype.QPayTypeOuDO;
import com.elitesland.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.fin.infr.dto.paytype.PayTypeOuDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PayTypeOuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayTypeOuDO qPayTypeOuDO = QPayTypeOuDO.payTypeOuDO;

    public List<PayTypeOuDTO> queryByPayTypeIds(List<Long> payTypeIds) {
        return ((JPAQuery)this.select(PayTypeOuDTO.class).where((Predicate)this.qPayTypeOuDO.payTypeId.in(payTypeIds))).fetch();
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qPayTypeOuDO).where(new Predicate[]{this.qPayTypeOuDO.id.in(ids)}).execute();
    }

    public List<Long> queryByOuId(Long ouId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qPayTypeOuDO.payTypeId).from((EntityPath)this.qPayTypeOuDO)).where((Predicate)this.qPayTypeOuDO.ouId.eq((Object)ouId))).fetch();
    }

    public PagingVO<PayTypeOuDTO> page(PayTypeOuPageParam payTypeOuParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (payTypeOuParam.getPayTypeId() != null) {
            predicates.add(this.qPayTypeOuDO.payTypeId.eq((Object)payTypeOuParam.getPayTypeId()));
        }
        if (!StringUtils.isEmpty((CharSequence)payTypeOuParam.getOuNameOrCode())) {
            predicates.add(this.qPayTypeOuDO.ouName.like("%" + payTypeOuParam.getOuNameOrCode() + "%").or((Predicate)this.qPayTypeOuDO.ouCode.like("%" + payTypeOuParam.getOuNameOrCode() + "%")));
        }
        JPAQuery query = (JPAQuery)this.select(PayTypeOuDTO.class).where(ExpressionUtils.allOf(predicates));
        payTypeOuParam.setPaging(query);
        payTypeOuParam.fillOrders(query, this.qPayTypeOuDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayTypeOuDO.id, this.qPayTypeOuDO.payTypeId, this.qPayTypeOuDO.ouCode, this.qPayTypeOuDO.ouId, this.qPayTypeOuDO.ouName, this.qPayTypeOuDO.ouType})).from((EntityPath)this.qPayTypeOuDO);
    }

    public PayTypeOuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

