/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.ystsupp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuComRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgOuComRpcParam;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RmiOrgOuRpcServiceServiceImpl
implements RmiOrgOuRpcServiceService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgOuRpcServiceServiceImpl.class);
    private final OrgOuRpcService orgOuRpcService;

    @Override
    public List<OrgOuRpcDTO> findOuDtoByParam(OrgOuRpcDtoParam param) {
        List orgOuRpcDTOList = this.orgOuRpcService.findOuDtoByParam(param);
        Assert.notNull((Object)orgOuRpcDTOList, (String)"\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        return orgOuRpcDTOList;
    }

    @Override
    public List<OrgOuComRpcDTO> findOuDtoByParam(OrgOuComRpcParam param) {
        log.info("findOuDtoByParam param:{}", (Object)JSONUtil.toJsonStr((Object)param));
        List data = this.orgOuRpcService.selectComOuByParam(param);
        log.info("findOuDtoByParam data:{}", (Object)JSONUtil.toJsonStr((Object)data));
        return data;
    }

    @Override
    public List<OrgOuRpcSimpleDTO> findBaseOuByCodes(List<String> ouCodes) {
        if (CollectionUtil.isEmpty(ouCodes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            List orgOuRpcSimpleDTOList = this.orgOuRpcService.findSimpleByOuCodes(ouCodes);
            if (CollectionUtil.isNotEmpty((Collection)orgOuRpcSimpleDTOList)) {
                return orgOuRpcSimpleDTOList;
            }
        }
        catch (Exception e) {
            log.error("findBaseOuByCodes error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u57fa\u7840\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, OrgOuRpcSimpleDTO> findBaseOuMapByCodes(List<String> ouCodes) {
        List<OrgOuRpcSimpleDTO> rpcDTOList = this.findBaseOuByCodes(ouCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<String, OrgOuRpcSimpleDTO>();
        }
        Map<String, OrgOuRpcSimpleDTO> ouMap = rpcDTOList.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, t -> t, (t1, t2) -> t1));
        return ouMap;
    }

    @Override
    public List<OrgOuBankRpcDTO> findOuBank(Long ouId) {
        log.info("\u67e5\u8be2\u516c\u53f8\u94f6\u884c\u4fe1\u606f,\u5165\u53c2:{}", (Object)ouId);
        List ouBankData = this.orgOuRpcService.findOuBank(ouId);
        log.info("\u67e5\u8be2\u516c\u53f8\u94f6\u884c\u4fe1\u606f,\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)ouBankData));
        return ouBankData;
    }

    public RmiOrgOuRpcServiceServiceImpl(OrgOuRpcService orgOuRpcService) {
        this.orgOuRpcService = orgOuRpcService;
    }
}

