package com.elitesland.fin.application.service.unionpay.entity.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author sunxw
 * @description 银联支付同步响应resp
 * @Date 2023/5/18
 */
@Data
public class UnionPaySyncResp {

    /** 版本号 认证支付和快捷支付：20150922 其余：20140728 */
    @JSONField(name = "Version")
    private Integer version;

    /** 0：商户身份接入（默认） 1：机构身份接入 */
    @JSONField(name = "AccessType")
    private Integer accessType;

    /** 机构编号，以机构身份接时必填 */
    @JSONField(name = "InstuId")
    private Long instuId;

    /** 收单机构号 */
    @JSONField(name = "AcqCode")
    private Long acqCode;

    /** 商户号:由 ChinaPay 分配的 15 位长数字，用于确认商户身份 */
    @JSONField(name = "MerId")
    private Long merId;

    /** 交易类型 */
    @JSONField(name = "TranType")
    private Integer tranType;

    /** 0014：接受成功；快捷支付时，只有返回3470 状态码，才会返回签约要素字段 */
    private Integer respCode;

    /** 响应信息 */
    private String respMsg;

    /** 响应保留域 */
    @JSONField(name = "TransExtField")
    private String transExtField;

    /** 签名 */
    @JSONField(name = "Signature")
    private String signature;

}
