package com.elitesland.fin.common;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/4/13
 */
public enum UdcEnum {
    COM_OU_TYPE_10("yst-supp", "OU_TYPE", "公司类型", "10", "供应链公司"),
    COM_OU_TYPE_20("yst-supp", "OU_TYPE", "公司类型", "20", "非供应链公司"),
    COM_OU_TYPE_50("yst-supp", "OU_TYPE", "公司类型", "50", "门店"),

    COM_PUSH_RESULT_PUSH("yst-supp", "PUSH_RESULT", "推送结果", "PUSH", "推送中"),
    COM_PUSH_RESULT_NOOP("yst-supp", "PUSH_RESULT", "推送结果", "NOOP", "无需推送"),
    COM_PUSH_RESULT_SUCCESS("yst-supp", "PUSH_RESULT", "推送结果", "SUCC", "成功"),
    COM_PUSH_RESULT_FAIL("yst-supp", "PUSH_RESULT", "推送结果", "FAIL", "失败"),

    //中台产品状态UDC
    APPLY_STATUS_DRAFT("yst-supp", "APPLY_STATUS", "申请单状态", "DRAFT", "待提交"),
    APPLY_STATUS_DOING("yst-supp", "APPLY_STATUS", "申请单状态", "DOING", "审批中"),
    APPLY_STATUS_REJECTED("yst-supp", "APPLY_STATUS", "申请单状态", "REJECTED", "审批拒绝"),
    APPLY_STATUS_COMPLETE("yst-supp", "APPLY_STATUS", "申请单状态", "COMPLETE", "审批通过"),
    APPLY_STATUS_VOID("yst-supp", "APPLY_STATUS", "申请单状态", "VOID", "作废"),
    APPLY_STATUS_EXPIRED("yst-supp", "APPLY_STATUS", "申请单状态", "EXPIRED", "失效"),
    APPLY_STATUS_ACTIVE("yst-supp", "APPLY_STATUS", "申请单状态", "ACTIVE", "生效"),
    APPLY_STATUS_INV_SUCCESS("yst-supp", "APPLY_STATUS", "申请单状态", "INV_SUCCESS", "开票成功"),
    APPLY_STATUS_INV_FAIL("yst-supp", "APPLY_STATUS", "申请单状态", "INV_FAIL", "开票失败"),
    APPLY_STATUS_RED_SUCCESS("yst-supp", "APPLY_STATUS", "申请单状态", "RED_SUCCESS", "已红冲"),

    INVOICE_STATUS_DRAFT("yst-supp", "INVOICE_STATUS", "申请单状态", "DRAFT", "待提交"),
    INVOICE_STATUS_APPLY_FAIL("yst-supp", "INVOICE_STATUS", "申请单状态", "APPLY_FAIL", "申请失败"),
    INVOICE_STATUS_INVOICING("yst-supp", "INVOICE_STATUS", "申请单状态", "INVOICING", "开票中"),
    INVOICE_STATUS_SUCCESS("yst-supp", "INVOICE_STATUS", "申请单状态", "SUCCESS", "开票成功"),
    INVOICE_STATUS_FAIL("yst-supp", "INVOICE_STATUS", "申请单状态", "FAIL", "开票失败"),
    INVOICE_STATUS_RED_SUCCESS("yst-supp", "INVOICE_STATUS", "申请单状态", "RED_SUCCESS", "已红冲"),

    //核销状态
    FIN_VERIFY_STATUS_PART("FIN", "VERIFY_STATUS", "核销状态", "PART", "部分核销"),
    FIN_VERIFY_STATUS_YES("FIN", "VERIFY_STATUS", "核销状态", "YES", "完全核销"),
    FIN_VERIFY_STATUS_NO("FIN", "VERIFY_STATUS", "核销状态", "NO", "无需核销"),
    FIN_VERIFY_STATUS_AWAIT("FIN", "VERIFY_STATUS", "核销状态", "AWAIT", "待核销"),

    //传输状态
    FIN_TRANSFER_STATE_SUCCESS("FIN", "TRANSFER_STATE", "传输状态", "SUCCESS", "传输成功"),
    FIN_TRANSFER_STATE_NO("FIN", "TRANSFER_STATE", "传输状态", "NO", "无需传输"),
    FIN_TRANSFER_STATE_AWAIT("FIN", "TRANSFER_STATE", "传输状态", "AWAIT", "待传输"),
    FIN_TRANSFER_STATE_FAIL("FIN", "TRANSFER_STATE", "传输状态", "FAIL", "传输失败"),

    //发票类型
    FIN_INV_TYPE_VANA("FIN", "INV_TYPE", "发票类型", "VANA", "增值税专票"),
    FIN_INV_TYPE_ELECTRONN("FIN", "INV_TYPE", "发票类型", "ELECTRON", "电子增值税普票"),
    FIN_INV_TYPE_PRODUCE("FIN", "INV_TYPE", "发票类型", "PRODUCE", "农产品收购发票和农产品销售发票"),
    FIN_INV_TYPE_VATN("FIN", "INV_TYPE", "发票类型", "VATN", "增值税普票"),
    FIN_INV_TYPE_NO("FIN", "INV_TYPE", "发票类型", "NO", "无"),
    //
    INV_TYPE_YYJ2301("FIN", "INV_TYPE", "发票类型", "YYJ2301", "专票"),
    INV_TYPE_YYJ2302("FIN", "INV_TYPE", "发票类型", "YYJ2302", "普票"),
    INV_TYPE_YYJ2303("FIN", "INV_TYPE", "发票类型", "YYJ2303", "不开票"),

    //开票状态
    INV_STATE_SUCCESS("yst-fin", "INV_STATE", "开票状态", "SUCCESS", "开票成功"),
    INV_STATE_CANCEL_SUCCESS("yst-fin", "INV_STATE", "作废成功", "CANCEL_SUCCESS", "作废成功"),
    INV_STATE_ING("yst-fin", "INV_STATE", "待开发票状态", "ING", "开票中"),
    INV_STATE_WAIT("yst-fin", "INV_STATE", "待开发票状态", "WAIT", "待开票"),
    INV_STATE_REJECT("yst-fin", "INV_STATE", "待开发票状态", "REJECT", "开票拒绝"),
    INV_STATE_FAIL("yst-fin", "INV_STATE", "待开发票状态", "FAIL", "开票失败"),
    INV_STATE_IN_CANCEL("yst-fin", "INV_STATE", "待开发票状态", "IN_CANCEL", "发票作废中"),
    INV_STATE_RED_SUCCESS("yst-fin", "INV_STATE", "开票状态", "RED_SUCCESS", "已红冲"),

    //小程序发票状态
    APP_INV_STATUS_COMPLETE("FIN", "APP_INV_STATUS", "发票状态", "COMPLETE", "已开票"),
    APP_INV_STATUS_INVOICING("FIN", "APP_INV_STATUS", "发票状态", "INVOICING", "开票中"),
    APP_INV_STATUS_FAIL("FIN", "APP_INV_STATUS", "发票状态", "FAIL", "开票失败"),


    // 	待开发票状态
    INVOICE_AWAIT_STATUS_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "SUCCESS", "开票成功"),
    INVOICE_AWAIT_STATUS_CANCEL_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "CANCEL_SUCCESS", "作废成功"),
    INVOICE_AWAIT_STATUS_ING("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "ING", "开票中"),
    INVOICE_AWAIT_STATUS_WAIT("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "WAIT", "待开票"),
    INVOICE_AWAIT_STATUS_REJECT("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "REJECT", "开票拒绝"),
    INVOICE_AWAIT_STATUS_FAIL("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "FAIL", "开票失败"),
    INVOICE_AWAIT_STATUS_RED_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "RED_SUCCESS", "已红冲"),


    //付款方式
    PUR_PAY_TYPE_TT("PUR", "PAY_TYPE", "付款方式", "TT", "银行转账"),
    PUR_PAY_TYPE_COMM_ACCE("PUR", "PAY_TYPE", "付款方式", "COMM_ACCE", "商业汇票"),
    PUR_PAY_TYPE_BANK_ACCE("PUR", "PAY_TYPE", "付款方式", "BANK_ACCE", "银行汇票"),
    PUR_PAY_TYPE_YX("PUR", "PAY_TYPE", "付款方式", "YX", "云信"),
    PUR_PAY_TYPE_WX("PUR", "PAY_TYPE", "付款方式", "WX", "微信"),
    PUR_PAY_TYPE_ALIPAY("PUR", "PAY_TYPE", "付款方式", "ALIPAY", "支付宝"),
    PUR_PAY_TYPE_CASH7("PUR", "PAY_TYPE", "付款方式", "CASH", "现金"),

    //收款方式
    COM_PAY_METHOD_CASH("COM", "PAY_METHOD", "收款方式", "CASH", "现金收款"),
    COM_PAY_METHOD_TT("COM", "PAY_METHOD", "收款方式", "TT", "银行转账"),
    COM_PAY_METHOD_CASH_CHEQUE("COM", "PAY_METHOD", "收款方式", "CASH_CHEQUE", "现金支票"),
    COM_PAY_METHOD_TRANS_CHEQUE("COM", "PAY_METHOD", "收款方式", "TRANS_CHEQUE", "转账支票"),
    COM_PAY_METHOD_BANK_ACCE("COM", "PAY_METHOD", "收款方式", "BANK_ACCE", "银行承兑汇票"),
    COM_PAY_METHOD_COMM_ACCE("COM", "PAY_METHOD", "收款方式", "COMM_ACCE", "商业承兑汇票"),
    COM_PAY_METHOD_OTHER_ELEC_BILL("COM", "PAY_METHOD", "收款方式", "OTHER_ELEC_BILL", "其他电子票据"),
    COM_PAY_METHOD_WX("COM", "PAY_METHOD", "收款方式", "WX", "微信"),
    COM_PAY_METHOD_ALIPAY("COM", "PAY_METHOD", "收款方式", "ALIPAY", "支付宝"),
    COM_PAY_METHOD_POINTS("COM", "PAY_METHOD", "收款方式", "POINTS", "积分"),
    COM_PAY_METHOD_DISC_COUPON("COM", "PAY_METHOD", "收款方式", "DISC_COUPON", "优惠券"),
    COM_PAY_METHOD_SHOP_CARD("COM", "PAY_METHOD", "收款方式", "SHOP_CARD", "购物卡"),
    COM_PAY_METHOD_GIFT_CARD("COM", "PAY_METHOD", "收款方式", "GIFT_CARD", "提货券"),
    COM_PAY_METHOD_VALUE_CARD("COM", "PAY_METHOD", "收款方式", "VALUE_CARD", "预储值卡"),

    //费用类型
    FIN_EXPENSES_TYPE_SCF("FIN", "EXPENSES_TYPE", "费用类型", "SCF", "市场费"),
    FIN_EXPENSES_TYPE_FLF("FIN", "EXPENSES_TYPE", "费用类型", "FLF", "福利费"),
    FIN_EXPENSES_TYPE_BGF("FIN", "EXPENSES_TYPE", "费用类型", "BGF", "办公费"),
    FIN_EXPENSES_TYPE_CLF("FIN", "EXPENSES_TYPE", "费用类型", "CLF", "差旅费"),
    FIN_EXPENSES_TYPE_YFF("FIN", "EXPENSES_TYPE", "费用类型", "YFF", "研发费用"),
    FIN_EXPENSES_TYPE_YWZDF("FIN", "EXPENSES_TYPE", "费用类型", "YWZDF", "业务招待费"),
    FIN_EXPENSES_TYPE_WLF("FIN", "EXPENSES_TYPE", "费用类型", "WLYF", "物流费"),
    FIN_EXPENSES_TYPE_SHWXF("FIN", "EXPENSES_TYPE", "费用类型", "SHWXF", "售后维修费"),
    FIN_EXPENSES_TYPE_OTHER("FIN", "EXPENSES_TYPE", "费用类型", "OTHER", "其他费用"),

    //查验状态
    FIN_EXAM_TYPE_NO("FIN", "EXAM_TYPE", "查验状态", "NO", "未查验"),
    FIN_EXAM_TYPE_SUCCESS("FIN", "EXAM_TYPE", "查验状态", "SUCCESS", "已查验"),
    FIN_EXAM_TYPE_FAIL("FIN", "EXAM_TYPE", "查验状态", "FAIL", "查验失败"),

    //核销方式
    FIN_VERIFY_TYPE_MANU("FIN", "VERIFY_TYPE", "核销方式", "MANU", "手工核销"),
    FIN_VERIFY_TYPE_AUTO("FIN", "VERIFY_TYPE", "核销方式", "AUTO", "自动核销"),

    //工作流状态
    COM_APPR_STATUS_APPROVING("COM", "APPR_STATUS", "工作流状态", "APPROVING", "审批中"),
    COM_APPR_STATUS_APPROVED("COM", "APPR_STATUS", "工作流状态", "APPROVED", "审批通过"),
    COM_APPR_STATUS_REJECTED("COM", "APPR_STATUS", "工作流状态", "REJECTED", "审批拒绝"),
    COM_APPR_STATUS_INVALID("COM", "APPR_STATUS", "工作流状态", "INVALID", "作废"),
    COM_APPR_STATUS_INTERRUPT("COM", "APPR_STATUS", "工作流状态", "INTERRUPT", "中断执行"),
    COM_APPR_STATUS_DELETE("COM", "APPR_STATUS", "工作流状态", "DELETE", "删除"),
    COM_APPR_STATUS_NOTSUBMIT("COM", "APPR_STATUS", "工作流状态", "NOTSUBMIT", "未提交"),

    //红（蓝）票
    FIN_OPEN_TYPE_LP("FIN", "OPEN_TYPE", "红（蓝）票", "LP", "蓝票"),
    FIN_OPEN_TYPE_HP("FIN", "OPEN_TYPE", "红（蓝）票", "HP", "红票"),

    //应付单来源
    FIN_AP_DOC_CLS_MANU("FIN", "AP_DOC_CLS", "应付单来源", "MANU", "手工"),
    FIN_AP_DOC_CLS_PO("FIN", "AP_DOC_CLS", "应付单来源", "PO", "采购订单"),
    FIN_AP_DOC_CLS_GR("FIN", "AP_DOC_CLS", "应付单来源", "GR", "采购收货单"),
    FIN_AP_DOC_CLS_CGTHD("FIN", "AP_DOC_CLS", "应付单来源", "CGTHD", "采购退货单"),
    FIN_AP_DOC_CLS_PACCK("FIN", "AP_DOC_CLS", "应付单来源", "PACCK", "对账单"),
    FIN_AP_DOC_CLS_PINV("FIN", "AP_DOC_CLS", "应付单来源", "PINV", "采购发票"),

    //付款单来源
    FIN_PAY_DOC_CLS_MANU("FIN", "PAY_DOC_CLS", "付款单来源", "MANU", "手工"),
    FIN_PAY_DOC_CLS_PO("FIN", "PAY_DOC_CLS", "付款单来源", "PO", "采购订单"),
    FIN_PAY_DOC_CLS_AP("FIN", "PAY_DOC_CLS", "付款单来源", "AP", "应付单"),

    //收款单来源
    FIN_REC_DOC_CLS_MANU("FIN", "REC_DOC_CLS", "收款单来源", "MANU", "手工"),
    FIN_REC_DOC_CLS_SO("FIN", "REC_DOC_CLS", "收款单来源", "SO", "销售订单"),
    FIN_REC_DOC_CLS_AR("FIN", "REC_DOC_CLS", "收款单来源", "AR", "应收单"),
    FIN_REC_DOC_CLS_SVO("FIN", "REC_DOC_CLS", "收款单来源", "SVO", "储值订单"),

    //应收单来源-改成用yst-supp DOC_CLS
    FIN_AR_DOC_CLS_MANU("FIN", "AR_DOC_CLS", "应收单来源", "MANU", "手工"),
    FIN_AR_DOC_CLS_SO("FIN", "AR_DOC_CLS", "应收单来源", "SO", "销售订单"),
    //FIN_AR_DOC_CLS_DO("FIN", "AR_DOC_CLS", "应收单来源", "DO", "销售出库单"),
    //FIN_AR_DOC_CLS_SACCK("FIN", "AR_DOC_CLS", "应收单来源", "SACCK", "对账单"),
    FIN_AR_DOC_CLS_SINV("FIN", "AR_DOC_CLS", "应收单来源", "SINV", "销售发票"),
    FIN_AR_DOC_CLS_INVIO("yst-supp", "DOC_CLS", "应收单来源", "INVIO", "库存流水"),
    FIN_AR_DOC_CLS_SACCK("FIN", "AR_DOC_CLS", "应收单来源", "SACCK", "销售对账"),

    //进项发票来源
    FIN_PINV_CREATE_MODE_PACCK("FIN", "PINV_CREATE_MODE", "进项发票来源", "PACCK", "对账单"),
    FIN_PINV_CREATE_MODE_AP("FIN", "PINV_CREATE_MODE", "进项发票来源", "AP", "应付单"),
    FIN_PINV_CREATE_MODE_GR("FIN", "PINV_CREATE_MODE", "进项发票来源", "GR", "采购收货单"),
    FIN_PINV_CREATE_MODE_MANU("FIN", "PINV_CREATE_MODE", "进项发票来源", "MANU", "手工"),

    //收款类型
    SAL_RECEIPT_TYPE_DEPOSIT("SAL", "RECEIPT_TYPE", "收款类型", "DEPOSIT", "收取押金"),
    SAL_RECEIPT_TYPE_VIRTUAL("SAL", "RECEIPT_TYPE", "收款类型", "VIRTUAL", "虚拟收款"),
    SAL_RECEIPT_TYPE_DEP_PRE("SAL", "RECEIPT_TYPE", "收款类型", "DEP_PRE", "押金转预收"),
    SAL_RECEIPT_TYPE_OFF_PRE("SAL", "RECEIPT_TYPE", "收款类型", "OFF_PRE", "B端商城线下收款"),
    SAL_RECEIPT_TYPE_ONLINE_PRE("SAL", "RECEIPT_TYPE", "收款类型", "ONLINE_PRE", "B端商城线上收款"),
    SAL_RECEIPT_TYPE_MAR_PRE("SAL", "RECEIPT_TYPE", "收款类型", "MAR_PRE", "保证金收款"),
    SAL_RECEIPT_TYPE_SER_PRE("SAL", "RECEIPT_TYPE", "收款类型", "SER_PRE", "服务费收款"),
    SAL_RECEIPT_TYPE_FINE_PRE("SAL", "RECEIPT_TYPE", "收款类型", "FINE_PRE", "罚款收款"),
    SAL_RECEIPT_TYPE_STORAGE("SAL", "RECEIPT_TYPE", "收款类型", "STORAGE", "储值收款"),


    // 销项发票申请来源单据
    FIN_SINV_CREATE_MODE_SACCK("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "SACCK", "销售对账单"),
    FIN_SINV_CREATE_MODE_AR("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "AR", "应收单"),
    FIN_SINV_CREATE_MODE_DO("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "DO", "销售发货单"),
    FIN_SINV_CREATE_MODE_RDO("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "RDO", "退货入库单"),
    FIN_SINV_CREATE_MODE_MANU("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "MANU", "手工"),

    // 红冲状态
    RED_STATE_NO("yst-fin", "RED_STATE", "红冲状态", "NO", "未红冲"),
    RED_STATE_ING("yst-fin", "RED_STATE", "红冲状态", "ING", "发票红冲中"),
    RED_STATE_SUCCESS("yst-fin", "RED_STATE", "红冲状态", "SUCCESS", "已红冲"),
    RED_STATE_FAIL("yst-fin", "RED_STATE", "红冲状态", "FAIL", "红冲失败"),

    // 发票性质
    FIN_INV_NATURE_0("FIN", "INV_NATURE", "发票性质", "0", "正常行"),
    FIN_INV_NATURE_1("FIN", "INV_NATURE", "发票性质", "1", "折扣行"),
    FIN_INV_NATURE_2("FIN", "INV_NATURE", "发票性质", "2", "被折扣行"),

    // 推送方式
    FIN_PUSH_METHOD_NO("FIN", "PUSH_METHOD", "推送方式", "-1", "不推送"),
    FIN_PUSH_METHOD_0("FIN", "PUSH_METHOD", "推送方式", "0", "邮箱"),
    FIN_PUSH_METHOD_1("FIN", "PUSH_METHOD", "推送方式", "1", "手机"),
    FIN_PUSH_METHOD_2("FIN", "PUSH_METHOD", "推送方式", "2", "邮箱/手机"),

    // 导入状态
    FIN_IMP_STATE_SUCCESS("FIN", "IMP_STATE", "导入状态", "SUCCESS", "导入成功"),
    FIN_IMP_STATE_FAIL("FIN", "IMP_STATE", "导入状态", "FAIL", "导入失败"),

    // 提现状态
    FIN_WITHDRAW_STATE_WITHDRAWNO("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAWNO", "未提现"),
    FIN_WITHDRAW_STATE_WITHDRAED("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAED", "提现成功"),
    FIN_WITHDRAW_STATE_WITHDRAWING("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAWING", "提现中"),
    FIN_WITHDRAW_STATE_WITHDRAFALSE("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAFALSE", "提现失败"),
    FIN_WITHDRAW_STATE_WITHDRAREJECTED("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAREJECTED", "提现驳回"),


    //账户类型
    ACCOUNT_TYPE_STORE("yst-fin", "ACCOUNT_TYPE", "账户类型", "STORE", "储值账户"),
    ACCOUNT_TYPE_FLZH("yst-fin", "ACCOUNT_TYPE", "账户类型", "FLZH", "返利账户"),
    FIN_ACCOUNT_TYPE_ZCCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCCZZH", "整车储值账户"),
    FIN_ACCOUNT_TYPE_PJCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJCZZH", "配件储值账户"),
    FIN_ACCOUNT_TYPE_FJCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "FJCZZH", "附件包储值账户"),
    FIN_ACCOUNT_TYPE_ZCFLZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCFLZH", "整车返利账户"),
    FIN_ACCOUNT_TYPE_PJFLZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJFLZH", "配件返利账户"),
    FIN_ACCOUNT_TYPE_ZCFLJZZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCFLJZZH", "整车返利记账账户"),
    FIN_ACCOUNT_TYPE_PJFLJZZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJFLJZZH", "配件返利记账账户"),
    FIN_ACCOUNT_TYPE_TCZH("FIN", "ACCOUNT_TYPE", "账户类型", "TCZH", "统筹账户"),
    FIN_ACCOUNT_TYPE_FLZH("FIN", "ACCOUNT_TYPE", "账户类型", "FLZH", "返利账户"),
    FIN_ACCOUNT_TYPE_ZJZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZJZH", "资金账户"),
    FIN_ACCOUNT_TYPE_FYZH("FIN", "ACCOUNT_TYPE", "账户类型", "FYZH", "费用账户"),

    //充值单UDC/收款单（立马）
    FIN_CG_ORDER_TYPE_ZC0001("FIN", "CG_ORDER_TYPE", "充值单类型", "ZC0001", "整车收款单"),
    FIN_CG_ORDER_TYPE_PJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "PJ0001", "配件收款单"),
    FIN_CG_ORDER_TYPE_FJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "FJ0001", "附件包收款单"),
    FIN_CG_ORDER_TYPE_BZJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0001", "充值装修保证金"),
    FIN_CG_ORDER_TYPE_BZJ0002("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0002", "充值定制品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0003("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0003", "充值新品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0004("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0004", "充值电池保证金"),
    FIN_CG_ORDER_TYPE_BZJ0005("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0005", "账户扣款电池保证金"),
    FIN_CG_ORDER_TYPE_BZJ0006("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0006", "账户扣款装修保证金"),
    FIN_CG_ORDER_TYPE_BZJ0007("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0007", "账户扣款定制品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0008("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0008", "账户扣款新品保证金"),
    FIN_CG_ORDER_TYPE_RBZJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0001", "装修保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0002("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0002", "定制品保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0003("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0003", "新品保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0004("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0004", "电池保证金退款单"),

    FIN_CHARGE_ORDER_TYPE1_ZCCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "ZCCZ", "整车充值"),
    FIN_CHARGE_ORDER_TYPE1_PJCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "PJCZ", "配件充值"),
    FIN_CHARGE_ORDER_TYPE1_FJBCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "FJBCZ", "附件包充值"),
    FIN_CHARGE_ORDER_TYPE1_DCBZJ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "DCBZJ", "电池保证金"),
    FIN_CHARGE_ORDER_TYPE1_ZXBZJ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "ZXBZJ", "装修保证金"),
    FIN_CHARGE_ORDER_TYPE1_DZPBZJ("FIN", "CHARGE_ORDER_TYPE1", "充单类型", "DZPBZJ", "定制品保证金"),
    FIN_CHARGE_ORDER_TYPE1_XPBZJ("FIN", "CHARGE_ORDER_TYPE1", "充单类型", "XPBZJ", "新品保证金"),

    FIN_CHARGE_ORDER_TYPE2_DCBZJ("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "DCBZJ", "电池保证金"),
    FIN_CHARGE_ORDER_TYPE2_ZXBZJ("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "ZXBZJ", "装修保证金"),
    FIN_CHARGE_ORDER_TYPE2_DZPBZJ("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "DZPBZJ", "定制品保证金"),
    FIN_CHARGE_ORDER_TYPE2_XPBZJ("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "XPBZJ", "新品保证金"),
    FIN_CHARGE_ORDER_TYPE2_DCBZJT("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "DCBZJT", "电池保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_ZXBZJT("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "ZXBZJT", "装修保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_DZPBZJT("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "DZPBZJT", "定制品保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_XPBZJT("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "XPBZJT", "新品保证金-退还"),

    //账户流水数据来源
    FIN_DATA_SOURCE_TYPE_DD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD01", "整车/配件/附件下单（只占用）"),
    FIN_DATA_SOURCE_TYPE_DD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD02", "整车/配件/附件订单修改（先释放后占用）"),
    FIN_DATA_SOURCE_TYPE_DD021("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD021", "整车/配件/附件订单修改（先释放）"),
    FIN_DATA_SOURCE_TYPE_DD022("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD022", "整车/配件/附件订单修改（后占用）"),
    FIN_DATA_SOURCE_TYPE_DD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD03", "订单关闭（只释放）"),
    FIN_DATA_SOURCE_TYPE_FHD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHD01", "整车/配件/附件发货单已发货（释放/扣减）"),
    FIN_DATA_SOURCE_TYPE_FHD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHD02", "撤销发货"),
    FIN_DATA_SOURCE_TYPE_THD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "THD01", "整车/配件/附件审核通过已退款的退货单"),
    FIN_DATA_SOURCE_TYPE_SKD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "SKD01", "整车/配件/附件收款单审核通过"),
    FIN_DATA_SOURCE_TYPE_BZJ01("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ01", "提交账户扣款的保证金"),
    FIN_DATA_SOURCE_TYPE_BZJ02("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ02", "收款方式=账户扣款的保证金收款单审核拒绝"),
    FIN_DATA_SOURCE_TYPE_BZJ03("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ03", "收款方式=账户扣款的保证金收款单审核通过"),
    FIN_DATA_SOURCE_TYPE_BZJ04("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ04", "保证金退款单审核通过"),
    FIN_DATA_SOURCE_TYPE_TZD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD01", "调整类型=调出的调整单提交"),
    FIN_DATA_SOURCE_TYPE_TZD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD02", "调整类型=调出的调整单审核拒绝"),
    FIN_DATA_SOURCE_TYPE_TZD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD03", "调整类型=调出的调整单审核通过"),
    FIN_DATA_SOURCE_TYPE_TZD04("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD04", "调整类型=调进的调整单审核通过"),
    FIN_DATA_SOURCE_TYPE_TJD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD01", "调整类型=调出的调剂单提交"),
    FIN_DATA_SOURCE_TYPE_TJD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD02", "调整类型=调出的调剂单审批拒绝"),
    FIN_DATA_SOURCE_TYPE_TJD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD03", "调剂单审核通过"),
    //FIN_DATA_SOURCE_TYPE_TJD04("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD04", "调整类型=调进的调剂单审核通过"),
    FIN_DATA_SOURCE_TYPE_FHHC01("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHHC01", "发货红冲（释放/扣减）"),

    //账户流水交易类型
    FIN_TRANSACTION_TYPE_DDZY("FIN", "TRANSACTION_TYPE", "交易类型", "DDZY", "订单占用"),
    FIN_TRANSACTION_TYPE_DDSF("FIN", "TRANSACTION_TYPE", "交易类型", "DDSF", "订单释放"),
    FIN_TRANSACTION_TYPE_FHSF("FIN", "TRANSACTION_TYPE", "交易类型", "FHSF", "发货释放"),
    FIN_TRANSACTION_TYPE_FHKJ("FIN", "TRANSACTION_TYPE", "交易类型", "FHKJ", "发货扣减"),
    FIN_TRANSACTION_TYPE_CXFHTH("FIN", "TRANSACTION_TYPE", "交易类型", "CXFHTH", "撤销发货退还"),
    FIN_TRANSACTION_TYPE_CXFHZY("FIN", "TRANSACTION_TYPE", "交易类型", "CXFHZY", "撤销发货占用"),
    FIN_TRANSACTION_TYPE_THTK("FIN", "TRANSACTION_TYPE", "交易类型", "THTK", "退货退款"),
    FIN_TRANSACTION_TYPE_CZ("FIN", "TRANSACTION_TYPE", "交易类型", "CZ", "充值"),
    FIN_TRANSACTION_TYPE_BZJZY("FIN", "TRANSACTION_TYPE", "交易类型", "BZJZY", "保证金占用"),
    FIN_TRANSACTION_TYPE_BZJSF("FIN", "TRANSACTION_TYPE", "交易类型", "BZJSF", "保证金释放"),
    FIN_TRANSACTION_TYPE_BZJKK("FIN", "TRANSACTION_TYPE", "交易类型", "BZJKK", "保证金扣款"),
    FIN_TRANSACTION_TYPE_BZJTK("FIN", "TRANSACTION_TYPE", "交易类型", "BZJTK", "保证金退款"),
    FIN_TRANSACTION_TYPE_TZDZY("FIN", "TRANSACTION_TYPE", "交易类型", "TZDZY", "调整单占用"),
    FIN_TRANSACTION_TYPE_TZDSF("FIN", "TRANSACTION_TYPE", "交易类型", "TZDSF", "调整单释放"),
    //FIN_TRANSACTION_TYPE_TZDTC("FIN", "TRANSACTION_TYPE", "交易类型", "TZDTC", "调整单的调整原因-调出"),
    //FIN_TRANSACTION_TYPE_TZDTJ("FIN", "TRANSACTION_TYPE", "交易类型", "TZDTJ", "调整单的调整原因-调进"),
    FIN_TRANSACTION_TYPE_TJDZY("FIN", "TRANSACTION_TYPE", "交易类型", "TJDZY", "调剂单占用"),
    FIN_TRANSACTION_TYPE_TJDSF("FIN", "TRANSACTION_TYPE", "交易类型", "TJDSF", "调剂单释放"),
    //FIN_TRANSACTION_TYPE_TJDTC("FIN", "TRANSACTION_TYPE", "交易类型", "TJDTC", "调剂单的调整原因—调出"),
    //FIN_TRANSACTION_TYPE_TJDTJ("FIN", "TRANSACTION_TYPE", "交易类型", "TJDTJ", "调剂单的调整原因—调进"),
    FIN_TRANSACTION_TYPE_FHSFCH("FIN", "TRANSACTION_TYPE", "交易类型", "FHSFCH", "发货释放冲回"),
    FIN_TRANSACTION_TYPE_FHHC("FIN", "TRANSACTION_TYPE", "交易类型", "FHHC", "发货红冲"),

    //账户流水来源单据
    FIN_SOURCE_DOC_TYPE_ORDER("FIN", "SOURCE_DOC_TYPE", "来源单据", "ORDER", "订单"),
    FIN_SOURCE_DOC_TYPE_DISPATCH("FIN", "SOURCE_DOC_TYPE", "来源单据", "DISPATCH", "发货单"),
    FIN_SOURCE_DOC_TYPE_RETURN("FIN", "SOURCE_DOC_TYPE", "来源单据", "RETURN", "退货单"),
    FIN_SOURCE_DOC_TYPE_RECEIPT("FIN", "SOURCE_DOC_TYPE", "来源单据", "RECEIPT", "收款单"),
    FIN_SOURCE_DOC_TYPE_BZJSKD("FIN", "SOURCE_DOC_TYPE", "来源单据", "BZJSKD", "保证金收款单"),
    FIN_SOURCE_DOC_TYPE_BZJTKD("FIN", "SOURCE_DOC_TYPE", "来源单据", "BZJTKD", "保证金退款单"),
    FIN_SOURCE_DOC_TYPE_ADJUST("FIN", "SOURCE_DOC_TYPE", "来源单据", "ADJUST", "调整单"),
    FIN_SOURCE_DOC_TYPE_TJD("FIN", "SOURCE_DOC_TYPE", "来源单据", "TJD", "调剂单"),

    //账户流水来源平台
    FIN_SOURCE_PLATFORM_TYPE_FIN("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "FIN", "财务"),
    FIN_SOURCE_PLATFORM_TYPE_ORDER("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "ORDER", "订单"),
    FIN_SOURCE_PLATFORM_TYPE_OTHER("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "OTHER", "其它"),

    //调整单类型
    ADJUST_TYPE_1("yst-fin", "ADJUST_TYPE", "调整类型", "1", "调入"),
    ADJUST_TYPE_2("yst-fin", "ADJUST_TYPE", "调整类型", "2", "调出"),

    FIN_ADJUST_REASON_1("yst-fin", "ADJUST_REASON", "调整原因", "1", "同账户调整"),
    FIN_ADJUST_REASON_2("yst-fin", "ADJUST_REASON", "调整原因", "2", "异账户调整"),
    FIN_ADJUST_REASON_DIFF_ADJ("yst-fin", "ADJUST_REASON", "调整原因", "1", "差异调整"),
    FIN_ADJUST_REASON_ABNORMAL_ADJ("yst-fin", "ADJUST_REASON", "调整原因", "2", "异常调整"),
    FIN_ADJUST_REASON_5("yst-fin", "ADJUST_REASON", "调整原因", "5", "信用还款"),

    FIN_ACTIVE_STATUS_ACTIVE("yst-fin", "ACTIVE_STATUS", "启用/禁用状态", "ACTIVE", "启用"),
    FIN_ACTIVE_STATUS_CLOSED("yst-fin", "ACTIVE_STATUS", "启用/禁用状态", "CLOSED", "禁用"),

    ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "NOT_OPEN", "未打开"),
    ACCOUNT_PERIOD_CONTROL_STATUS_OPEN("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "OPEN", "已打开"),
    ACCOUNT_PERIOD_CONTROL_STATUS_CLOSED("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "CLOSED", "关闭"),

    EVENT_TABLE_CONDITION_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "=", "="),
    EVENT_TABLE_CONDITION_GREATER("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", ">", ">"),
    EVENT_TABLE_CONDITION_LESS("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "<", "<"),
    EVENT_TABLE_CONDITION_GREATER_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", ">=", ">="),
    EVENT_TABLE_CONDITION_LESS_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "<=", "<="),
    EVENT_TABLE_CONDITION_IS_NULL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "is null", "is null"),
    EVENT_TABLE_CONDITION_IS_NOT_NULL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "is not null", "is not null"),
    EVENT_TABLE_CONDITION_IN("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "in", "in"),
    EVENT_TABLE_CONDITION_NOT_IN("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "not in", "not in"),
    EVENT_TABLE_CONDITION_BETWEEN_AND("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "between and", "between and"),



    //账户事务
    IO_TYPE_I("yst-fin", "IO_TYPE", "事务类型", "I", "账户增加"),
    IO_TYPE_O("yst-fin", "IO_TYPE", "事务类型", "O", "账户扣减"),
    IO_TYPE_T("yst-fin", "IO_TYPE", "事务类型", "T", "账户占用"),
    IO_TYPE_R("yst-fin", "IO_TYPE", "事务类型", "R", "占用释放"),

    CREDIT_IO_TYPE_I("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "I", "账户增加"),
    CREDIT_IO_TYPE_O("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "O", "账户扣减"),
    CREDIT_IO_TYPE_T("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "T", "账户占用"),
    CREDIT_IO_TYPE_R("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "R", "占用释放"),
    CREDIT_IO_TYPE_U("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "U", "使用增加"),
    CREDIT_IO_TYPE_D("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "D", "使用减少"),


    DOC_CLS_SO_C("yst-supp", "DOC_TYPE", "单据类型", "SO_C", "铺货订单"),
    DOC_TYPE_DO("yst-supp", "DOC_TYPE", "单据类型", "DO", "发货单"),
    DOC_TYPE_SAINV("yst-supp", "DOC_TYPE", "单据类型", "SINV", "销售发票"),

    DOC_CLS_SAINV("yst-supp", "DOC_CLS", "来源单据", "SINV", "销售发票"),
    DOC_STATUS_SAINV("yst-supp", "DOC_STATUS", "来源单据状态", "CONFIRM", "销售发票确认"),

    DOC_STATUS_RSO_CL("yst-supp", "DOC_STATUS", "订单状态", "RSO_CL", "已取消"),

    DOC_STATUS_SACCK_CONFIRM("yst-supp", "DOC_STATUS", "订单状态", "SACCK_CONFIRM", "对账单已确认"),
    DOC_STATUS_INVIO_SUCCESS("yst-supp", "DOC_STATUS", "来源单据状态", "INVIO_SUCCESS", "库存流水审核通过"),


    //单据类别
    DOC_CLS_SVO("yst-supp", "DOC_CLS", "单据类别", "SVO", "储值订单"),
    DOC_CLS_SO("yst-supp", "DOC_CLS", "单据类别", "SO", "销售订单"),
    DOC_CLS_CREDIT("yst-supp", "DOC_CLS", "单据类别", "CREDIT", "信用订单"),
    DOC_CLS_AO("yst-supp", "DOC_CLS", "单据类别", "AO", "调整单"),
    DOC_CLS_ATO("yst-supp", "DOC_CLS", "单据类别", "ATO", "调剂单"),
    DOC_CLS_SACCK("yst-supp", "DOC_CLS", "单据类别", "SACCK", "对账单"),
    DOC_CLS_STKTRN("yst-supp","DOC_CLS","单据类别","STKTRN","库存转移单"),
    DOC_CLS_DO("yst-supp","DOC_CLS","单据类别","DO","销售出库单"),
    DOC_CLS_RDO("yst-supp","DOC_CLS","单据类别","RDO","销售退货收货单"),
    DOC_CLS_GR("yst-supp","DOC_CLS","单据类别","GR","采购收货单"),
    DOC_CLS_RGR("yst-supp","DOC_CLS","单据类别","RGR","采购退货出库单"),

    DOC_CLS_RSO("yst-supp", "DOC_CLS", "单据类别", "RSO", "销售退货单"),

    //主体类型
    PRINCIPAL_TYPE_INVOICE("yst-fin", "PRINCIPAL_TYPE", "主体类型", "INVOICE", "开票主体"),

    //单据类型
    DOC_TYPE_AO_1("yst-supp", "DOC_TYPE", "单据类型", "AO_1", "账户余额调整单调入"),
    DOC_TYPE_AO_2("yst-supp", "DOC_TYPE", "单据类型", "AO_2", "账户余额调整单调出"),
    DOC_TYPE_SACCK("yst-supp", "DOC_TYPE", "单据类型", "SACCK_SACCK", "销售对账单"),
    DOC_TYPE_REDEMPTION("yst-supp", "DOC_TYPE", "单据类型", "SACCK_REDEMPTION", "卡券兑换订单"),
    DOC_TYPE_CARD("yst-supp", "DOC_TYPE", "单据类型", "SACCK_CARD", "卡券订单"),

    RECONCILIATION_TYPE_COUPON("yst-fin", "RECONCILIATION_TYPE", "对账类型", "COUPON", "卡券订单对账"),
    RECONCILIATION_TYPE_NON_COUPON("yst-fin", "RECONCILIATION_TYPE", "对账类型", "NON_COUPON", "非卡券订单对账"),
    RECONCILIATION_TYPE_EXCHANGE_COUPON("yst-fin", "RECONCILIATION_TYPE", "对账类型", "NON_COUPON", "兑换卡券订单对账"),
    INVOICE_CONFIG_SACCK_SAL_DO("yst-supp", "DOC_TYPE", "单据类型", "DO_SO", "开票设置-销售发货单"),

    INVOICE_CONFIG_SACCK_SAL_RDO_RW("yst-supp", "DOC_TYPE", "单据类型", "RSO_RW", "开票设置-销售退货单-无原单"),

    INVOICE_CONFIG_SACCK_SAL_RDO_RJ("yst-supp", "DOC_TYPE", "单据类型", "RSO_RJ", "开票设置-销售退货单-有原单"),
    INVOICE_CONFIG_SACCK("yst-supp", "DOC_TYPE", "单据类型", "SACCK", "开票设置-销售对账单"),

    SAL_DO_DOC_STATUS("yst-order", "DOC_STATUS", "发货单状态", "DONE", "已签收"),



    //订单状态
    DOC_STATUS_SO_NOPAY("yst-supp", "DOC_STATUS", "订单状态", "SO_NOPAY", "待支付"),

    //开户银行
    UNION_PAY_700000000000001("yst-fin", "UNION_PAY", "开户银行", "700000000000001", "中国银行"),

    INVOICE_REDRAFT_APPLY_STATUS_DR("yst-fin", "DR", "重新开票状态", "DR", "草稿"),
    INVOICE_REDRAFT_APPLY_STATUS_INVALID("yst-fin", "INVALID", "重新开票状态", "INVALID", "作废"),
    INVOICE_REDRAFT_APPLY_STATUS_APPROVING("yst-fin", "APPROVING", "重新开票状态", "APPROVING", "审批中"),
    INVOICE_REDRAFT_APPLY_STATUS_DONE("yst-fin", "DONE", "重新开票状态", "DONE", "已完成"),

    WORK_FLOW_STATUS_APPROVING("COM", "APPR_STATUS", "工作流状态", "APPROVING", "审批中"),
    WORK_FLOW_STATUS_APPROVED("COM", "APPR_STATUS", "工作流状态", "APPROVED", "审批通过"),
    WORK_FLOW_STATUS_REJECTED("COM", "APPR_STATUS", "工作流状态", "REJECTED", "审批拒绝"),
    WORK_FLOW_STATUS_INVALID("COM", "APPR_STATUS", "工作流状态", "INVALID", "作废"),
    WORK_FLOW_STATUS_INTERRUPT("COM", "APPR_STATUS", "工作流状态", "INTERRUPT", "中断执行"),
    WORK_FLOW_STATUS_DELETE("COM", "APPR_STATUS", "工作流状态", "DELETE", "删除"),
    WORK_FLOW_STATUS_NOTSUBMIT("COM", "APPR_STATUS", "工作流状态", "NOTSUBMIT", "未提交"),

    // 信用账户类型
    CREDIT_ACCOUNT_TYPE_CREDIT("yst-fin", "CREDIT_ACCOUNT_TYPE", "信用账户类型", "CREDIT", "信用账户"),

    // 对象类型
    OBJECT_TYPE_CUST_GROUP("yst-fin", "OBJECT_TYPE", "对象类型", "CUST_GROUP", "客户组"),
    OBJECT_TYPE_CUST("yst-fin", "OBJECT_TYPE", "对象类型", "CUST", "客户"),


    INITIAL_STATUS_DRAFT("yst-fin", "INITIAL_STATUS", "期初额度导入状态", "DRAFT", "草稿"),
    INITIAL_STATUS_FINISHED("yst-fin", "INITIAL_STATUS", "期初额度导入状态", "FINISHED", "结束初始化"),

    DEDUCTION_ACCOUNT_TYPE_CREDIT("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "CREDIT", "信用账户"),
    DEDUCTION_ACCOUNT_TYPE_STORE("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "STORE", "储值账户"),
    DEDUCTION_ACCOUNT_TYPE_ZJZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "ZJZH", "资金账户"),
    DEDUCTION_ACCOUNT_TYPE_FYZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "FYZH", "费用账户"),
    DEDUCTION_ACCOUNT_TYPE_FLZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "FLZH", "返利账户"),

    //授信类型
    CREDIT_TYPE_1("yst-fin", "CREDIT_TYPE", "授信类型", "1", "长期"),
    CREDIT_TYPE_2("yst-fin", "CREDIT_TYPE", "授信类型", "2", "临时"),

    //流水修复状态
    FLOW_REPAIR_STATUS_DRAFT("yst-fin", "FLOW_REPAIR_STATUS", "流水修复状态", "DRAFT", "草稿"),
    FLOW_REPAIR_STATUS_FIXED("yst-fin", "FLOW_REPAIR_STATUS", "流水修复状态", "FIXED", "已修复"),
    //流水修复重算原因
    FLOW_RECALCUL_REASON_10("yst-fin", "FLOW_RECALCUL_REASON", "流水修复重算原因", "10", "发生金额错误，计算程序正确"),
    FLOW_RECALCUL_REASON_20("yst-fin", "FLOW_RECALCUL_REASON", "流水修复重算原因", "20", "发生金额正确，计算程序错误"),

    ADJUST_ORDER_TYPE_YETZ("yst-fin", "ADJUST_ORDER_TYPE", "调整单单据类型", "YETZ", "账户余额调整单"),

    SOURCE_TYPE_ACCOUNT_PERIOD("yst-fin", "SOURCE_TYPE", "来源类型", "ACCOUNT_PERIOD", "会计期间"),
    SOURCE_TYPE_COLUMN("yst-fin", "SOURCE_TYPE", "来源类型", "COLUMN", "列来源"),
    SOURCE_TYPE_CONSTANT("yst-fin", "SOURCE_TYPE", "来源类型", "CONSTANT", "常数"),
    SOURCE_TYPE_FAST_CODE("yst-fin", "SOURCE_TYPE", "来源类型", "FAST_CODE", "快码"),
    SOURCE_TYPE_FLEXIBLE("yst-fin", "SOURCE_TYPE", "来源类型", "FLEXIBLE", "值集"),

    ORDER_TYPE3_CARD("yst-order", "ORDER_TYPE3", "对账类型(订单分组)", "CARD", "卡券订单"),
    ORDER_TYPE3_REDEMPTION("yst-order", "ORDER_TYPE3", "对账类型(订单分组)", "CA-FF", "卡券兑换订单"),
    ORDER_TYPE3_NORMAL("yst-order", "ORDER_TYPE3", "对账类型(订单分组)", "NORMAL", "普通订单"),

    AR_FLAG_TYPE_0("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "0", "未生成"),
    AR_FLAG_TYPE_1("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "1", "已生成"),
    AR_FLAG_TYPE_2("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "2", "生成失败"),

    //单据拟定状态
    DOC_PROPOSED_STATUS_DRAFT("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "DRAFT", "草稿"),
    DOC_PROPOSED_STATUS_PROPOSING("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSING", "拟定中"),
    DOC_PROPOSED_STATUS_PROPOSED_FAIL("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSED_FAIL", "拟定失败"),
    DOC_PROPOSED_STATUS_PROPOSED_SUCCESS("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSED_SUCCESS", "拟定成功"),
    DOC_PROPOSED_STATUS_SENDING("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SENDING", "传输中"),
    DOC_PROPOSED_STATUS_SEND_FAIL("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SEND_FAIL", "传输失败"),
    DOC_PROPOSED_STATUS_SEND_SUCCESS("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SEND_SUCCESS", "传输成功"),
    ACC_ENG_FAST_CODE_OUTPUT_ONE("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_ONE", "输出1"),
    ACC_ENG_FAST_CODE_OUTPUT_TWO("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_TWO", "输出2"),
    ACC_ENG_FAST_CODE_OUTPUT_THREE("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_THREE", "输出3"),
    //采购对账单状态
    PUR_ACCOUNT_CHECK_STATUS_DR("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "DR", "草稿"),
    PUR_ACCOUNT_CHECK_STATUS_RJ("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "RJ", "已拒绝"),
    PUR_ACCOUNT_CHECK_STATUS_SUBMIT("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "SUBMIT", "已提交"),
    PUR_ACCOUNT_CHECK_STATUS_DONE("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "DONE", "已审批"),
    PUR_ACCOUNT_CHECK_STATUS_CANCEL("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "CANCEL", "已作废"),
    PUR_ACCOUNT_CHECK_STATUS_APED("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "APED", "已转应付"),
    PUR_ACCOUNT_CHECK_STATUS_CONFIRMED("PUR", "PO_ACCOUNT_CHECK_STATUS", "采购对账单状态", "CONFIRMED", "已确认"),

    AGREEMENT_PROTOCOL_TYPE_RECEIPT("yst-fin", "AGREEMENT_PROTOCOL_TYPE", "收付款协议类型", "RECEIPT", "收款协议"),
    AGREEMENT_PROTOCOL_TYPE_PAYMENT("yst-fin", "AGREEMENT_PROTOCOL_TYPE", "收付款协议类型", "PAYMENT", "付款协议"),
    AGREEMENT_PERIOD_TYPE_IMMOBILIZATION("yst-fin", "AGREEMENT_PERIOD_TYPE", "收付款协议账期类型", "IMMOBILIZATION", "固定"),
    AGREEMENT_PERIOD_TYPE_ROUTINE("yst-fin", "AGREEMENT_PERIOD_TYPE", "收付款协议账期类型", "ROUTINE", "常规"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_01("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "1", "出库日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_02("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "2", "签收日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_03("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "3", "开票日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_04("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "4", "发货日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_05("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "5", "入库日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_06("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "6", "采购日期"),
    AGREEMENT_EFFECTIVE_DATE_TYPE_07("yst-fin", "AGREEMENT_EFFECTIVE_DATE_TYPE", "收付款协议起效日期类型", "7", "下单日期"),

    AGING_RANGE_TIME_UNIT_TYPE_YEAR("yst-fin", "AGING_RANGE_TIME_UNIT_TYPE", "账龄区间时间单位类型", "YEAR", "年"),
    AGING_RANGE_TIME_UNIT_TYPE_MONTH("yst-fin", "AGING_RANGE_TIME_UNIT_TYPE", "账龄区间时间单位类型", "MONTH", "月"),
    AGING_RANGE_TIME_UNIT_TYPE_DAY("yst-fin", "AGING_RANGE_TIME_UNIT_TYPE", "账龄区间时间单位类型", "DAY", "日"),

    TIME_UNIT_DAYS_YEAR_TYPE_360("yst-fin", "TIME_UNIT_DAYS_YEAR_TYPE", "账龄区间时间单位为年的单位天数类型", "360", "360"),
    TIME_UNIT_DAYS_YEAR_TYPE_CALENDAR("yst-fin", "TIME_UNIT_DAYS_YEAR_TYPE", "账龄区间时间单位为年的单位天数类型", "CALENDAR", "日历天数"),
    TIME_UNIT_DAYS_MONTH_TYPE_30("yst-fin", "TIME_UNIT_DAYS_MONTH_TYPE", "账龄区间时间单位为月的单位天数类型", "30", "30"),
    TIME_UNIT_DAYS_MONTH_TYPE_CALENDAR("yst-fin", "TIME_UNIT_DAYS_MONTH_TYPE", "账龄区间时间单位为月的单位天数类型", "CALENDAR", "日历天数"),
    TIME_UNIT_DAYS_DAY_TYPE_1("yst-fin", "TIME_UNIT_DAYS_DAY_TYPE", "账龄区间时间单位为日的单位天数类型", "1", "1"),
    DEFAUT("yst-fin", "DEFAUT", "默认", "dafaut", "默认"),
    //发票查验状态
    INV_VERIFY_STATUS_SUCCESS("yst-fin", "INV_VERIFY_STATUS", "发票查验状态", "SUCCESS", "查验成功"),
    INV_VERIFY_STATUS_FAILED("yst-fin", "INV_VERIFY_STATUS", "发票查验状态", "FAILED", "查验失败"),
    INV_VERIFY_STATUS_NOT("yst-fin", "INV_VERIFY_STATUS", "发票查验状态", "NOT", "未查验"),
    //发票红蓝发票标识
    INV_RED_BLUE_TYPE_RED("yst-fin", "INV_RED_BLUE_TYPE  ", "红蓝发票标识", "RED", "红票"),
    INV_RED_BLUE_TYPE_BLUE("yst-fin", "INV_RED_BLUE_TYPE", "红蓝发票标识", "BLUE", "蓝票"),
    //会计引擎拟定类型
    PROPOSED_TYPE_MANUAL("yst-fin", "PROPOSED_TYPE  ", "拟定类型", "MANUAL", "手动"),
    PROPOSED_TYPE_AUTO("yst-fin", "PROPOSED_TYPE", "拟定类型", "AUTO", "自动"),

    GENERATE_FIN_FLAG_0("yst-fin", "GENERATE_FIN_FLAG", "生成财务单据标识", "0", "未生成"),
    GENERATE_FIN_FLAG_1("yst-fin", "GENERATE_FIN_FLAG", "生成财务单据标识", "1", "已生成"),
    GENERATE_FIN_FLAG_2("yst-fin", "GENERATE_FIN_FLAG", "生成财务单据标识", "2", "生成失败"),

    ACCOUNT_FLOW_BUSINESS_TYPE_ITEM("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE", "账户流水业务类型", "ITEM", "货款"),
    ACCOUNT_FLOW_BUSINESS_TYPE_MARKETING("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE", "账户流水业务类型", "MARKETING", "营销费"),
    ACCOUNT_FLOW_BUSINESS_TYPE_TECH("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE", "账户流水业务类型", "TECH", "科技费"),
    ACCOUNT_FLOW_BUSINESS_TYPE_OPERATION("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE", "账户流水业务类型", "OPERATION", "服务费"),

    FLOW_SYNC_STATUS_0("yst-fin", "FLOW_SYNC_STATUS", "流水同步状态", "0", "待处理"),
    FLOW_SYNC_STATUS_1("yst-fin", "FLOW_SYNC_STATUS", "流水同步状态", "1", "成功"),
    FLOW_SYNC_STATUS_2("yst-fin", "FLOW_SYNC_STATUS", "流水同步状态", "2", "失败"),
    FLOW_SYNC_STATUS_3("yst-fin", "FLOW_SYNC_STATUS", "流水同步状态", "3", "处理中"),
    FLOW_SYNC_STATUS_4("yst-fin", "FLOW_SYNC_STATUS", "流水同步状态", "4", "无需处理"),

    ORG_BANK_TYPE_SAO_BEI("yst-supp", "BANK_TYPE", "银行类型", "SAO_BEI", "扫呗"),

    ORG_BANK_STATUS_ACTIVE("yst-supp", "BANK_TYPE", "银行类型", "ACTIVE", "启用"),

    FLOW_OPT_TYPE_CLOSE("yst-fin", "FLOW_OPT_TYPE", "财务流水操作类型", "CLOSE", "关闭结算"),
    FLOW_OPT_TYPE_PAY("yst-fin", "FLOW_OPT_TYPE", "财务流水操作类型", "PAY", "支付"),
    FLOW_OPT_TYPE_REFUND("yst-fin", "FLOW_OPT_TYPE", "财务流水操作类型", "REFUND", "赔付"),
    FLOW_OPT_TYPE_RETURN("yst-fin", "FLOW_OPT_TYPE", "财务流水操作类型", "RETURN", "退货退款"),
    FLOW_OPT_TYPE_AO("yst-fin", "FLOW_OPT_TYPE", "财务流水操作类型", "AO", "调整"),

    ;

    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public static String getValueCodeName(String model, String code, String valueCodeName) {
        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)
                    && udcEnum.getValueCodeName().equals(valueCodeName)) {
                return udcEnum.getValueCode();
            }
        }
        return null;
    }

    public static UdcEnum getByValueCode(String model, String code, String valueCode) {
        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)
                && udcEnum.getValueCode().equals(valueCode)) {
                return udcEnum;
            }
        }
        return null;
    }

    public static Map<String, String> getNameCodeMap(String model, String code) {
        Map<String, String> res = new HashMap<>();

        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)) {
                res.put(udcEnum.getValueCodeName(), udcEnum.getValueCode());
            }
        }
        return res;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
