package com.elitesland.fin.infinity.aisino.vo.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 红票开具结果响应类
 * 用于接收航信红票开具接口的返回结果
 */
@Data
public class RedInvoiceOpenResp {
    
    /**
     * 响应代码
     * "0000" 表示请求成功
     */
    @JSONField(name = "CODE")
    private String CODE = "";
    
    /**
     * 返回消息
     * 描述接口调用的结果信息
     */
    @JSONField(name = "RETURNMESSAGE")
    private String RETURNMESSAGE = "";
    
    /**
     * 响应数据
     */
    @JSONField(name = "DATA")
    private Data DATA;
    
    /**
     * 响应数据内部类
     */
    @lombok.Data
    public static class Data {
        
        /**
         * 业务代码
         * "00" 表示业务处理成功
         */
        @JSONField(name = "CODE")
        private String CODE = "";
        
        /**
         * 业务消息
         * 对业务处理结果的描述
         */
        @JSONField(name = "MESSAGE")
        private String MESSAGE = "";
        
        /**
         * 发票号码
         * 开具的红字发票号码
         */
        @JSONField(name = "FPHM")
        private String FPHM = "";
        
        /**
         * 纸质发票号码
         * 纸质发票的发票号码
         */
        @JSONField(name = "ZZFPHM")
        private String ZZFPHM = "";
        
        /**
         * 发票代码
         * 发票的代码信息
         */
        @JSONField(name = "FPDM")
        private String FPDM = "";
        
        /**
         * 开票日期
         * 格式: yyyy-MM-dd HH:mm:ss
         */
        @JSONField(name = "KPRQ")
        private String KPRQ = "";
        
        /**
         * 销售方纳税人识别号
         */
        @JSONField(name = "XSFNSRSBH")
        private String XSFNSRSBH = "";
        
        /**
        * 销售方名称
        */
        @JSONField(name = "XSFMC")
        private String XSFMC = "";
        
        /**
         * 价税合计
         * 发票的总金额（负数表示红字发票）
         */
        @JSONField(name = "JSHJ")
        private String JSHJ = "";
    }
}
