package com.elitesland.fin.infr.repo.expense;


import com.elitesland.fin.domain.expense.ExpTypeDtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Repository
public interface ExpTypeDtlRepo extends JpaRepository<ExpTypeDtlDO, Long>, QuerydslPredicateExecutor<ExpTypeDtlDO> {

    /**
     * 根据主表id查询应收单类型明细
     *
     * @param masId 主表id
     * @return
     */
    List<ExpTypeDtlDO> findAllByMasId(Long masId);

    /**
     * 根据主表id集合查询应收单类型明细
     *
     * @param masIdList 主表id集合
     * @return
     */
    List<ExpTypeDtlDO> findAllByMasIdIn(List<Long> masIdList);

    /**
     * 根据主表id集合删除应收单类型明细
     *
     * @param masIdList 主表id集合
     * @return
     */
    void deleteAllByMasIdIn(List<Long> masIdList);

}
