/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.unionpay.interceptor;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.tenant.client.support.impl.DefaultTenantProvider;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.fin.application.service.unionpay.config.UnionPayProperties;
import com.elitesland.fin.infinity.utils.ExceptionUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UnionPayAuthInterceptor
implements HandlerInterceptor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(UnionPayAuthInterceptor.class);
    private UnionPayProperties unionPayProperties;
    private SysTenantDTO hasUsedTenant;
    private boolean hasUsedDefault;
    private boolean hasNot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        response.addHeader("Content-Type", "application/json;charset=UTF-8");
        try {
            log.info("[UNION_PAY] Current TenantId: {}", (Object)this.unionPayProperties.getTenantId());
            this.setCurrentTenant(this.unionPayProperties.getTenantId());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("[UNION_PAY] Auth Interceptor ERROR: {}", (Object)ExceptionUtil.formatException(e));
            response.setStatus(500);
            boolean bl = false;
            return bl;
        }
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
        this.resetCurrentTenant();
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }

    private void setCurrentTenant(Long tenantId) {
        boolean hasNot = TenantSession.getNoTenant();
        if (hasNot) {
            TenantSession.clearNoTenant();
        }
        this.hasUsedDefault = TenantSession.getUseDefault();
        if (this.hasUsedDefault) {
            TenantSession.clearUseDefault();
        }
        this.hasUsedTenant = TenantSession.getCurrentTenant();
        DefaultTenantProvider tenantProvider = (DefaultTenantProvider)SpringUtil.getBean(DefaultTenantProvider.class);
        CloudtOptional tenantDTO = tenantProvider.getById(tenantId);
        TenantSession.setCurrentTenant((SysTenantDTO)((SysTenantDTO)tenantDTO.get()));
    }

    private void resetCurrentTenant() {
        if (this.hasUsedTenant == null) {
            TenantSession.clearCurrentTenant();
        } else {
            TenantSession.setCurrentTenant((SysTenantDTO)this.hasUsedTenant);
        }
        if (this.hasUsedDefault) {
            TenantSession.setUseDefault();
        }
        if (this.hasNot) {
            TenantSession.setNoTenant();
        }
    }

    public void setEnvironment(Environment environment) {
        Binder env = Binder.get((Environment)environment);
        BindResult properties = env.bind("china", UnionPayProperties.class);
        this.unionPayProperties = properties.isBound() ? (UnionPayProperties)properties.get() : new UnionPayProperties();
    }

    public UnionPayProperties getUnionPayProperties() {
        return this.unionPayProperties;
    }

    public SysTenantDTO getHasUsedTenant() {
        return this.hasUsedTenant;
    }

    public boolean isHasUsedDefault() {
        return this.hasUsedDefault;
    }

    public boolean isHasNot() {
        return this.hasNot;
    }

    public void setUnionPayProperties(UnionPayProperties unionPayProperties) {
        this.unionPayProperties = unionPayProperties;
    }

    public void setHasUsedTenant(SysTenantDTO hasUsedTenant) {
        this.hasUsedTenant = hasUsedTenant;
    }

    public void setHasUsedDefault(boolean hasUsedDefault) {
        this.hasUsedDefault = hasUsedDefault;
    }

    public void setHasNot(boolean hasNot) {
        this.hasNot = hasNot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionPayAuthInterceptor)) {
            return false;
        }
        UnionPayAuthInterceptor other = (UnionPayAuthInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasUsedDefault() != other.isHasUsedDefault()) {
            return false;
        }
        if (this.isHasNot() != other.isHasNot()) {
            return false;
        }
        UnionPayProperties this$unionPayProperties = this.getUnionPayProperties();
        UnionPayProperties other$unionPayProperties = other.getUnionPayProperties();
        if (this$unionPayProperties == null ? other$unionPayProperties != null : !((Object)this$unionPayProperties).equals(other$unionPayProperties)) {
            return false;
        }
        SysTenantDTO this$hasUsedTenant = this.getHasUsedTenant();
        SysTenantDTO other$hasUsedTenant = other.getHasUsedTenant();
        return !(this$hasUsedTenant == null ? other$hasUsedTenant != null : !this$hasUsedTenant.equals(other$hasUsedTenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnionPayAuthInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasUsedDefault() ? 79 : 97);
        result = result * 59 + (this.isHasNot() ? 79 : 97);
        UnionPayProperties $unionPayProperties = this.getUnionPayProperties();
        result = result * 59 + ($unionPayProperties == null ? 43 : ((Object)$unionPayProperties).hashCode());
        SysTenantDTO $hasUsedTenant = this.getHasUsedTenant();
        result = result * 59 + ($hasUsedTenant == null ? 43 : $hasUsedTenant.hashCode());
        return result;
    }

    public String toString() {
        return "UnionPayAuthInterceptor(unionPayProperties=" + this.getUnionPayProperties() + ", hasUsedTenant=" + this.getHasUsedTenant() + ", hasUsedDefault=" + this.isHasUsedDefault() + ", hasNot=" + this.isHasNot() + ")";
    }
}

