/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.invoice;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.service.workflow.invoice.InvoiceRedraftCallbackService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.enums.InvTitleTypeEnum;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceRedraftCallbackServiceImpl
implements InvoiceRedraftCallbackService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRedraftCallbackServiceImpl.class);
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final SystemRpcService systemRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(String businessKey, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        InvoiceRedraftDO invoiceRedraftDO = this.getInvRedraftDO(businessKey);
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.workflowProcInstStatus, (Object)procInstStatus).where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())});
        JPAUpdateClause saleInvdDtlDOJpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvdDtlDO).where(new Predicate[]{this.qSaleInvdDtlDO.invNo.eq((Object)invoiceRedraftDO.getInvoiceNo())});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.setNull((Path)this.qdo.workflowProcInstId);
                jpaUpdateClause.setNull(this.qdo.workflowProcInstStatus);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.REJECTED);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.APPROVING);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentNodeName);
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentNodeKey);
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentUserIds);
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowEndTime, (Object)LocalDateTime.now());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.APPROVED);
                SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                if (saleInvDO == null) {
                    throw new BusinessException("\u672a\u627e\u5230\u539f\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u539f\u5355\u53f7:" + invoiceRedraftDO.getOrigApplyNo());
                }
                List<SaleInvDtlDO> saleInvDtlDOS = this.saleInvDtlRepo.findAllByMasId(saleInvDO.getId());
                if (CollectionUtil.isEmpty(saleInvDtlDOS)) {
                    throw new BusinessException("\u672a\u627e\u5230\u539f\u5f00\u7968\u7533\u8bf7\u5355\u7684\u660e\u7ec6\uff0c\u539f\u5355\u53f7:" + invoiceRedraftDO.getOrigApplyNo());
                }
                saleInvDO.setId(null);
                String applyNo = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "XXFP", new ArrayList<String>());
                saleInvDO.setApplyNo(applyNo);
                saleInvDO.setInvType(invoiceRedraftDO.getInvoiceType());
                saleInvDO.setInvTitleType(invoiceRedraftDO.getInvTitleType());
                saleInvDO.setCustInvTitle(invoiceRedraftDO.getInvTitle());
                if (Objects.equals(invoiceRedraftDO.getInvTitleType(), InvTitleTypeEnum.ENTERPRISE.getCode())) {
                    saleInvDO.setCustTaxNo(invoiceRedraftDO.getTaxerNo());
                } else if (Objects.equals(invoiceRedraftDO.getInvTitleType(), InvTitleTypeEnum.PERSONAL.getCode())) {
                    saleInvDO.setCustTaxNo(null);
                }
                saleInvDO.setOrderState(UdcEnum.INVOICE_STATUS_DRAFT.getValueCode());
                SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(saleInvDO);
                saleInvDtlDOS.forEach(saleInvDtlDO -> saleInvDtlDO.setMasId(save.getId()));
                this.saleInvDtlRepo.saveAll(saleInvDtlDOS);
            }
        }
        jpaUpdateClause.execute();
        saleInvdDtlDOJpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        return null;
    }

    private InvoiceRedraftDO getInvRedraftDO(String businessKey) {
        Long masId = Long.valueOf(businessKey.split("#")[1].trim());
        Optional byId = this.invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new RuntimeException("\u91cd\u65b0\u5f00\u7968(id:" + masId + ")\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5ba1\u6279");
        }
        return (InvoiceRedraftDO)((Object)byId.get());
    }

    public InvoiceRedraftCallbackServiceImpl(InvoiceRedraftRepo invoiceRedraftRepo, JPAQueryFactory jpaQueryFactory, SaleInvRepo saleInvRepo, SaleInvDtlRepo saleInvDtlRepo, SystemRpcService systemRpcService) {
        this.invoiceRedraftRepo = invoiceRedraftRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.systemRpcService = systemRpcService;
    }
}

