package com.elitesland.fin.application.convert.invoice;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentRecordsSaveVO;
import com.elitesland.fin.entity.invoice.PaymentRecordsDO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Mapper(config = BaseMapperConfig.class)
public interface PaymentRecordConvert {

    PaymentRecordConvert INSTANCE = Mappers.getMapper(PaymentRecordConvert.class);

    PaymentRecordsDO saveVoToDO(PaymentRecordsSaveVO saveVO);

    InvoiceAwaitRespVO doToRespVO(PaymentRecordsDO recordsDO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(PaymentRecordsSaveVO saveVO, @MappingTarget PaymentRecordsDO paymentRecordsDO);
}
