package com.elitesland.fin.application.facade.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public class BigDecimalConvert implements Converter<String> {
    @Override
    public Class supportJavaTypeKey() {
        return null;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        CellDataTypeEnum type = cellData.getType();

        if (CellDataTypeEnum.STRING.equals(type)){
            String stringValue = cellData.getStringValue();
            if (StringUtils.isNotBlank(stringValue)){
                return stringValue;
            } else {
                return null;
            }
        } else if (CellDataTypeEnum.NUMBER.equals(type)){
            BigDecimal numberValue = cellData.getNumberValue();
            if (null != numberValue){
                return numberValue.toString();
            } else {
                return null;
            }
        } else {
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "请填写正确的数据格式：数值或文本");
        }

    }

    @Override
    public CellData<Object> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData<>(value);
    }
}
