package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.mq.InvoiceRetryProcessMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvEmailParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedApplyResult;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedSaveRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.writeoff.RmiUdcService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceResultParam;
import com.elitesland.fin.infinity.aisino.vo.resp.*;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.order.param.SalDoUpdateInvoiceNoRpcDTO;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author zhiMing
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceServiceImpl implements InvoiceService {

    private final InvoiceApplyService invoiceApplyService;
    private final InvoiceSaveService invoiceSaveService;
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceDtlDomainService invoiceDtlDomainService;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final ItmItemRpcService itmItemRpcService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    @Autowired
    private RmiUdcService rmiSysUdcRpcService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final AisinoService aisinoService;
    private final AisinoPayloadService aisinoPayloadService;
    private final TaskExecutor taskExecutor;
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final MessageQueueTemplate messageQueueTemplate;
    private final SalDoRpcService salDoRpcService;

    @Override
    public long create(InvoiceApplyParam param) {
        //参数校验
        this.checeInvParam(param);
        // 验重
        InvoiceQueryParam queryParam = new InvoiceQueryParam();
        queryParam.setSourceDocId(param.getIds());
        List<InvoiceApplyRpcDTO> applyRpcDTO = invoiceApplyService.queryIdBySource(queryParam);
        if (CollUtil.isNotEmpty(applyRpcDTO)) {
            throw new BusinessException("单据已开票，不能重复操作");
        }
        List<InvoiceSaveVO> save = invoiceSaveService.save(param);
        if (!CollUtil.isEmpty(save)) {
            return save.get(0).getApplyId();
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long redraft(String applyNo) {
        InvoiceRedraftDO invRedraftDO = invoiceRedraftRepo.findByOrigApplyNo(applyNo);
        if (!ObjectUtils.isEmpty(invRedraftDO) && !ObjectUtils.isEmpty(invRedraftDO.getWorkflowProcInstStatus())) {
            throw new BusinessException("存在未完结的重新开票审批");
        }
        // 不做特殊校验，直接开票
        InvoiceApplyRpcDTO applyRpcDTO = invoiceApplyService.queryIdByApplyNo(applyNo);
        Assert.notNull(applyRpcDTO.getApplyId(), applyNo + " 单据不存在");
        /*if (!applyRpcDTO.isRedState()) {
            throw new BusinessException("重新开票失败：没有发票或发票没有红冲");
        }*/
        //生成重新开票记录
        InvoiceRedraftDO invoiceRedraftDO = this.saveInvoiceRedraft(applyRpcDTO);
        return invoiceRedraftDO.getId();
    }

    @Override
    @Transactional
    public void rePushSaleInvDDtl(List<Long> idList) {
        log.info("重新推送销售发票明细:{}", idList);
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty(allById)) {
            throw new BusinessException("未找到单据");
        }

        List<Long> list = allById.stream().filter(v -> Strings.isBlank(v.getOriginalContent())).map(SaleInvdDtlDO::getMasId).toList();

        Map<Long, SaleInvDO> saleInvDOMap = new HashMap<>();
        Map<Long, List<SaleInvDtlDO>> saleInvDtlMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(list)) {
            List<SaleInvDO> saleInvDOS = saleInvRepo.findAllById(list);
            if (!CollectionUtils.isEmpty(saleInvDOS)){
                saleInvDOMap = saleInvDOS.stream().collect(Collectors.toMap(SaleInvDO::getId, v -> v));
            }
            List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlRepo.findAllByMasIdIn(list);
            if (!CollectionUtils.isEmpty(saleInvDtlDOS)) {
                saleInvDtlMap = saleInvDtlDOS.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
            }
        }

        for (SaleInvdDtlDO invdDtlDO : allById) {
            try {
                if (Strings.isNotBlank(invdDtlDO.getOriginalContent())) {
                    abstractInvoiceSaveService.invoiceReApply(invdDtlDO);
                } else {
                    InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();

                    Long masId = invdDtlDO.getMasId();
                    SaleInvDO saleInvDO = saleInvDOMap.get(masId);
                    BeanUtils.copyProperties(saleInvDO, saveParam);

                    List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(masId);
                    // 设置发票详情
                    if (saleInvDtlDOS != null && !saleInvDtlDOS.isEmpty()) {
                        List<InvoiceDetailSaveParam> detailList = saleInvDtlDOS.stream().map(detail -> {
                            InvoiceDetailSaveParam invoiceDetail = new InvoiceDetailSaveParam();
                            BeanUtils.copyProperties(detail, invoiceDetail);
                            return invoiceDetail;
                        }).toList();
                        saveParam.setDetails(detailList);
                    }
                    abstractInvoiceSaveService.invoiceApply(saveParam, invdDtlDO);
                }
            } catch (Exception e) {
                log.error("发票重推失败：{}", e.getMessage(), e);
            }
        }
    }

    /**
     * 事务结束后异步发送邮件
     *
     * @param emailList 待发送的发票信息
     */
    private void sendEmail(List<SaleInvdDtlDO> emailList) {
        // 事务执行完之后调用
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                // 异步执行发送邮件
                CompletableFuture.supplyAsync(() -> {
                    emailList.forEach(saleInvdDtlDO -> {
                        SaleInvEmailParam param = new SaleInvEmailParam();
                        param.setIds(new ArrayList<>() {{
                            add(saleInvdDtlDO.getMasId());
                        }});
                        // 重新获取邮箱
                        param.setEmail(null);
                        saleInvService.sendEmail(param);
                    });
                    return null;
                }, taskExecutor);
            }
        });
    }

    @Override
    @Transactional
    public void rePushSaleInv(ApplyRePushParam param) {
        List<SaleInvDO> applyList = saleInvRepo.findByApplyNoIn(param.getApplyNoList());
        if (CollectionUtils.isEmpty(applyList)) {
            throw new BusinessException("未找到单据");
        }

        List<Long> idList = applyList.stream().map(BaseModel::getId).toList();

        List<SaleInvdDtlDO> allByMasIdIn1 = saleInvdDtlRepo.findAllByMasIdIn(idList);
        Map<Long, List<SaleInvdDtlDO>> saleInvdDtlMap;
        if (CollectionUtil.isNotEmpty(allByMasIdIn1)) {
            saleInvdDtlMap = allByMasIdIn1.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getMasId));
        } else {
            saleInvdDtlMap = new HashMap<>();
        }

        List<SaleInvDtlDO> allByMasIdIn = saleInvDtlRepo.findAllByMasIdIn(idList);
        Map<Long, List<SaleInvDtlDO>> saleInvDtlMap;
        if (CollectionUtil.isNotEmpty(allByMasIdIn)) {
            saleInvDtlMap = allByMasIdIn.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
        } else {
            saleInvDtlMap = new HashMap<>();
        }

        List<InvoiceApplySaveParam> invoiceApplySaveParamList = new ArrayList<>();
        List<Long> deleteSaleInvDDtlIdList = new ArrayList<>();
        applyList.forEach(apply -> {
            List<SaleInvdDtlDO> saleInvdDtlDOS = saleInvdDtlMap.get(apply.getId());
            if (CollectionUtil.isNotEmpty(saleInvdDtlDOS)) {
                // 如果状态是开票成功，则不能重推
                saleInvdDtlDOS.forEach(saleInvdDtlDO -> {
                    if (Objects.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                        throw new BusinessException("单据" + apply.getApplyNo() + "已开票成功，不能重复操作");
                    }
                    deleteSaleInvDDtlIdList.add(saleInvdDtlDO.getId());
                });
            }

            InvoiceApplySaveParam invoiceApplySaveParam = new InvoiceApplySaveParam();
            BeanUtils.copyProperties(apply, invoiceApplySaveParam);
            List<InvoiceDetailSaveParam> detail = new ArrayList<>();
            List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(apply.getId());
            saleInvDtlDOS.forEach(v -> {
                InvoiceDetailSaveParam invoiceDetailSaveParam = new InvoiceDetailSaveParam();
                BeanUtils.copyProperties(v, invoiceDetailSaveParam);
                invoiceDetailSaveParam.setLineNo(v.getSourceLine());
                detail.add(invoiceDetailSaveParam);
            });
            invoiceApplySaveParam.setDetails(detail);
            invoiceApplySaveParamList.add(invoiceApplySaveParam);
        });

        if (CollectionUtil.isNotEmpty(invoiceApplySaveParamList)) {
            invoiceApplySaveParamList.forEach(invoiceApplySaveParam -> {
                abstractInvoiceSaveService.invoiceApply(invoiceApplySaveParam, null);
            });
        }
//        if (CollectionUtil.isNotEmpty(deleteSaleInvDDtlIdList)){
//            saleInvdDtlRepo.deleteAllById(deleteSaleInvDDtlIdList);
//        }
    }

    /**
     * 获取蓝票开票结果
     *
     * @param idList
     */
    @Override
    @Transactional
    public void getBlueInvoiceResult(List<Long> idList) {
        log.info("获取开票结果入参明细:{}", idList);
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty(allById)) {
            throw new BusinessException("未找到开票单据");
        }

        List<SaleInvdDtlDO> successInvoiceList = new ArrayList<>();
        for (SaleInvdDtlDO invdDtlDO : allById) {
            Boolean success = null;
            try {
                success = abstractInvoiceSaveService.getInvoiceInfoByFlowNo(invdDtlDO);
            } catch (Exception e) {
                log.error("获取开票结果失败：{}", e.getMessage(), e);
                continue;
            }
            if (success != null && success) {
                List<SaleInvdDtlDO> saleInvdDtlDOS = this.getBase64Result(new ArrayList<>() {{
                    add(invdDtlDO.getId());
                }});
                successInvoiceList.addAll(saleInvdDtlDOS);
            }
        }

        if (CollectionUtil.isNotEmpty(successInvoiceList)) {
            // 回写待开票状态
            Map<Long, String> applyIdAndInvNoMap = successInvoiceList.stream().collect(Collectors.toMap(SaleInvdDtlDO::getMasId, SaleInvdDtlDO::getInvNo));

            List<SaleInvDtlDO> saleInvDtlDOList = saleInvDtlRepo.findAllByMasIdIn(applyIdAndInvNoMap.keySet());
            Map<Long, List<SaleInvDtlDO>> saleInvDtlMap;
            if (CollectionUtil.isNotEmpty(saleInvDtlDOList)) {
                saleInvDtlMap = saleInvDtlDOList.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
            } else {
                saleInvDtlMap = new HashMap<>();
            }

            List<SaleInvDO> saleInvList = saleInvRepo.findAllById(applyIdAndInvNoMap.keySet());
            log.info("开票成功回写信息：{}", JSON.toJSONString(saleInvList));
            if (CollectionUtil.isNotEmpty(saleInvList)) {
                SaleInvStatusParam saleInvStatusParam = new SaleInvStatusParam();
                saleInvStatusParam.setApplyNoList(saleInvList.stream().map(SaleInvDO::getApplyNo).toList());
                saleInvStatusParam.setInvState(UdcEnum.INVOICE_AWAIT_STATUS_SUCCESS.getValueCode());
                invoiceAwaitRepoProc.updateInvState(saleInvStatusParam);

                // 订货单回写蓝票号码
                for (SaleInvDO saleInvDO : saleInvList) {
                    List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(saleInvDO.getId());
                    if (CollectionUtil.isNotEmpty(saleInvDtlDOS)) {
                        List<String> docNoList = saleInvDtlDOS.stream().map(SaleInvDtlDO::getDocNo).toList();
                        String invNo = applyIdAndInvNoMap.get(saleInvDO.getId());
                        SalDoUpdateInvoiceNoRpcDTO salDoUpdateInvoiceNoRpcDTO = new SalDoUpdateInvoiceNoRpcDTO();
                        salDoUpdateInvoiceNoRpcDTO.setDocNoList(docNoList);
                        salDoUpdateInvoiceNoRpcDTO.setInvoiceNo(invNo);
                        salDoRpcService.updateInvoiceNo(salDoUpdateInvoiceNoRpcDTO);
                    }
                }
            }

            // 发送邮件
            sendEmail(successInvoiceList);
        }
    }

    @Override
    public List<SaleInvdDtlDO> getBase64Result(List<Long> saleInvIdList) {
        log.info("[FOS-INV] getBase64Result, saleInvIdList={}", saleInvIdList);
        List<SaleInvdDtlDO> result = new ArrayList<>();
        // 开票申请单号
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(saleInvIdList);
        // 查询获取蓝票结果
        for (SaleInvdDtlDO saleInvdDtlDO : allById) {
            Boolean base64Result = abstractInvoiceSaveService.getBase64Result(saleInvdDtlDO);
            if (base64Result != null && base64Result) {
                result.add(saleInvdDtlDO);
            }
        }
        if (CollectionUtil.isNotEmpty(result)) {
            saleInvdDtlRepo.saveAll(allById);
        }
        return result;
    }

    /**
     * 红冲接口
     *
     * @param saveParam
     */
    public InvoiceRedApplyResult redInvoice(InvoiceRedApplySaveParam saveParam) {
        InvoiceRedApplyResult result = new InvoiceRedApplyResult();
        // 红票确认单初始化
        AisinoRedInitialResultResp response = null;
        try {
            String aisinoRedPayload = aisinoPayloadService.convertRedInitial(saveParam);
            response = aisinoService.redInvoiceInitial(
                    aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload, saveParam.getSaleTaxNo()),
                    aisinoRedPayload);
        } catch (Exception e) {
            // 红票初始化失败日志
            result.setRedFailCause("红票初始化失败:" + e.getMessage());
        }
        if (response != null && Objects.equals(response.getCODE(), "0000")) {
            // 初始化结果
            InvoiceRedInitialRespVO invoiceRedInitialRespVO = null;
            AisinoRedSaveResultResp redSaveResp = null;
            try {
                invoiceRedInitialRespVO = response.getDATA();
                result.setRedInvoiceInitData(invoiceRedInitialRespVO);
                String redSaveParam = aisinoPayloadService.convertRedSave(invoiceRedInitialRespVO);
                AisinoCoverParamPayload redSavePayload = aisinoPayloadService.assembleAisinoPayload(redSaveParam, saveParam.getSaleTaxNo());
                // 通过红票确认单保存
                redSaveResp = aisinoService.redInvoiceSave(redSavePayload, redSaveParam);
            } catch (Exception e) {
                // 红票保存失败日志
                result.setRedFailCause("红票保存失败:" + e.getMessage());
            }
            if (redSaveResp != null && Objects.equals(redSaveResp.getCODE(), "0000")) {
                // 通过红票确认单保存
                InvoiceRedSaveRespVO data1 = redSaveResp.getDATA();
                InvoiceRedSaveRespVO.Qrjkpfpqx qrjkpfpxx = data1.getQRJKPFPXX();
                // 如果2.2.2.4响应数据中QRJKPBZ = Y（是否确认即开票标志）,表示当“申请红字确认单保存时”或“购/销方确认后”，会自动开具红票，则不必再使用2.2.2.6红字发票开具接口.
                if (!Objects.equals(invoiceRedInitialRespVO.getQRJKPBZ(), "Y")) {
                    // 调用红票开具接口
                    AisinoRedInvoiceParam aisinoRedInvoiceParam = new AisinoRedInvoiceParam();
                    aisinoRedInvoiceParam.setUUID(data1.getUUID());
                    //税号 +随机数 长度为30 唯一值
                    String timestamp = String.valueOf(System.currentTimeMillis());
                    String randomStr = timestamp.substring(timestamp.length() - 5);
                    // 获取随机五位数
                    String randomFiveDigits = String.format("%05d", (int) (Math.random() * 100000));
                    aisinoRedInvoiceParam.setFPQQLSH(qrjkpfpxx.getXSFNSRSBH() + randomStr + randomFiveDigits);
                    aisinoRedInvoiceParam.setYFPHM(qrjkpfpxx.getFPHM());
                    aisinoRedInvoiceParam.setHZFPXXQRDBH(data1.getHZFPXXQRDBH());
                    aisinoRedInvoiceParam.setSFZZFP("N");
                    String redOpenParamStr = JSON.toJSONString(aisinoRedInvoiceParam);
                    AisinoCoverParamPayload redOpenParam = aisinoPayloadService.assembleAisinoPayload(redOpenParamStr, saveParam.getSaleTaxNo());
                    AisinoRedOpenResultResp redOpenResp = aisinoService.redInvoiceOpen(redOpenParam, redOpenParamStr);
                    if (redOpenResp != null && Objects.equals(redOpenResp.getCODE(), "0000")) {
                        RedInvoiceOpenResp redInvoiceOpenResp = redOpenResp.getDATA();
                        RedInvoiceOpenResp.Data data = redInvoiceOpenResp.getDATA();
                        result.setRedInvoiceNo(data.getFPHM());
                        result.setRedInvoiceCode(data.getFPDM());
                    } else {
                        // 红票开具失败日志
                        result.setRedFailCause(redOpenResp != null ? redOpenResp.getRETURNMESSAGE() : "红票开具失败");
                    }
                } else {
                    result.setRedInvoiceNo(qrjkpfpxx.getFPHM());
                    result.setRedInvoiceCode(qrjkpfpxx.getFPDM());
                    result.setUuid(data1.getUUID());
                    result.setRedInvoiceConfirmNo(data1.getHZFPXXQRDBH());
                }
            } else {
                // 红票保存失败日志
                result.setRedFailCause(redSaveResp != null ? redSaveResp.getRETURNMESSAGE() : "红票保存失败");
            }
        } else {
            // 红票初始化失败日志
            result.setRedFailCause(response != null ? response.getRETURNMESSAGE() : "红票初始化失败");
        }
        return result;
    }

    @Override
    public void rePushSaleInvDDtl(ApplyRePushParam param) {
        List<String> applyNoList = param.getApplyNoList();
        List<SaleInvDO> byApplyNoIn = saleInvRepo.findByApplyNoIn(applyNoList);
        if (CollectionUtil.isEmpty(byApplyNoIn)) {
            throw new BusinessException("未找到对应的申请单");
        }

        List<Long> masIdList = byApplyNoIn.stream().map(BaseModel::getId).toList();

        // 获取申请单号下面，开票失败的数据
        List<SaleInvdDtlDO> invStateAndMasIdIn = saleInvdDtlRepo.findAllByInvStateAndMasIdIn(UdcEnum.INV_STATE_FAIL.getValueCode(), masIdList);
        if (CollectionUtil.isEmpty(invStateAndMasIdIn)) {
            throw new BusinessException("未找到开票失败的发票");
        }

        // 按照销售方税号分组
        Map<String, List<SaleInvdDtlDO>> saleInvMap = invStateAndMasIdIn.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getSaleTaxNo));

        // 更新状态为开票中
        List<Long> masIds = invStateAndMasIdIn.stream().map(BaseModel::getId).toList();
        String orderState = UdcEnum.INV_STATE_ING.getValueCode();
        saleInvRepo.updateOrderStateByIdIn(orderState, masIds);

        // 提交每个分组的数据，一起开票
        saleInvMap.forEach((key, value) -> {
            List<Long> list = value.stream().map(BaseModel::getId).toList();
            InvoiceRetryProcessMqMessageDTO messageDTO = new InvoiceRetryProcessMqMessageDTO();
            messageDTO.setIdList(list);
            messageDTO.setBusinessKey(key);
            try {
                messageQueueTemplate.publishMessage(Application.NAME, InvoiceRetryProcessMqMessageDTO.RETRY_CHANNEL, messageDTO);
            } catch (Exception e) {
                log.error("发送mq消息，重试失败开票数据,同步内容{}, 失败原因：{}", messageDTO, e.getMessage());
            }
        });
    }

    /**
     * 获取红票开票结果
     *
     * @param idList
     */
    @Override
    @Transactional
    public void getRedInvoiceResult(List<Long> idList) {
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty(allById)) {
            throw new BusinessException("未找到单据");
        }

        List<SaleInvdDtlDO> emailList = new ArrayList<>();
        allById.forEach(invdDtlDO -> {
            AisinoRedInvoiceResultParam aisinoRedInvoiceParam = new AisinoRedInvoiceResultParam();
            aisinoRedInvoiceParam.setHZQRXXUUID(invdDtlDO.getCheckCode());
            aisinoRedInvoiceParam.setXSFNSRSBH(invdDtlDO.getSaleTaxNo());
            //税号 +随机数 长度为30 唯一值
            String timestamp = String.valueOf(System.currentTimeMillis());
            String randomStr = timestamp.substring(timestamp.length() - 5);
            // 获取随机五位数
            String randomFiveDigits = String.format("%05d", (int) (Math.random() * 100000));
//            aisinoRedInvoiceParam.setFPQQLSH(invdDtlDO.getSaleTaxNo() + randomStr + randomFiveDigits);

//            aisinoRedInvoiceParam.setYFPHM(invdDtlDO.getBlueInvNo());
//            aisinoRedInvoiceParam.setHZFPXXQRDBH(invdDtlDO.getInvCode());
//            aisinoRedInvoiceParam.setSFZZFP("N");
            String redOpenParamStr = JSON.toJSONString(aisinoRedInvoiceParam);

            AisinoCoverParamPayload redOpenParam = aisinoPayloadService.assembleAisinoPayload(redOpenParamStr, invdDtlDO.getSaleTaxNo());
            AisinoRedGetResultResp redOpenResp = aisinoService.redInvoiceGetResult(redOpenParam, redOpenParamStr);

            Boolean success = saveRedSaleInvDDtl(invdDtlDO, redOpenResp);
            if (success != null && success) {
                List<SaleInvdDtlDO> base64Result = this.getBase64Result(List.of(invdDtlDO.getId()));
                emailList.addAll(base64Result);
            }
        });

        sendEmail(emailList);
    }

    private Boolean saveRedSaleInvDDtl(SaleInvdDtlDO saleInvdDtlDO, AisinoRedGetResultResp response) {
        // 开票日期
        saleInvdDtlDO.setInvDate(LocalDateTime.now());
        String orderState = null;
        boolean result = false;
        if (response != null && Objects.equals(response.getCODE(), "0000")) {
            RedInvoiceResultResp data = response.getDATA();
//            RedInvoiceOpenResp.Data data = redInvoiceOpenResp.getDATA();
            // 开票状态
            saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_SUCCESS.getCode());
            saleInvdDtlDO.setInvNo(data.getFPHM());
            saleInvdDtlDO.setInvFailCause(null);
            saleInvdDtlDO.setRedState(null);
            if (Strings.isNotBlank(data.getKPRQ())) {
                // 开票日期
                LocalDateTime invoiceDate = LocalDateTime.parse(data.getKPRQ(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                saleInvdDtlDO.setInvDate(invoiceDate);
            }
            if (Objects.equals(data.getCODE(), "2")) {
                saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_SUCCESS.getValueCode());
                orderState = UdcEnum.APPLY_STATUS_RED_SUCCESS.getValueCode();
                saleInvdDtlDO.setInvPdfUrl(null);
                saleInvdDtlDO.setInvFailCause(null);
                result = true;
            }
        } else {
            // 开票状态
            saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_FAIL.getValueCode());
            // 开票失败原因
            saleInvdDtlDO.setInvFailCause(response != null ? response.getRETURNMESSAGE() : "开票申请返回数据为空");
        }
        saleInvdDtlRepo.save(saleInvdDtlDO);
        if (orderState != null){
            saleInvRepo.updateOrderStateById(orderState, saleInvdDtlDO.getMasId());
        }
        return result;
    }

    /**
     * 获取指定主表ID的销售明细列表。
     *
     * @param masId 主表ID，用于查询相关的销售明细数据。
     * @return 返回销售明细的VO（值对象）列表，这个列表是通过DTO（数据传输对象）转换而来的。
     */
    @Override
    public List<SaleInvDtlVO> getDtlList(Long masId) {
        try {
            // 从发票明细领域服务获取指定主表ID的销售明细DTO列表
            List<SaleInvDtlDTO> list = invoiceDtlDomainService.getList(masId);

            // 获取商品编码和商品名称
            Set<String> itemCodeList = list.stream().map(SaleInvDtlDTO::getItemCode).collect(Collectors.toSet());
            Set<Long> itemIdList = list.stream().map(SaleInvDtlDTO::getItemId).collect(Collectors.toSet());

            ItmItemRpcDtoParam itmItemParam = new ItmItemRpcDtoParam();
            itmItemParam.setItemCodes(new ArrayList<>(itemCodeList));
            itmItemParam.setItemIds(new ArrayList<>(itemIdList));
            List<ItmItemRpcDTO> itmItemResps = itmItemRpcService.findItemRpcDtoByParam(itmItemParam);

            Map<String, String> itemCodeAndNameMap = itmItemResps.stream()
                    .collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemName));

            Map<String, String> itemNameAndCodeMap = itemCodeAndNameMap.entrySet().stream()
                    .collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

            // 获取税收分类编码UDC信息
            Map<String, String> udcValues = org.apache.commons.lang3.ObjectUtils.defaultIfNull(
                    rmiSysUdcRpcService.getUdcMapByUdcCode("yst-supp", "TAXONOMY_CODE"),
                    new HashMap<>()
            );

            // 设置税收分类名称
            list = list.stream().peek(v -> {
                String taxName = udcValues.getOrDefault(v.getTaxCode(), "");
                v.setTaxName(taxName);
                if (!ObjectUtils.isEmpty(v.getItemCode()) && ObjectUtils.isEmpty(v.getItemName())) {
                    String itemName = itemCodeAndNameMap.getOrDefault(v.getItemCode(), v.getItemName());
                    v.setItemName(itemName);
                } else if (!ObjectUtils.isEmpty(v.getItemName()) && ObjectUtils.isEmpty(v.getItemCode())) {
                    String itemCode = itemNameAndCodeMap.getOrDefault(v.getItemName(), v.getItemCode());
                    v.setItemCode(itemCode);
                }
            }).collect(Collectors.toList());

            // 将获取到的DTO列表转换为VO列表，以供前端使用
            List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
            return res;
        } catch (Exception e) {
            // 日志记录异常，可以进一步细化异常处理，如重试逻辑、返回特定错误信息等
            log.error("Fetching sale details failed" + e.getMessage(), e);
            throw new BusinessException("Fetching sale details failed", e);
        }
    }

    private InvoiceRedraftDO saveInvoiceRedraft(InvoiceApplyRpcDTO applyRpcDTO) {
        SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(applyRpcDTO.getApplyNo());
        List<SaleInvdDtlVO> saleInvdDtlVOs = saleInvService.getInvdLists(saleInvDO.getId());
        if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
            SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
            InvoiceRedraftDO invoiceRedraftDO = new InvoiceRedraftDO();
            invoiceRedraftDO.setOrigApplyNo(applyRpcDTO.getApplyNo());
            invoiceRedraftDO.setInvoiceNo(saleInvdDtlVO.getInvNo());
            invoiceRedraftDO.setSerialNo(saleInvdDtlVO.getFlowNo());
            invoiceRedraftDO.setInvoiceAmt(saleInvdDtlVO.getTotalAmt());
            invoiceRedraftDO.setInvoiceDate(saleInvdDtlVO.getInvDate());
            invoiceRedraftDO.setInvoiceType(saleInvDO.getInvType());
            invoiceRedraftDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);

            // 设计加盟商和门店信息
            invoiceRedraftDO.setCustCode(saleInvDO.getCustCode());
            invoiceRedraftDO.setCustName(saleInvDO.getCustName());
            invoiceRedraftDO.setCustId(saleInvDO.getCustId());
            invoiceRedraftDO.setMainCustCode(saleInvDO.getMainCustCode());
            invoiceRedraftDO.setMainCustName(saleInvDO.getMainCustName());
            invoiceRedraftDO.setMainCustId(saleInvDO.getMainCustId());
            invoiceRedraftRepo.save(invoiceRedraftDO);
            return invoiceRedraftDO;
        } else {
            throw new BusinessException("当前销售发票无开票明细" + applyRpcDTO.getApplyId());
        }
    }

    /**
     * 开票参数校验
     *
     * @param param
     */
    public void checeInvParam(InvoiceApplyParam param) {
        Assert.notNull(param.getInvType(), "发票类型不能为空");
        Assert.notNull(param.getCustInvTitle(), "开票抬头不能为空");
//        Assert.notNull(param.getCustTaxNo(), "税号不能为空");
    }

}
