package com.elitesland.fin.application.service.invoiceredraft;


import cn.hutool.core.lang.Assert;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.invoiceredraft.InvoiceRedraftConvert;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftQueryParam;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftSaveParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.saleinvd.SaleInvdService;
import com.elitesland.fin.application.service.unionpay.entity.enums.ProcDefKey;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.enums.InvTitleTypeEnum;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.jpa.impl.JPAQueryFactory;
import feign.RetryableException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceRedraftServiceImpl implements InvoiceRedraftService {

    @Autowired
    private InvoiceRedraftRepo invoiceRedraftRepo;
    @Autowired
    private InvoiceRedraftRepoProc invoiceRedraftRepoProc;
    private final WorkflowService workflowService;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;

    private final SaleInvRepo saleInvRepo;

    private final SaleInvDtlRepoProc saleInvDtlRepoProc;

    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;

    private final SaleInvService saleInvService;

    private final SaleInvdDtlRepo saleInvdDtlRepo;

    private final InvoiceRuleConfigDomainService invoiceRuleConfigDomainService;

    private final SeqNumProvider seqNumProvider;

    private final SaleInvdService saleInvdService;

    private final WorkflowRpcService workflowRpcService;
    private final FlexFieldUtilService flexFieldUtilService;

    @SysCodeProc
    @Override
    public PagingVO<InvoiceRedraftPageVO> page(InvoiceRedraftQueryParam param) {
        PagingVO<InvoiceRedraftPageVO> invoiceRedraftPageVOPagingVO = invoiceRedraftRepoProc.queryPaging(param);
        flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.INVOICE_REDRAFT,invoiceRedraftPageVOPagingVO.getRecords());
        return invoiceRedraftPageVOPagingVO;
    }

    @Override
    @SysCodeProc
    public InvoiceRedraftPageVO detail(Long masId) {
        Optional<InvoiceRedraftDO> byId = invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            return null;
        }
        InvoiceRedraftPageVO pageVO = InvoiceRedraftConvert.INSTANCE.do2VO(byId.get());
        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.INVOICE_REDRAFT,pageVO);
        return pageVO;
    }

    @Transactional
    @Override
    public Long saveOrUpdate(InvoiceRedraftSaveParam param) {
        this.validateSaveOrUpdateParam(param);
        return this.persistence(param);
    }

    @Override
    public void delById(Long masId) {
        invoiceRedraftRepo.deleteById(masId);
    }

    @Transactional
    @Override
    public String submit(Long masId) {
        Optional<InvoiceRedraftDO> byId = invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new BusinessException("当前换开单据不存在" + masId);
        }
        InvoiceRedraftDO invoiceRedraftDO = byId.get();
        HashMap<String, Object> variables = new HashMap<>();
        String id = "";
        try {
            if (workflowRpcService.checkIsEnableWorkFlow(ProcDefKey.INVOICE_REDRAFT.name())) {
                WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(
                        StartProcessPayload.of(
                                ProcDefKey.INVOICE_REDRAFT.name(),  //流程定义KEY
                                "重新开票(" + invoiceRedraftDO.getId() + ")审批",     //流程实例名称
                                invoiceRedraftDO.getOrigApplyNo() + "#" + invoiceRedraftDO.getId(),           //业务key
                                variables                        //流程变量
                        ));

                if (!workflowResult.isSuccess()) {
                    //流程启动失败
                    throw new BusinessException(workflowResult.getMsg()); //启动流程失败，返回错误
                } else {
                    //流程启动成功
                    ProcessInfo processInfo = workflowResult.getData();
                    //更新单据
                    jpaQueryFactory.update(qdo)
                            .set(qdo.workflowProcInstId, processInfo.getProcInstId())
                            .set(qdo.workflowProcInstStatus, processInfo.getProcInstStatus()) //审批状态
                            .set(qdo.workflowSubmitTime, LocalDateTime.now())
                            .set(qdo.docStatus, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                            .where(qdo.id.eq(invoiceRedraftDO.getId())).execute();
                    id = processInfo.getProcInstId();
                }
                //更新销售已开发票明细为审批中
                SaleInvdParam saleInvdParam = new SaleInvdParam();
                saleInvdParam.setInvoiceNo(invoiceRedraftDO.getInvoiceNo());
                saleInvdParam.setInvoiceRedraftState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
                saleInvdService.update(saleInvdParam);
            }

        } catch (RetryableException e) {
            throw new BusinessException("重新开票调用审批流超时");
        }
        return id;
    }

    private void validateSaveOrUpdateParam(InvoiceRedraftSaveParam param) {
        Assert.notBlank(param.getOrigApplyNo(), "原申请单号必填");
        Assert.notBlank(param.getInvoiceType(), "发票类型必填");
        Assert.notBlank(param.getInvTitleType(), "抬头类型类型");
        Assert.notBlank(param.getInvTitle(), "发票抬头必填");
        if (Objects.equals(param.getInvTitleType(), InvTitleTypeEnum.ENTERPRISE.getCode())) {
            Assert.notBlank(param.getTaxerNo(), "企业类型发票税号必填");
        }
        Assert.notBlank(param.getRedraftReason(), "重开理由必填");
    }

    private Long persistence(InvoiceRedraftSaveParam param) {
        if (ObjectUtils.isEmpty(param.getId())) {
            return this.saveConfig(param);
        }
        return this.updateConfig(param);
    }

    private Long saveConfig(InvoiceRedraftSaveParam param) {
        this.checkExist(param);
        InvoiceRedraftDO invoiceRedraftDO = InvoiceRedraftConvert.INSTANCE.param2DO(param);
        invoiceRedraftDO.setOrigApplyNo(param.getOrigApplyNo());
        invoiceRedraftDO.setDocStatus(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.INVOICE_REDRAFT, invoiceRedraftDO);
        invoiceRedraftRepo.save(invoiceRedraftDO);
        return invoiceRedraftDO.getId();
    }

    private void checkExist(InvoiceRedraftSaveParam param) {
        /*InvoiceRuleConfigDO byRuleCode = invoiceRuleConfigRepo.findByRuleCode(param.getRuleCode());
        if (!ObjectUtils.isEmpty(byRuleCode)){
            throw new BusinessException("开票规则码已存在,新增开票规则配置失败");
        }*/
        /*InvoiceRuleConfigDO byOptDoc = invoiceRuleConfigRepo.findByOptDocCls(param.getRuleCode());
        if (!ObjectUtils.isEmpty(byOptDoc)){
            throw new BusinessException("适用单据已存在,新增开票规则配置失败");
        }*/
    }

    private Long updateConfig(InvoiceRedraftSaveParam param) {
        Optional<InvoiceRedraftDO> byId = invoiceRedraftRepo.findById(param.getId());
        if (byId.isEmpty()) {
            throw new BusinessException("当前id对应的换开申请不存在" + param.getId());
        }
        if (ProcInstStatus.APPROVED.equals(byId.get().getWorkflowProcInstStatus()) || ProcInstStatus.APPROVING.equals(byId.get().getWorkflowProcInstStatus())) {
            throw new BusinessException("当前换开申请审批正在进行或已完成，无法进行修改" + param.getId());
        }
        InvoiceRedraftDO invoiceRedraftDO = InvoiceRedraftConvert.INSTANCE.param2DO(param);
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.INVOICE_REDRAFT, invoiceRedraftDO);
        invoiceRedraftRepoProc.update(invoiceRedraftDO);
        return param.getId();
    }


}
