/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.factory.aporder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ApOrderFactory {
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        ArrayList dtlMasIds = StringUtils.isBlank((CharSequence)apOrderPageParam.getSourceNoDtl()) ? new ArrayList() : this.apOrderDtlRepoProc.findBySourceId(apOrderPageParam.getSourceNoDtl());
        List<Long> masIdList = this.apOrderDtlRepoProc.findBySourceNoList(apOrderPageParam.getDtlSourceNoList());
        List<Long> masIdAllList = Stream.of(dtlMasIds, masIdList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        PagingVO<ApOrderDTO> page = this.apOrderRepoProc.page(apOrderPageParam, masIdAllList);
        page.getRecords().forEach(x -> x.setTotalCount(this.apOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
        return page;
    }

    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        List<Long> masIds = this.apOrderDtlRepoProc.findUnverBySourceId(apOrderPageParam);
        PagingVO<ApOrderDTO> page = null;
        if (CollUtil.isEmpty(masIds)) {
            return new PagingVO(0L, new ArrayList());
        }
        page = this.apOrderRepoProc.unverPage(apOrderPageParam, masIds);
        return page;
    }

    public ApOrderFactory(ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderRepoProc apOrderRepoProc) {
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
    }
}

