package com.elitesland.fin.application.web.adjusttoorder;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderSaveParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhiyu.he
 * @date 2023/3/3 17:13
 */
@RestController
@RequestMapping("/adjustTo")
@RequiredArgsConstructor
@Api(value = "调剂单", tags = {"调剂单"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_ADJUST_TO, businessDoClass = AdjustToOrderDO.class)
public class AdjustToOrderController {
    private final AdjustToOrderService adjustToOrderService;

    @PostMapping("/page")
    @ApiOperation("分页查询调剂单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "调剂单分页",
            businessObjectType = FinBusinessObjectConstant.FIN_ADJUST_TO,operationCode = FinBusinessObjectConstant.FIN_ADJUST_TO_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<AdjustToOrderVO>> page(@RequestBody AdjustToOrderParam adjustOrderPageParam) {
        return ApiResult.ok(adjustToOrderService.page(adjustOrderPageParam));
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改调剂单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "保存额度调整单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true
            ,businessParamValueKey = "#p0.docNo",allowRepeatRequest = false
    )
    public ApiResult<Long> saveOrUpdate(@RequestBody AdjustToOrderSaveParam adjustToOrderSaveParam) {
        return ApiResult.ok(adjustToOrderService.saveOrUpdate(adjustToOrderSaveParam));
    }

    @GetMapping("/submit/{id}")
    @ApiOperation("提交调剂单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.APPROVE_SUBMIT
            ,operationDescription = "提交调剂单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true
            ,businessParamValueKey = "#p0",allowRepeatRequest = false
    )
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        adjustToOrderService.submit(id);
        return ApiResult.ok();
    }


//    @GetMapping("/getOne/{id}")
//    @ApiOperation("调剂单详情")
//    public ApiResult<AdjustToOrderVO> getOne(@PathVariable("id") Long id) {
//        return ApiResult.ok(adjustToOrderService.getOne(id));
//    }

    @GetMapping("/approve/{id}")
    @ApiOperation("批量审批调剂单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.APPROVE_OK
            ,operationDescription = "批量审批调剂单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true
            ,businessParamValueKey = "#p0"
    )
    public ApiResult<Long> approve(@PathVariable("id") Long id) {
        return ApiResult.ok(adjustToOrderService.approve(id));
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝调剂单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.APPROVE_REJECT
            ,operationDescription = "审批拒绝调剂单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true
            ,businessParamValueKey = "#p0.docNo"
    )
    public ApiResult<Long> reject(@RequestBody AdjustToOrderParam param) {
        return ApiResult.ok(adjustToOrderService.reject(param));
    }
}
