package com.elitesland.fin.domain.entity.aptype;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author :
 * @date : 2022-3-11
 * @desc : 应付单类型定义
 */
@Entity
@Table(name="ap_type")
@org.hibernate.annotations.Table(appliesTo = "ap_type", comment = "应付单类型定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApTypeDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 2197244230975494617L;
    @Column(name = "ap_type_code", columnDefinition = "varchar(32) comment '应付单类型代码'")
    private String apTypeCode;

    @Column(name = "ap_type_name", columnDefinition = "varchar(32) comment '应付单类型名称'")
    private String apTypeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '默认'")
    private Boolean defaultFlag;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApTypeDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApTypeDO entity = (ApTypeDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}