package com.elitesland.fin.domain.param.saleinv;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Data
public class SaleInvPageParam extends BaseModelParam {


    @ApiModelProperty("来源系统单号")
    private String sourceSysNo;

    @ApiModelProperty("开票申请单号")
    private String applyNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户id")
    private Long custId;
    @ApiModelProperty("客户id")
    private List<Long> custIdList;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户编码")
    private List<String> custCodeList;
    @ApiModelProperty("信息表编号")
    private String infoNo;

    @ApiModelProperty("快递编号")
    private String expressNo;

    @ApiModelProperty("来源单据")
    private String createMode;
    @ApiModelProperty("来源单据")
    private List<String> createModeList;
    @ApiModelProperty("发票类型")
    private String invType;
    @ApiModelProperty("发票类型")
    private List<String> invTypeList;

    // 明细
    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty("原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty("开票日期/开始")
    private LocalDateTime invDateStart;

    @ApiModelProperty("开票日期/结束")
    private LocalDateTime invDateEnd;

    @ApiModelProperty("开票金额/含税总金额/开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty("开票金额/含税总金额/结束")
    private BigDecimal totalAmtEnd;

    @ApiModelProperty("红冲状态")
    private String redState;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("开票状态")
    private String invState;
    @ApiModelProperty("开票状态")
    private List<String> invStateList;
    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;
    @ApiModelProperty("主客户编码")
    private List<String> mainCustCodeList;
    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;
    @ApiModelProperty("主客户id")
    private List<Long> mainCustIdList;
    @ApiModelProperty("对账类型-订单分组")
    private String docType3;
    @ApiModelProperty("对账类型-订单分组")
    private List<String> docType3List;

    private String orderState;

    /**
     * 订货人
     */
    @ApiModelProperty("订货人")
    private String recvContactName;
    /**
     * 订货联系电话
     */
    @ApiModelProperty("订货联系电话")
    private String recvContactTel;

    @ApiModelProperty("开票人")
    private String invPerson;

    @ApiModelProperty("税号列表")
    private List<String> taxNoList;

    @ApiModelProperty("根单据编号")
    private String rootDocNo;
}
