/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.artype.ArTypeService;
import com.elitesland.fin.application.service.workflow.aporder.ApOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ApOrderProcessServiceImpl
implements ApOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final FinApPayVerApplyService finApPayVerApplyService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final PurAccountProvider purAccountProvider;
    private final TaskExecutor taskExecutor;
    private final RmiPurRpcService rmiPurRpcService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderRepo arOrderRepo;
    private final ArOrderService arOrderService;
    private final ArTypeService arTypeService;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMisId(id);
        if (apOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QApOrderDO apOrderDO = QApOrderDO.apOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)apOrderDO).set(apOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{apOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)apOrderDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(apOrderDO.approvedTime, (Object)LocalDateTime.now()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)apOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(apOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)apOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(apOrderDO.approvedTime, (Object)LocalDateTime.now()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            List<ApOrderDtlDTO> apOrderDtlDTOList;
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(apOrderDTO.getCreateMode()) && !CollectionUtils.isEmpty(apOrderDtlDTOList = this.apOrderDtlRepoProc.listByMisId(id))) {
                List purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                    PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                    purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                    purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                    purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine().intValue()));
                    return purAccountCheckQtyDTO;
                }).collect(Collectors.toList());
                this.purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
            }
            ApOrderDTO orderDTO = this.apOrderRepoProc.get(id);
            String suppType2 = this.getSuppType2(orderDTO);
            List<ArOrderDO> data = this.arOrderRepoProc.findBySourceNo(orderDTO.getApOrderNo());
            if ("INNER".equals(suppType2) && "MANU".equalsIgnoreCase(orderDTO.getCreateMode()) && CollUtil.isEmpty(data)) {
                ArOrderSaveParam arOrderSaveParam = this.getArOrderSaveParam(apOrderDTO, apOrderDtlDTOS);
                this.arOrderService.save(arOrderSaveParam);
            }
            CompletableFuture.runAsync(() -> {
                log.info("\u5e94\u4ed8\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
                this.finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
                this.updateVerState(id);
            }, (Executor)this.taskExecutor);
        }
    }

    private Long getArTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List arTypeVOS = (List)this.arTypeService.getList().computeData();
        Optional<ArTypeVO> first = arTypeVOS.stream().filter(e -> e.getArTypeCode().equals(code)).findFirst();
        return first.map(ArTypeVO::getId).orElse(null);
    }

    private ArOrderSaveParam getArOrderSaveParam(ApOrderDTO orderDTO, List<ApOrderDtlDTO> apOrderDtlDTOS) {
        List<ArOrderDO> bySourceNo;
        log.info("\u5e94\u4ed8\u5355\u751f\u6210\u5e94\u6536\u5355\u5165\u53c2:orderDTO:{},apOrderDtlDTOS:{}", (Object)JSONUtil.toJsonStr((Object)orderDTO), (Object)JSONUtil.toJsonStr(apOrderDtlDTOS));
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(Arrays.asList(orderDTO.getSuppCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = this.purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u516c\u53f8\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        log.info("\u4f9b\u5e94\u5546\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)purSuppBaseRpcDTO));
        String ouCode2 = purSuppBaseRpcDTO.getOuCode2();
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(ouCode2));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u5173\u8054\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCorBusinCodes(Arrays.asList(orderDTO.getOuCode()));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)custBaseDTO));
        ArOrderSaveParam param = new ArOrderSaveParam();
        param.setTaxFlag(true);
        param.setInOutCust(custBaseDTO.getInOutCust());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        param.setCustCode(custBaseDTO.getCustCode());
        param.setCustId(custBaseDTO.getId());
        param.setCustName(custBaseDTO.getCustName());
        param.setArTypeCode("YSD01_SYS");
        param.setArTypeName("\u6807\u51c6\u5e94\u6536\u5355");
        param.setArTypeId(this.getArTypeIdByCode("YSD01_SYS"));
        param.setBuDate(orderDTO.getBuDate());
        param.setCurrCode(StrUtil.isNotBlank((CharSequence)orderDTO.getCurrCode()) ? orderDTO.getCurrCode() : "CNY");
        param.setCurrName(StrUtil.isNotBlank((CharSequence)orderDTO.getCurrName()) ? orderDTO.getCurrName() : "\u4eba\u6c11\u5e01");
        param.setLocalCurrCode(StrUtil.isNotBlank((CharSequence)orderDTO.getLocalCurrCode()) ? orderDTO.getLocalCurrCode() : "CNY");
        param.setLocalCurrName(StrUtil.isNotBlank((CharSequence)orderDTO.getLocalCurrName()) ? orderDTO.getLocalCurrName() : "\u4eba\u6c11\u5e01");
        param.setCreateMode("AP");
        param.setRelevanceOuCode(orderDTO.getOuCode());
        param.setProtocolCode(orderDTO.getProtocolCode());
        param.setExchangeRate(orderDTO.getExchangeRate());
        param.setTotalAmt(orderDTO.getTotalAmt());
        param.setTotalCurAmt(orderDTO.getTotalCurAmt());
        param.setExclTaxAmt(orderDTO.getExclTaxAmt());
        param.setExclTaxCurAmt(orderDTO.getExclTaxCurAmt());
        param.setTaxAmt(orderDTO.getTaxAmt());
        param.setTaxCurAmt(orderDTO.getTaxCurAmt());
        param.setInitFlag(orderDTO.getInitFlag());
        param.setOrderState("COMPLETE");
        param.setRedState(orderDTO.getRedState());
        String redSourceNo = orderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(bySourceNo = this.arOrderRepoProc.findBySourceNo(redSourceNo))) {
            ArOrderDO arOrderDO = bySourceNo.get(0);
            param.setRedSourceNo(arOrderDO.getArOrderNo());
            param.setRedSourceId(arOrderDO.getId());
            arOrderDO.setRedState(true);
            this.arOrderRepo.saveAndFlush(arOrderDO);
        }
        param.setProposedStatus("DRAFT");
        param.setSourceNo(orderDTO.getApOrderNo());
        param.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        List<ArOrderDtlSaveParam> orderDtlSaveParamList = apOrderDtlDTOS.stream().map(apOrderDtlDTO -> {
            ArOrderDtlSaveParam dtlSaveParam = new ArOrderDtlSaveParam();
            dtlSaveParam.setProtocolCode(orderDTO.getProtocolCode());
            dtlSaveParam.setSourceNo(apOrderDtlDTO.getSourceNo());
            dtlSaveParam.setSourceLine(apOrderDtlDTO.getSourceLine());
            dtlSaveParam.setItemId(apOrderDtlDTO.getItemId());
            dtlSaveParam.setItemCode(apOrderDtlDTO.getItemCode());
            dtlSaveParam.setItemName(apOrderDtlDTO.getItemName());
            dtlSaveParam.setItemType(apOrderDtlDTO.getItemType());
            dtlSaveParam.setSmallCateCode(apOrderDtlDTO.getSmallCateCode());
            dtlSaveParam.setSmallCateName(apOrderDtlDTO.getSmallCateName());
            dtlSaveParam.setUom(apOrderDtlDTO.getUom());
            dtlSaveParam.setUomName(apOrderDtlDTO.getUomName());
            dtlSaveParam.setQty(apOrderDtlDTO.getQty());
            dtlSaveParam.setExclTaxPrice(apOrderDtlDTO.getExclTaxPrice());
            dtlSaveParam.setPrice(apOrderDtlDTO.getPrice());
            dtlSaveParam.setTaxRate(apOrderDtlDTO.getTaxRate());
            dtlSaveParam.setTotalAmt(apOrderDtlDTO.getTotalAmt());
            dtlSaveParam.setTotalCurAmt(apOrderDtlDTO.getTotalCurAmt());
            dtlSaveParam.setExclTaxAmt(apOrderDtlDTO.getExclTaxAmt());
            dtlSaveParam.setExclTaxCurAmt(apOrderDtlDTO.getExclTaxCurAmt());
            dtlSaveParam.setTaxAmt(apOrderDtlDTO.getTaxAmt());
            dtlSaveParam.setTaxCurAmt(apOrderDtlDTO.getTaxCurAmt());
            dtlSaveParam.setVerAmt(BigDecimal.ZERO);
            dtlSaveParam.setUnVerAmt(orderDTO.getTotalAmt());
            dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            return dtlSaveParam;
        }).collect(Collectors.toList());
        param.setArOrderDtlParamList(orderDtlSaveParamList);
        log.info("\u751f\u6210\u5e94\u6536\u5355\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private String getSuppType2(ApOrderDTO orderDTO) {
        Long suppId = orderDTO.getSuppId();
        List<PurSuppBaseDTO> bySuppIdBatch = this.rmiPurRpcService.findBySuppIdBatch(Collections.singletonList(suppId));
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new BusinessException("\u5355\u636e\u5bf9\u5e94\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PurSuppBaseDTO purSuppBaseDTO = bySuppIdBatch.get(0);
        return purSuppBaseDTO.getSuppType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(businessId);
        if (apOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(apOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    private void updateVerState(Long id) {
        ApOrderDTO newApOrderDTO = this.apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> newApOrderDtlDTOList = this.apOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;
        BigDecimal verAmtingSum = BigDecimal.ZERO;
        BigDecimal unVerAmtSum = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(newApOrderDtlDTOList)) {
            for (ApOrderDtlDTO apOrderDtlDTO : newApOrderDtlDTOList) {
                if (null != apOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(apOrderDtlDTO.getVerAmt());
                }
                if (apOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(apOrderDtlDTO.getApplyVerAmTing());
                }
                if (apOrderDtlDTO.getUnVerAmt() == null) continue;
                unVerAmtSum = unVerAmtSum.add(apOrderDtlDTO.getUnVerAmt());
            }
        }
        String verState = null;
        verState = unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newApOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)verState)) {
            this.apOrderRepoProc.updateVerState(verState, id);
        }
    }

    public ApOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, FinApPayVerApplyService finApPayVerApplyService, ApOrderRepoProc apOrderRepoProc, ApOrderRepo apOrderRepo, ApOrderDtlRepoProc apOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, PurAccountProvider purAccountProvider, TaskExecutor taskExecutor, RmiPurRpcService rmiPurRpcService, ArOrderRepoProc arOrderRepoProc, ArOrderRepo arOrderRepo, ArOrderService arOrderService, ArTypeService arTypeService, PurSuppOutService purSuppOutService, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.finApPayVerApplyService = finApPayVerApplyService;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderRepo = apOrderRepo;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.purAccountProvider = purAccountProvider;
        this.taskExecutor = taskExecutor;
        this.rmiPurRpcService = rmiPurRpcService;
        this.arOrderRepoProc = arOrderRepoProc;
        this.arOrderRepo = arOrderRepo;
        this.arOrderService = arOrderService;
        this.arTypeService = arTypeService;
        this.purSuppOutService = purSuppOutService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

