/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.entity.account.QAccountStorageDO;
import com.elitesland.fin.entity.account.QAccountStorageDetailDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AccountStorageRepoProc {
    private static final QAccountStorageDO qdo = QAccountStorageDO.accountStorageDO;
    private static final QAccountStorageDetailDO dtldo = QAccountStorageDetailDO.accountStorageDetailDO;
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<AccountStorageVO> queryPaging(AccountStorageParam query) {
        JPAQuery<AccountStorageVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<AccountStorageVO> getList(AccountStorageParam query) {
        JPAQuery<AccountStorageVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<AccountStorageVO> getJpaQueryWhere(AccountStorageParam query) {
        LocalDateTime parse;
        JPAQuery<AccountStorageVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getAccCode())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.accCode.eq((Object)query.getAccCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccName())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.accName.eq((Object)query.getAccName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiptStatus())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.receiptStatus.eq((Object)query.getReceiptStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiptType())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.receiptType.eq((Object)query.getReceiptType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayMode())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.payMode.eq((Object)query.getPayMode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOuName())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.ouName.eq((Object)query.getOuName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemitter())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.remitter.eq((Object)query.getRemitter()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemitterAccount())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.remitterAccount.eq((Object)query.getRemitterAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFranchisee())) {
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.franchisee.eq((Object)query.getFranchisee()));
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StrUtil.isNotBlank((CharSequence)query.getRemitterTimeStart())) {
            parse = LocalDateTime.parse(query.getRemitterTimeStart(), dateTimeFormatter);
            LocalDate remitterTimeStart = parse.toLocalDate();
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.remitterDate.goe((Comparable)remitterTimeStart));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemitterTimeEnd())) {
            parse = LocalDateTime.parse(query.getRemitterTimeEnd(), dateTimeFormatter);
            LocalDate remitterTimeEnd = parse.toLocalDate();
            jpaQuery.where((Predicate)AccountStorageRepoProc.qdo.remitterDate.loe((Comparable)remitterTimeEnd));
        }
        BusinessSecurityUtil.where(jpaQuery, AccountStorageDO.class);
        SqlUtil.handleCommonJpaQuery(jpaQuery, AccountStorageRepoProc.qdo._super, query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<AccountStorageVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountStorageVO.class, (Expression[])new Expression[]{AccountStorageRepoProc.qdo.id, AccountStorageRepoProc.qdo.franchisee, AccountStorageRepoProc.qdo.franchiseeName, AccountStorageRepoProc.qdo.company, AccountStorageRepoProc.qdo.ouName, AccountStorageRepoProc.qdo.payOrderId, AccountStorageRepoProc.qdo.tenantId, AccountStorageRepoProc.qdo.accName, AccountStorageRepoProc.qdo.accCode, AccountStorageRepoProc.qdo.remitter, AccountStorageRepoProc.qdo.remitterDate, AccountStorageRepoProc.qdo.remitterAccount, AccountStorageRepoProc.qdo.remitterAccountCode, AccountStorageRepoProc.qdo.remitterAmt, AccountStorageRepoProc.qdo.remitterBankCode, AccountStorageRepoProc.qdo.remitterBankName, AccountStorageRepoProc.qdo.ouName, AccountStorageRepoProc.qdo.receiptType, AccountStorageRepoProc.qdo.receiptStatus, AccountStorageRepoProc.qdo.oriMsg, AccountStorageRepoProc.qdo.payMode, AccountStorageRepoProc.qdo.remark, AccountStorageRepoProc.qdo.abstractInfo, AccountStorageRepoProc.qdo.creator, AccountStorageRepoProc.qdo.createUserId, AccountStorageRepoProc.qdo.modifyUserId, AccountStorageRepoProc.qdo.createTime, AccountStorageRepoProc.qdo.modifyTime, AccountStorageRepoProc.qdo.deleteFlag, AccountStorageRepoProc.qdo.payMessage, AccountStorageRepoProc.qdo.secOuCode, AccountStorageRepoProc.qdo.secOuName, AccountStorageRepoProc.qdo.accountHolderCode, AccountStorageRepoProc.qdo.accountHolderName, AccountStorageRepoProc.dtldo.refundReason.as("abstractInfo")})).from((EntityPath)qdo)).where((Predicate)AccountStorageRepoProc.qdo.deleteFlag.eq((Object)0))).leftJoin((EntityPath)dtldo)).on((Predicate)AccountStorageRepoProc.qdo.id.eq(AccountStorageRepoProc.dtldo.storageId));
        return jpaQuery;
    }

    public void updateAccountStorage(SendPayReq sendPayReq) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qdo);
        if (StringUtils.isNotEmpty((CharSequence)sendPayReq.getRemitterAccount())) {
            jpaUpdateClause.set((Path)AccountStorageRepoProc.qdo.remitterAccount, (Object)sendPayReq.getRemitterAccount());
        }
        if (StringUtils.isNotEmpty((CharSequence)sendPayReq.getRemitterBankCode())) {
            jpaUpdateClause.set((Path)AccountStorageRepoProc.qdo.remitterBankCode, (Object)sendPayReq.getRemitterBankCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)sendPayReq.getRemitterBankName())) {
            jpaUpdateClause.set((Path)AccountStorageRepoProc.qdo.remitterBankName, (Object)sendPayReq.getRemitterBankName());
        }
        if (StringUtils.isNotEmpty((CharSequence)sendPayReq.getReceiptStatus())) {
            jpaUpdateClause.set((Path)AccountStorageRepoProc.qdo.receiptStatus, (Object)sendPayReq.getReceiptStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)sendPayReq.getApplyFile())) {
            jpaUpdateClause.set((Path)AccountStorageRepoProc.qdo.applyFile, (Object)sendPayReq.getApplyFile());
        }
        jpaUpdateClause.where(new Predicate[]{AccountStorageRepoProc.qdo.payOrderId.eq((Object)sendPayReq.getPayOrderId())});
        jpaUpdateClause.execute();
    }

    public AccountStorageRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

