package com.elitesland.fin.application.facade.vo.expense;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Mark
 * @date 2024/08/13 14:23
 */
@Data
@ApiModel("分页传输类")
public class ExpLedgerDetailRespVO extends BaseModelVO implements Serializable {

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("物流公司")
    private String carrier;

    @ApiModelProperty("物流公司类型")
    private String carrierType;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("费用类型代码")
    private String expTypeCode;

    @ApiModelProperty("费用类型名称")
    private String expTypeName;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("来源单号")
    private String sourceDocNo;

    @ApiModelProperty("来源单据日期")
    private LocalDate sourceDocNoDate;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("规则名称")
    private String ruleName;


    @ApiModelProperty("计算状态")
    @SysCode(sys = "yst-fin", mod = "CAL_STATE")
    private String calState;
    private String calStateName;

    @ApiModelProperty("计算失败原因")
    private String calError;

    @ApiModelProperty("生成财务单据标识 0-未生成；1-已生成；2-生成失败")
    private String finFlag;

    @ApiModelProperty("生成失败原因")
    private String finError;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "BILL_STATUS")
    private String orderState;
    private String orderStateName;


}