package com.elitesland.fin.application.facade.vo.flow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/09
 * @Version 1.0
 * @Content:
 */
@ApiModel(value = "accountFlowAppVO", description = "APP端账户或信用流水")
@Data
public class AccountFlowAppVO extends CustomFieldBaseModelVo {
    private static final long serialVersionUID = 2427427179978936940L;
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易类型")
    @SysCode(sys = "yst-fin", mod = "IO_TYPE")
    private String transactionType;
    private String transactionTypeName;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    private String sourceDocName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    @SysCode(sys = "yst-fin", mod = "UNION_PAY")
    private String accountName;
    private String accountNameName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;
}
