package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.AccountExportEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 账户报表导出
 *
 * @author : gyj
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class AccountExportServiceImpl implements DataExport<AccountExportEntity, AccountPageParam> {

    private final AccountService accountService;

    @Override
    public String getTmplCode() {
        return "fin_account_export";
    }

    public PagingVO<AccountExportEntity> executeExport(AccountPageParam queryParam) {
        PagingVO<AccountVO> page = accountService.page(queryParam);
        return new PagingVO<>(
            page.getTotal(),
            ExcelConvertUtils.convertLoosely(page.getRecords(), AccountExportEntity.class)
        );
    }
}
