package com.elitesland.fin.application.service.expense;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.expense.ExpLedgerConvert;
import com.elitesland.fin.application.facade.param.expense.*;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerDetailRespVO;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.expense.ExpTypeDomainService;
import com.elitesland.fin.entity.expense.ExpLedgerDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.expense.ExpLedgerRepo;
import com.elitesland.fin.repo.expense.ExpLedgerRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.tms.TmsOutService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.inv.dto.expesne.ExpenseReCalParamRpcDTO;
import com.elitesland.inv.provider.ExpenseCalServiceProvider;
import com.elitesland.inv.provider.InvTrnProvider;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/8/14 14:47
 * @Description:
 */
@Slf4j
@Service
@AllArgsConstructor
@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
public class ExpenseLedgerServiceImpl implements ExpenseLedgerService {
    private final ExpLedgerRepo expLedgerRepo;
    private final ExpLedgerRepoProc expLedgerRepoProc;
    private final TmsOutService tmsOutService;
    private final PurSuppOutService purSuppOutService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ApTypeDomainService apTypeDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final ArOrderService arOrderService;
    private final ApOrderService apOrderService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final ArOrderRepo arOrderRepo;
    private final ApOrderRepo apOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    private final WorkflowRpcService workflowRpcService;

    private final ExpenseCalServiceProvider expenseCalServiceProvider;

    private final InvTrnProvider invTrnProvider;
    private final ApArOrderService apArOrderService;
    private final TransactionTemplate transactionTemplate;
    private final ExpTypeDomainService expTypeDomainService;
    private final ItmItemRpcService itmItemRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ExpLedgerPageVO> searchPage(ExpLedgerQueryParam param) {
        log.info("费用台账-分页查询参数:{}", JSONUtil.toJsonStr(param));
        PagingVO<ExpLedgerPageVO> pagingVO = expLedgerRepoProc.searchPage(param);
        log.info("费用台账-分页查询结果:{}", JSONUtil.toJsonStr(pagingVO));
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<ExpLedgerPageVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        List<ExpLedgerPageVO> expLedgerPageVOList = pagingVO.getRecords();

        expLedgerPageVOList.stream().forEach(expLedgerPageVO -> {
            if (StringUtils.isBlank(expLedgerPageVO.getFinFlag())){
                expLedgerPageVO.setFinFlagName("未生成");
            }else if (Objects.equals(expLedgerPageVO.getFinFlag(),"0")) {
                expLedgerPageVO.setFinFlagName("未生成");
            }else if (Objects.equals(expLedgerPageVO.getFinFlag(),"1")) {
                expLedgerPageVO.setFinFlagName("已生成");
            }else if (Objects.equals(expLedgerPageVO.getFinFlag(),"2")) {
                expLedgerPageVO.setFinFlagName("生成失败");
            }
        });


        return PagingVO.<ExpLedgerPageVO>builder()
                .total(pagingVO.getTotal())
                .records(expLedgerPageVOList)
                .build();
    }

    @Override
    public ExpLedgerDetailRespVO detail(Long id) {
        log.info("费用台账-详情查询参数:{}", id);
        ExpLedgerDetailRespVO data = expLedgerRepoProc.detail(id);
        log.info("费用台账-详情查询结果:{}", JSONUtil.toJsonStr(data));
        return data;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approve(ExpLedgerApproveParam param) {
        List<ExpLedgerDO> data = expLedgerRepo.findAllById(param.getIds());
        data.forEach(
                e -> {
                    e.setOrderState("APPROVED");
                    e.setComment(param.getComment());
                }
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reject(ExpLedgerApproveParam param) {

        List<ExpLedgerDO> data = expLedgerRepo.findAllById(param.getIds());
        List<String> docNos =
                data.stream().map(ExpLedgerDO::getSourceDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ExpenseReCalParamRpcDTO paramRpcDTO = new ExpenseReCalParamRpcDTO();
        paramRpcDTO.setDocNos(docNos);
        invTrnProvider.updateExpFlag(paramRpcDTO);

        data.forEach(
                e -> {
                    e.setOrderState("REJECTED");
                    e.setComment(param.getComment());
                }
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reCal(ExpLedgeCalParam param) {
        log.info("重算运费台账参数:{}", JSONUtil.toJsonStr(param));
        List<String> docNos = param.getDocNos();
        List<ExpLedgerDO> bySourceNoList = expLedgerRepoProc.findBySourceNoList(docNos);
        if (CollUtil.isEmpty(bySourceNoList)) {
            log.warn("没有需要重算的单据信息");
            return;
        }
        List<Long> ids = bySourceNoList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());

        ExpenseReCalParamRpcDTO expenseReCalParamRpcDTO = new ExpenseReCalParamRpcDTO();
        expenseReCalParamRpcDTO.setDocNos(docNos);
        expenseCalServiceProvider.reCal(expenseReCalParamRpcDTO);
        //删除之前的记录
        expLedgerRepo.deleteAllByIdInBatch(ids);
        log.info("重算完成");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(ExpLedgerSaveParam param) {
        log.info("生成费用计算台账参数:{}", JSONUtil.toJsonStr(param));
        ExpLedgerDO expLedgerDO = ExpLedgerConvert.INSTANCE.saveParam2SaveDo(param);
        expLedgerRepo.saveAndFlush(expLedgerDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<ExpLedgerSaveParam> paramList) {
        log.info("生成费用计算台账参数:{}", JSONUtil.toJsonStr(paramList));
        List<String> sourceNoList =
                paramList.stream().map(ExpLedgerSaveParam::getSourceDocNo).distinct().collect(Collectors.toList());
        expLedgerRepoProc.deleteBySourceNoList(sourceNoList);
        log.info("先删除来源单据的历史台账记录");
        List<ExpLedgerDO> expLedgerDOS = ExpLedgerConvert.INSTANCE.saveParam2SaveDoBatch(paramList);
        expLedgerRepo.saveAllAndFlush(expLedgerDOS);
    }


    /**
     * 查询符合查询条件的全部的单据状态=审批通过且生成财务单据=待生成 的单子,
     * 并判断物流公司对应供应商的类型。如果供应商类型=内部，同步生成审批中的应收单和应付单（只能同时成功/失败），
     * 如果供应商类型=外部，只生成审批中应付单。
     *
     *
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void generateApArOrder(ExpLedgerGenApArSaveParam saveParam){
        log.info("费用计算台账生成应收应付入参:{}", JSON.toJSONString(saveParam));
        checkGenerateApArOrder(saveParam);
        ExpLedgerQueryParam expLedgerQueryParam = new ExpLedgerQueryParam();
        expLedgerQueryParam.setOuCode(saveParam.getOuCode());
        expLedgerQueryParam.setCarrier(saveParam.getCarrier());
        expLedgerQueryParam.setExpTypeCode(saveParam.getExpTypeCode());
        expLedgerQueryParam.setSourceDocNoDateStart(saveParam.getSourceDocNoDateStart());
        expLedgerQueryParam.setSourceDocNoDateEnd(saveParam.getSourceDocNoDateEnd());

        //单据状态=审批通过且生成财务单据=待生成 的单子,
        expLedgerQueryParam.setOrderState("APPROVED");
        //expLedgerQueryParam.setFinFlag("0");
        expLedgerQueryParam.setNotGenerateFinFlag(true);
        List<ExpLedgerPageVO> expLedgerPageVOList = expLedgerRepoProc.selectListByParam(expLedgerQueryParam);
        if (CollectionUtil.isEmpty(expLedgerPageVOList)){
            return;
        }

        List<String> carrierList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getCarrier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        TmsOuQueryParamVO tmsOuQueryParamVO = new TmsOuQueryParamVO();
        tmsOuQueryParamVO.setLogisticsOuCodes(carrierList);
        List<TmsOuRespVO> tmsOuRespVOList = tmsOutService.findTmsOuList(tmsOuQueryParamVO);
        //Map<Long, PurSuppBaseRpcDTO> suppMap = new HashMap<>();
        //if (CollectionUtil.isNotEmpty(tmsOuRespVOList)){
            //List<String> suppCodeList = tmsOuRespVOList.stream().map(TmsOuRespVO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Long> suppIds = tmsOuRespVOList.stream().map(TmsOuRespVO::getSuppId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<PurSuppBaseRpcDTO> purSuppBaseRpcDTOList = purSuppOutService.findSimpleRpcDtoBySuppId(suppIds);
        Map<String, PurSuppBaseRpcDTO> suppCodeMap = CollectionUtil.isEmpty(purSuppBaseRpcDTOList) ? new HashMap<>() :
                purSuppBaseRpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));
        Map<Long, PurSuppBaseRpcDTO> suppIdMap = CollectionUtil.isEmpty(purSuppBaseRpcDTOList) ? new HashMap<>() :
                purSuppBaseRpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getId, t -> t, (t1, t2) -> t1));

        //Map<Long, PurSuppBaseRpcDTO> suppMap = CollectionUtil.isEmpty(suppIds) ? new HashMap<>() : purSuppOutService.findSimpleSuppMapBySuppId(suppIds);

            tmsOuRespVOList.forEach(tmsOuRespVO -> {
                PurSuppBaseRpcDTO purSuppBaseRpcDTO = suppIdMap.get(tmsOuRespVO.getSuppId());
                if (Objects.nonNull(purSuppBaseRpcDTO)){
                    tmsOuRespVO.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
                    tmsOuRespVO.setSuppName(purSuppBaseRpcDTO.getSuppName());
                }
            });
        //}
        Map<String, TmsOuRespVO> tmsOuRespVOMap = CollectionUtil.isEmpty(tmsOuRespVOList) ? new HashMap<>() :
                tmsOuRespVOList.stream().collect(Collectors.toMap(TmsOuRespVO::getLogisticsOuCode, t -> t, (t1, t2) -> t1));



        List<String> ouCodeList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcSimpleDTO> orgOuRpcSimpleDTOList = rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodeList);
        Map<String, OrgOuRpcSimpleDTO> ouMap = CollectionUtil.isEmpty(orgOuRpcSimpleDTOList) ? new HashMap<>() :
                orgOuRpcSimpleDTOList.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, t -> t, (t1, t2) -> t1));

        List<String> expTypeCodeList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getExpTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ExpTypeDTO> expTypeDTOList = expTypeDomainService.getListByExpTypeCodes(expTypeCodeList);
        Map<String, ItmItemRpcDTO> itmItemMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(expTypeDTOList)){
            List<String> expTypeItemCodes = expTypeDTOList.stream().map(ExpTypeDTO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(expTypeItemCodes)){
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(expTypeItemCodes);
                List<ItmItemRpcDTO> itmItemRpcDTOList = itmItemRpcService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                itmItemMap = CollectionUtil.isEmpty(itmItemRpcDTOList) ? new HashMap<>() : itmItemRpcDTOList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, t -> t));
            }
            for (ExpTypeDTO expTypeDTO : expTypeDTOList) {
                if (Objects.nonNull(expTypeDTO.getItemCode())){
                    ItmItemRpcDTO itmItemRpcDTO = itmItemMap.get(expTypeDTO.getItemCode());
                    if (Objects.nonNull(itmItemRpcDTO)){
                        expTypeDTO.setItemId(itmItemRpcDTO.getId());
                        expTypeDTO.setItemName(itmItemRpcDTO.getItemName());
                        expTypeDTO.setItemType(itmItemRpcDTO.getItemType());
                        expTypeDTO.setSmallCateCode(itmItemRpcDTO.getItemCateCode());
                        expTypeDTO.setSmallCateName(itmItemRpcDTO.getItemCateFullName());
                        expTypeDTO.setUom(itmItemRpcDTO.getUom());
                        expTypeDTO.setUomName(itmItemRpcDTO.getUomName());
                        expTypeDTO.setTaxCode(itmItemRpcDTO.getTaxCode());
                        expTypeDTO.setTaxRate(itmItemRpcDTO.getTaxRate());
                        expTypeDTO.setTaxCode2(itmItemRpcDTO.getTaxCode2());
                        expTypeDTO.setTaxRate2(itmItemRpcDTO.getTaxRate2());
                    }
                }
            }
        }

        Map<String, ExpTypeDTO> expTypeMap = CollectionUtil.isEmpty(expTypeDTOList) ? new HashMap<>() :
                expTypeDTOList.stream().collect(Collectors.toMap(ExpTypeDTO::getExpTypeCode, t -> t, (t1, t2) -> t1));



        //都是同一个销售公司
        String ouCode = saveParam.getOuCode();
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(ouCode);

        //都是同一个物流公司
        String carrier = saveParam.getCarrier();
        TmsOuRespVO tmsOuRespVO = tmsOuRespVOMap.get(carrier);
        if (Objects.isNull(tmsOuRespVO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未查询到物流公司信息");
        }
        String suppCode = tmsOuRespVO.getSuppCode();
        if (StringUtils.isBlank(suppCode)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司的供应商编码为空");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = suppCodeMap.get(suppCode);
        if (Objects.isNull(purSuppBaseRpcDTO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未查询到物流公司的供应商信息");
        }
        String ioType = purSuppBaseRpcDTO.getIoType();
        if (StringUtils.isBlank(ioType)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司的供应商的内外部为空");
        }

        //expTypeDomainService.getByExpTypeCode(saveParam.getExpTypeCode());

        List<Long> allIdList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        try {

            if (Objects.equals("INSIDE",ioType)){
                //如果供应商类型=内部，同步生成审批中的应收单和应付单（只能同时成功/失败），

                //应收单
                ArOrder arOrder = assembledAr(saveParam,expLedgerPageVOList,tmsOuRespVO,expTypeMap,ouRpcSimpleDTO,purSuppBaseRpcDTO);
                //Long arResId = arOrderDomainService.save(arOrder);
                //Long arResId = arOrderDomainService.newCommit(arOrder, false);
                //提交变审判中 启动工作流
               /* ArOrderDO newArOrderDO = arOrderRepo.findById(arResId).get();
                ArOrder newArOrder = ArOrderConvert.INSTANCE.convert(newArOrderDO);
                arOrderService.startWorkFlow(newArOrder, arResId);*/
                //String arOrderNo = newArOrderDO.getArOrderNo();

                //应付单
                ApOrder apOrder = assembledAp(saveParam,expLedgerPageVOList,expTypeMap,ouRpcSimpleDTO,purSuppBaseRpcDTO);
                //apOrder.setSourceNo(newArOrderDO.getArOrderNo());
                //Long apResId = apOrderDomainService.save(apOrder);
                //Long apResId = apOrderDomainService.newCommit(apOrder);
               /* ApOrderDO newApOrderDO = apOrderRepo.findById(apResId).get();
                ApOrder newApOrder = ApOrderConvert.INSTANCE.convert(newApOrderDO);
                //String apOrderNo = newApOrderDO.getApOrderNo();
                arOrderDomainService.updateSourceNo(newApOrderDO.getApOrderNo(),arResId);
                //提交变审判中 启动工作流
                if (newApOrder.getProcInstId() == null
                        || WorkflowConstant.CAN_START_PROC_STATUSES.contains(newApOrder.getProcInstStatus())) {
                    // 启动流程
                    String procInstName = "应付单审核-" + newApOrder.getApOrderNo();
                    String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
                    ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, apResId.toString(), new HashMap<>());
                    apOrderDomainService.updateWorkInfo(processInfo, apResId);
                }*/
                transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
                ApArOrderHandleDTO apArOrderHandleDTO = transactionTemplate.execute(transactionStatus -> {
                    try {
                        ApArOrderHandleDTO apArOrderDTO = new ApArOrderHandleDTO();
                        Long arResId = arOrderDomainService.newCommit(arOrder, false);
                        apArOrderDTO.setArResId(arResId);

                        Long apResId = apOrderDomainService.newCommit(apOrder);
                        apArOrderDTO.setApResId(apResId);

                        return apArOrderDTO;
                    }catch (Exception e) {
                        log.error("费用计算台账生成应收应付error:", e);
                        //回滚
                        transactionStatus.setRollbackOnly();
                        //throw e;//抛出异常，不往下执行
                        throw new BusinessException(ApiCode.FAIL, e.getMessage());
                    }
                });
                //ApArOrderHandleDTO apArOrderHandleDTO = apArOrderService.expenseLedgerCommit(arOrder,apOrder);
                Long arResId = apArOrderHandleDTO.getArResId();
                Long apResId =apArOrderHandleDTO.getApResId();

                //ArOrderDO newArOrderDO = arOrderRepo.findById(arResId).get();
                //ArOrder newArOrder = ArOrderConvert.INSTANCE.convert(newArOrderDO);

                ArOrderDTO newArOrderDTO = arOrderRepoProc.get(arResId);
                ArOrder newArOrder = ArOrderConvert.INSTANCE.dtoConvertToAr(newArOrderDTO);


                arOrderService.startWorkFlow(newArOrder, arResId);

                //ApOrderDO newApOrderDO = apOrderRepo.findById(apResId).get();
                //ApOrder newApOrder = ApOrderConvert.INSTANCE.convert(newApOrderDO);

                ApOrderDTO newApOrderDTO = apOrderRepoProc.get(apResId);
                ApOrder newApOrder = ApOrderConvert.INSTANCE.dtoConvertToAr(newApOrderDTO);

                //提交变审判中 启动工作流
                /*if (newApOrder.getProcInstId() == null
                        || WorkflowConstant.CAN_START_PROC_STATUSES.contains(newApOrder.getProcInstStatus())) {
                    // 启动流程
                    String procInstName = "应付单审核-" + newApOrder.getApOrderNo();
                    String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
                    ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, apResId.toString(), new HashMap<>());
                    apOrderDomainService.updateWorkInfo(processInfo, apResId);
                }*/
                apOrderService.startWorkFlow(newApOrder, apResId);

                arOrderDomainService.updateSourceNo(newApOrderDTO.getApOrderNo(),arResId);
                apOrderDomainService.updateSourceNo(newArOrderDTO.getArOrderNo(),apResId);

                expLedgerRepoProc.updateFinFlagByIds(allIdList,"1");

            }else if(Objects.equals("OUTSIDE",ioType)){
                //如果供应商类型=外部，只生成审批中应付单。
                ApOrder apOrder = assembledAp(saveParam,expLedgerPageVOList,expTypeMap,ouRpcSimpleDTO,purSuppBaseRpcDTO);
                //Long apResId = apOrderDomainService.save(apOrder);
                Long apResId = apOrderDomainService.commit(apOrder);
                ApOrderDO newApOrderDO = apOrderRepo.findById(apResId).get();
                ApOrder newApOrder = ApOrderConvert.INSTANCE.convert(newApOrderDO);
                //提交变审判中 启动工作流
                if (newApOrder.getProcInstId() == null
                        || WorkflowConstant.CAN_START_PROC_STATUSES.contains(newApOrder.getProcInstStatus())) {
                    // 启动流程
                    String procInstName = "应付单审核-" + newApOrder.getApOrderNo();
                    String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
                    ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, apResId.toString(), new HashMap<>());
                    apOrderDomainService.updateWorkInfo(processInfo, apResId);
                }

                expLedgerRepoProc.updateFinFlagByIds(allIdList,"1");


            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司的供应商的内外部类型不匹配");
            }

        } catch (Exception e) {
            log.error("费用计算台账生成应收应付发生错误,错误原因: {}", e.getMessage());
            expLedgerRepoProc.updateFinFlagByIds(allIdList,"2");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "费用计算台账生成应收应付发生错误,错误原因:"+e.getMessage());

        }

    }


    /*private void generateApOrder(){

    }

    private void generateArOrder(){

    }*/

    private ApOrder assembledAp(ExpLedgerGenApArSaveParam saveParam,List<ExpLedgerPageVO> expLedgerPageVOList,
                                Map<String, ExpTypeDTO> expTypeMap,OrgOuRpcSimpleDTO ouRpcSimpleDTO,PurSuppBaseRpcDTO purSuppBaseRpcDTO){


        if (Objects.isNull(ouRpcSimpleDTO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "销售公司信息不存在");
        }
        if (Objects.isNull(purSuppBaseRpcDTO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司的供应商信息不存在");
        }

        ApOrder apOrder = new ApOrder();
        apOrder.setId(null);
        apOrder.setSourceNo(null);
        //自动生成
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(ouRpcSimpleDTO.getOuCode());
        apOrder.setOuId(ouRpcSimpleDTO.getId());
        apOrder.setOuName(ouRpcSimpleDTO.getOuName());
        //AP_DOC_CLS EXPENSES_TYPE
        //TODO 是在原来的UDC AP_DOC_CLS 上增加一个费用类型，还是把费用类型的UDC值都增加到原来的UDC AP_DOC_CLS
        apOrder.setCreateMode("EXP");

        //应付单类型配置
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode(FinConstant.AP_TYPE_CODE_YFD02_SYS);
        List<ApTypeDTO> apTypeDTOList = apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)){
            throw new BusinessException("未匹配到应付单类型配置("+FinConstant.AP_TYPE_CODE_YFD02_SYS+")");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1 ){
            throw new BusinessException("匹配到多条应付单类型的配置规则("+FinConstant.AP_TYPE_CODE_YFD02_SYS+")");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        ApTypeDTO apTypeDTO = apTypeDTOList.get(0);
        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());

        //是否自动审核
        Boolean isAuto = false;
        if (isAuto) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        apOrder.setBuDate(LocalDateTime.now());

        apOrder.setCurrCode("CNY");
        apOrder.setCurrName("人民币");
        apOrder.setExchangeRate(BigDecimal.ONE);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setSuppId(purSuppBaseRpcDTO.getId());
        apOrder.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        apOrder.setSuppName(purSuppBaseRpcDTO.getSuppName());
        apOrder.setInOutCust(purSuppBaseRpcDTO.getIoType());
        apOrder.setRelevanceOuCode(null);
        //系统内供应商关联的团内公司，系统外供应商空着
        if (Objects.equals(purSuppBaseRpcDTO.getSuppType2(),"INNER")){
            apOrder.setRelevanceOuCode(purSuppBaseRpcDTO.getOuCode2());
        }

        apOrder.setBuId(null);
        apOrder.setBuCode(null);
        apOrder.setBuName(null);
        apOrder.setBuType(null);
        apOrder.setPayMentName(null);
        apOrder.setPayMentId(null);
        apOrder.setPayMentCode(null);
        apOrder.setProtocolCode(purSuppBaseRpcDTO.getProtocolCode());
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode("CNY");
        apOrder.setLocalCurrName("人民币");
        apOrder.setVerState((UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode()));
        apOrder.setVerAmt(BigDecimal.ZERO);
        String addrNo = Objects.isNull(purSuppBaseRpcDTO.getAddrNo()) ? null : String.valueOf(purSuppBaseRpcDTO.getAddrNo());
        apOrder.setAddrNo(addrNo);
        apOrder.setSuppAddrNo(addrNo);
        apOrder.setRemark(saveParam.getRemark());

        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setAuditRejection(null);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(null);
        apOrder.setApprovedTime(null);

        /*apOrder.setTenantId();
        apOrder.setBelongOrgId();
        apOrder.setTenantOrgId);
        apOrder.setRemark();*/
        apOrder.setCreateUserId(null);
        apOrder.setCreator(null);
        apOrder.setCreateTime(null);
        /*apOrder.setModifyUserId();
        apOrder.setUpdater();
        apOrder.setModifyTime();
        apOrder.setDeleteFlag();
        apOrder.setAuditDataVersion();
        apOrder.setSecBuId();
        apOrder.setSecUserId();
        apOrder.setSecOuId();*/




        List<ApOrderDtl> apOrderDtlList = assembledApDtl(apOrder,expLedgerPageVOList,null,expTypeMap);
        apOrder.setApOrderDtlList(apOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);


        // 汇总列表数据添加
        List<ApOrderDtlGroup> apOrderDtlGroups = this.genApDtlGroup(apOrder);
        apOrder.setApOrderDtlGroupList(apOrderDtlGroups);

        return apOrder;
    }



    /**
     *
     *  应付单明细
     */
    private List<ApOrderDtl> assembledApDtl(ApOrder apOrder,List<ExpLedgerPageVO> expLedgerPageVOList,Long masId,Map<String, ExpTypeDTO> expTypeMap){

        List<ApOrderDtl> apOrderDtlList = expLedgerPageVOList.stream().map(expLedgerPageVO -> {

            ApOrderDtl apOrderDtl = new ApOrderDtl();

            //apOrderDtl.setId(null);
            apOrderDtl.setMasId(masId);
            apOrderDtl.setSourceNo(expLedgerPageVO.getSourceDocNo());
            apOrderDtl.setSourceLine(null);

            //TODO 后续拓展，其实这里的商品不是单据上的商品，是费用类型对应的商品，
            //但是这个关联关系我还没做专门的配置  你先写死  费用类型是物流费的时候  就取物流  这个虚拟商品
            //目前只有物流费用
            //费用类型=物流费时，默认运费
            //apOrderDtl.setTaxRate(expLedgerPageVO.getTaxRate());
            if (Objects.equals(expLedgerPageVO.getExpTypeCode(),UdcEnum.FIN_EXPENSES_TYPE_WLF.getValueCode())){

                ExpTypeDTO expTypeDTO = expTypeMap.get(expLedgerPageVO.getExpTypeCode());
                apOrderDtl.setItemId(10001L);
                apOrderDtl.setItemCode("WLXNSPCODE");
                apOrderDtl.setItemName("物流虚拟商品");
                if (Objects.nonNull(expTypeDTO)){
                    apOrderDtl.setItemId(expTypeDTO.getItemId());
                    apOrderDtl.setItemCode(expTypeDTO.getItemCode());
                    apOrderDtl.setItemName(expTypeDTO.getItemName());
                    apOrderDtl.setItemType(expTypeDTO.getItemType());
                    apOrderDtl.setSmallCateCode(expTypeDTO.getSmallCateCode());
                    apOrderDtl.setSmallCateName(expTypeDTO.getSmallCateName());
                    apOrderDtl.setUom(expTypeDTO.getUom());
                    apOrderDtl.setUomName(expTypeDTO.getUomName());
                    apOrderDtl.setTaxRate(expTypeDTO.getTaxRate());
                }
            }


            if(Objects.nonNull(expLedgerPageVO.getAmt()) && (expLedgerPageVO.getAmt().compareTo(BigDecimal.ZERO) == -1)){
                apOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt().abs());
                apOrderDtl.setPrice(expLedgerPageVO.getAmt().abs());
                apOrderDtl.setQty(BigDecimal.ONE.negate());
            }else {
                apOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt());
                apOrderDtl.setPrice(expLedgerPageVO.getAmt());
                apOrderDtl.setQty(BigDecimal.ONE);
            }

            //apOrderDtl.setExclTaxPrice(null);
            //apOrderDtl.setPrice(null);
            //apOrderDtl.setTaxRate(expLedgerPageVO.getTaxRate());
            apOrderDtl.setTotalAmt(expLedgerPageVO.getAmt());
            apOrderDtl.setExclTaxAmt(expLedgerPageVO.getNetAmt());
            apOrderDtl.setTaxAmt(expLedgerPageVO.getTaxAmt());
            apOrderDtl.setTotalCurAmt(expLedgerPageVO.getAmt());
            apOrderDtl.setExclTaxCurAmt(expLedgerPageVO.getNetAmt());
            apOrderDtl.setTaxCurAmt(expLedgerPageVO.getTaxAmt());


            apOrderDtl.setRemark(expLedgerPageVO.getRemark());

             /*apOrderDtl.setTenantId();
            apOrderDtl.setBelongOrgId();
            apOrderDtl.setTenantOrgId);
            apOrderDtl.setRemark();*/
            apOrderDtl.setCreateUserId(null);
            apOrderDtl.setCreator(null);
            apOrderDtl.setCreateTime(null);
            /*apOrderDtl.setModifyUserId();
            apOrderDtl.setUpdater();
            apOrderDtl.setModifyTime();
            apOrderDtl.setDeleteFlag();
            apOrderDtl.setAuditDataVersion();
            apOrderDtl.setSecBuId();
            apOrderDtl.setSecUserId();
            apOrderDtl.setSecOuId();*/
            apOrderDtl.setSourceNoDid(null);
            apOrderDtl.setProtocolCode(apOrder.getProtocolCode());


            return apOrderDtl;
        }).collect(Collectors.toList());

        return apOrderDtlList;

    }

    /**
     * 根据应付单明细生成汇总List
     *
     * @return
     */
    public List<ApOrderDtlGroup> genApDtlGroup(ApOrder apOrder) {
        // 获取明细的List
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        List<ApOrderDtlGroup> resList = new ArrayList<>();
        for (Map.Entry<String,List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            // 对集合中元素进行计算
            // 数量的总和
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额的总和
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额（本位币）taxCurAmt
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额 exclTaxAmt
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额（本位币）exclTaxCurAmt
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额 totalAmt
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额（本位币）totalCurAmt
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

            // 拼接返回对象
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
            // 页面选择参数 (设置费用部门/费用类型)
        }
        return resList;
    }


    private ArOrder assembledAr(ExpLedgerGenApArSaveParam saveParam,List<ExpLedgerPageVO> expLedgerPageVOList,TmsOuRespVO tmsOuRespVO,
                                Map<String, ExpTypeDTO> expTypeMap,OrgOuRpcSimpleDTO ouRpcSimpleDTO,PurSuppBaseRpcDTO purSuppBaseRpcDTO){

        if (Objects.isNull(tmsOuRespVO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司信息不存在");
        }
        /*if (Objects.isNull(purSuppBaseRpcDTO)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司的供应商信息不存在");
        }*/
        //销售公司对应的客户
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCorBusinCodes(Arrays.asList(saveParam.getOuCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "销售公司的客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);


        ArOrder arOrder = new ArOrder();

        arOrder.setSourceNo(null);
        //自动生成
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(tmsOuRespVO.getLogisticsOuCode());
        arOrder.setOuId(tmsOuRespVO.getId());
        arOrder.setOuName(tmsOuRespVO.getLogisticsOuName());

        //DOC_CLS EXPENSES_TYPE
        //TODO 是在原来的UDC DOC_CLS 上增加一个费用类型，还是把费用类型的UDC值都增加到原来的UDC DOC_CLS
        arOrder.setCreateMode("EXP");

        //应收单类型配置
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setArTypeCode(FinConstant.AR_TYPE_CODE_YSD02_SYS);
        List<ArTypeDTO> arTypeDTOList = arTypeDomainService.selectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)){
            throw new BusinessException("未匹配到应收单类型配置("+FinConstant.AR_TYPE_CODE_YSD02_SYS+")");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1 ){
            throw new BusinessException("匹配到多条应收单类型的配置规则("+FinConstant.AR_TYPE_CODE_YSD02_SYS+")");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        ArTypeDTO arTypeDTO = arTypeDTOList.get(0);
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());

       //是否自动审核
        Boolean isAuto = false;
        if (isAuto) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }

        arOrder.setBuDate(LocalDateTime.now());

        arOrder.setCurrCode("CNY");
        arOrder.setCurrName("人民币");
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("人民币");
        arOrder.setExchangeRate(BigDecimal.ONE);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setCustId(custBaseDTO.getId());
        arOrder.setCustCode(custBaseDTO.getCustCode());
        arOrder.setCustName(custBaseDTO.getCustName());
        arOrder.setInOutCust(custBaseDTO.getInOutCust());
        arOrder.setRelevanceOuCode(null);
        //系统内客户对应的团内公司，系统外客户空着
        if (Objects.equals(custBaseDTO.getCustType2(),"C")){
            arOrder.setRelevanceOuCode(custBaseDTO.getCorBusinCode());
        }

        arOrder.setBuId(null);
        arOrder.setBuCode(null);
        arOrder.setBuName(null);
        arOrder.setBuType(null);
        //付款条件
        //arOrder.setPayMentName();
        //arOrder.setPayMentId();
        //arOrder.setPayMentCode();
        arOrder.setProtocolCode(custBaseDTO.getPaymentTerm());
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);

        arOrder.setOrgId(null);
        arOrder.setOrgCode(null);
        arOrder.setOrgName(null);
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        //TODO 待建 来源自arType表
        arOrder.setArOrderType("EXP");

        arOrder.setDocType(null);
        arOrder.setDocType2(null);
        arOrder.setDocCls(null);
        arOrder.setRemark(saveParam.getRemark());
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setAuditRejection(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(null);
        arOrder.setApprovedTime(null);

        /*arOrder.settenantId();
        arOrder.setBelongOrgId();
        arOrder.setTenantOrgId);
        arOrder.setRemark();*/
        arOrder.setCreateUserId(null);
        arOrder.setCreator(null);
        arOrder.setCreateTime(null);
        /*arOrder.setModifyUserId();
        arOrder.setUpdater();
        arOrder.setModifyTime();
        arOrder.setDeleteFlag();
        arOrder.setAuditDataVersion();
        arOrder.setSecBuId();
        arOrder.setSecUserId();
        arOrder.setSecOuId();*/
        arOrder.setSettlementType(null);
        arOrder.setEs1(null);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        //arOrder.setEs6(UdcEnum.RED_STATE_NO.getValueCode());
        arOrder.setEs6(null);
        /*arOrder.setEs7();
        arOrder.setEs8();
        arOrder.setEs9();
        arOrder.setEs10();
        arOrder.RelateId();
        arOrder.setJournalState();*/
        arOrder.setDocType(null);

        //处理组装明细
        List<ArOrderDtl> arOrderDtlList = assembledArDtl(arOrder,expLedgerPageVOList,null,expTypeMap);
        arOrder.setDtlList(arOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);



        return arOrder;
    }

    private List<ArOrderDtl> assembledArDtl(ArOrder arOrder,List<ExpLedgerPageVO> expLedgerPageVOList,Long masId,Map<String, ExpTypeDTO> expTypeMap){

        List<ArOrderDtl> arOrderDtlList = expLedgerPageVOList.stream().map(expLedgerPageVO -> {


            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setSourceNo(expLedgerPageVO.getSourceDocNo());
            arOrderDtl.setSourceLine(null);

            //TODO 后续拓展，其实这里的商品不是单据上的商品，是费用类型对应的商品，
            //但是这个关联关系我还没做专门的配置  你先写死  费用类型是物流费的时候  就取物流  这个虚拟商品
            //目前只有物流费用
            //费用类型=物流费时，默认运费
            //arOrderDtl.setTaxRate(expLedgerPageVO.getTaxRate());
            if (Objects.equals(expLedgerPageVO.getExpTypeCode(),UdcEnum.FIN_EXPENSES_TYPE_WLF.getValueCode())){
                ExpTypeDTO expTypeDTO = expTypeMap.get(expLedgerPageVO.getExpTypeCode());
                arOrderDtl.setItemId(10001L);
                arOrderDtl.setItemCode("WLXNSPCODE");
                arOrderDtl.setItemName("物流虚拟商品");
                if (Objects.nonNull(expTypeDTO)){
                    arOrderDtl.setItemId(expTypeDTO.getItemId());
                    arOrderDtl.setItemCode(expTypeDTO.getItemCode());
                    arOrderDtl.setItemName(expTypeDTO.getItemName());
                    arOrderDtl.setItemType(expTypeDTO.getItemType());
                    arOrderDtl.setSmallCateCode(expTypeDTO.getSmallCateCode());
                    arOrderDtl.setSmallCateName(expTypeDTO.getSmallCateName());
                    arOrderDtl.setUom(expTypeDTO.getUom());
                    arOrderDtl.setUomName(expTypeDTO.getUomName());
                    arOrderDtl.setTaxRate(expTypeDTO.getTaxRate2());
                }

            }

            if(Objects.nonNull(expLedgerPageVO.getAmt()) && (expLedgerPageVO.getAmt().compareTo(BigDecimal.ZERO) == -1)){
                arOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt().abs());
                arOrderDtl.setPrice(expLedgerPageVO.getAmt().abs());
                arOrderDtl.setQty(BigDecimal.ONE.negate());
            }else {
                arOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt());
                arOrderDtl.setPrice(expLedgerPageVO.getAmt());
                arOrderDtl.setQty(BigDecimal.ONE);
            }

            //arOrderDtl.setExclTaxPrice(null);
            //arOrderDtl.setPrice(null);
            //arOrderDtl.setTaxRate(expLedgerPageVO.getTaxRate());

            arOrderDtl.setTotalAmt(expLedgerPageVO.getAmt());
            arOrderDtl.setExclTaxAmt(expLedgerPageVO.getNetAmt());
            arOrderDtl.setTaxAmt(expLedgerPageVO.getTaxAmt());
            arOrderDtl.setTotalCurAmt(expLedgerPageVO.getAmt());
            arOrderDtl.setExclTaxCurAmt(expLedgerPageVO.getNetAmt());
            arOrderDtl.setTaxCurAmt(expLedgerPageVO.getTaxAmt());


            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            //TODO 待确定
            arOrderDtl.setExpensesType(expLedgerPageVO.getExpTypeCode());

            arOrder.setSaleUserId(null);
            arOrder.setSaleUser(null);
            arOrder.setCurrCode("CNY");
            arOrder.setCurrName("人民币");
            arOrder.setExchangeRate(BigDecimal.ONE);


             /*arOrderDtl.settenantId();
            arOrderDtl.setBelongOrgId();
            arOrderDtl.setTenantOrgId);
            arOrderDtl.setRemark();*/
            arOrderDtl.setCreateUserId(null);
            arOrderDtl.setCreator(null);
            arOrderDtl.setCreateTime(null);
            /*arOrderDtl.setModifyUserId();
            arOrderDtl.setUpdater();
            arOrderDtl.setModifyTime();
            arOrderDtl.setDeleteFlag();
            arOrderDtl.setAuditDataVersion();
            arOrderDtl.setSecBuId();
            arOrderDtl.setSecUserId();
            arOrderDtl.setSecOuId();*/
            arOrderDtl.setEs11(null);
            arOrderDtl.setEs12(null);
            arOrderDtl.setEs13(null);
            arOrderDtl.setEs14(null);
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            //arOrderDtl.setEs19(arOrder.getProtocolCode());
            arOrderDtl.setProtocolCode(arOrder.getProtocolCode());

            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            //arOrderDtl.setEs25();
            arOrderDtl.setRelateId(null);

            return arOrderDtl;
        }).collect(Collectors.toList());

        return arOrderDtlList;
    }


    private void checkGenerateApArOrder(ExpLedgerGenApArSaveParam saveParam){
        if (StringUtils.isBlank(saveParam.getExpTypeCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "费用类型编码为空");
        }
        if (StringUtils.isBlank(saveParam.getOuCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "销售公司编码为空");
        }
        if (StringUtils.isBlank(saveParam.getCarrier())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "物流公司编码为空");
        }
        if (Objects.isNull(saveParam.getSourceDocNoDateStart())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "单据日期开始为空");
        }
        if (Objects.isNull(saveParam.getSourceDocNoDateEnd())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "单据日期结束为空");
        }
    }


}
