package com.elitesland.fin.application.service.workflow.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.BigDecimalUtil;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/5/7 13:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RecOrderProcessServiceImpl implements RecOrderProcessService {

    @Autowired
    @Lazy
    private PayOrderService payOrderService;
    private final PayTypeService payTypeService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PurSuppOutService purSuppOutService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;

    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final RecOrderDomainService recOrderDomainService;

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> recOrderDtlDTOS = recOrderDtlRepoProc.queryByMasId(id);
        if (recOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(recOrderDO)
                .set(recOrderDO.procInstStatus, procInstStatus)
                .where(recOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
                // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(recOrderDO.procInstId, (String) null);
                break;
                //审批中 业务依旧是待审批
            case APPROVING:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(recOrderDO.submitTime,LocalDateTime.now());
                break;
            // 审批拒绝 业务数据草稿
            case REJECTED:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditRejection, commentInfo.getComment())
                        .set(recOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditRejection, commentInfo.getComment())
                        .set(recOrderDO.auditUser, commentInfo.getUserName())
                        .set(recOrderDO.procInstId, (String) null);
                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(recOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                    .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务

        //获取客户类型
        String custType2 = getCustType2(recOrderDTO);
        List<PayOrderDO> data = payOrderRepoProc.queryBySourceNo(recOrderDTO.getRecOrderNo());
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //收款单的客户类型=系统内，审批通过后同步生成审批通过的付款单。如果付款单中来源单号已经有此收款单，禁止生成。
            if ("C".equals(custType2)) {
                if (CollUtil.isEmpty(data)) { //没有关联的收款单

                    //收款单的来源单据是付款单时审批通过不用生成付款单;
                    /*PayOrderParam payOrderParam = new PayOrderParam();
                    payOrderParam.setPayOrderNoList(Collections.singletonList(recOrderDTO.getSourceNo()));
                    List<PayOrderDTO> payOrderDTOList = payOrderRepoProc.selectPayOrderByParam(payOrderParam);*/
                    if (!Objects.equals(recOrderDTO.getCreateMode(),"PAY")){
                        PayOrderSaveParam payOrderSaveParam = getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                        payOrderService.save(payOrderSaveParam);
                    }



                }
            }
            //自动核销
            log.info("收款单审批通过，开始自动核销");
            finArRecVerApplyService.autoWriteoffRec(recOrderDTO);

            //外部客户
            if (isOutterCust(recOrderDTO)) {
                log.info("外部客户,审批完成自动创建账户流水");
                recOrderDomainService.createFinFlow(recOrderDTO);
            }

            //处理核销状态
            updateVerState(id);
        }
        //增加校验，如果收款单的客户类型=系统内且收款单已经生成付款单，不允许取消审批
        if (procInstStatus.equals(ProcInstStatus.NOTSUBMIT)) {
            if ("C".equals(custType2)) {
                if (CollUtil.isNotEmpty(data)) { //没有关联的收款单
                    throw new com.elitescloud.boot.exception.BusinessException("收款单已经生成关联付款单，不允许取消审批");
                }
            }
        }


    }

    //是否是外部客户
    private boolean isOutterCust(RecOrderDTO recOrderDTO) {
        String inOutCust = recOrderDTO.getInOutCust();
        if ("OUT".equals(inOutCust)) {
            return true;
        } else {
            return false;
        }
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<PayTypeVO> payTypeVOList = payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    private PayOrderSaveParam getPayOrderSaveParam(RecOrderDTO recOrderDTO, List<RecOrderDtlDTO> recOrderDtlDTOS) {
        log.info("生成付款单入参:recOrderDTO:{},recOrderDtlDTOS:{}", JSONUtil.toJsonStr(recOrderDTO),
                JSONUtil.toJsonStr(recOrderDtlDTOS));
        //获取客户信息
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(recOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("客户信息:{}", JSONUtil.toJsonStr(custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("客户关联公司编码:{}", corBusinCode);
        if (StrUtil.isBlank(corBusinCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户对应的公司编码不存在");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes =
                rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户对应的公司信息不存在");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("客户关联公司信息:{}", JSONUtil.toJsonStr(orgOuRpcSimpleDTO));

        //获取公司关联的供应商信息
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(recOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单公司关联的供应商不存在");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);

        PayOrderSaveParam param = new PayOrderSaveParam();
        //内外部
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());
        //币种
        param.setCurrCode(recOrderDTO.getCurrCode());
        param.setCurrName(recOrderDTO.getCurrName());
        //公司
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        //供应商
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        //来源系统单号
        param.setSourceNo(recOrderDTO.getRecOrderNo());
        //付款单类型
        param.setPayTypeCode("AP");
        param.setPayTypeName("标准付款");
        param.setPayTypeId(getApTypeIdByCode("AP"));
        //来源单据
        param.setCreateMode("REC");
        //总金额
        param.setTotalAmt(recOrderDTO.getTotalAmt());
        //实际支付金额
        param.setRealPayAmt(recOrderDTO.getRealRecAmt());
        //业务日期
        param.setBuDate(recOrderDTO.getReDate());
        //是否期初
        param.setInitFlag(recOrderDTO.getInitFlag());
        //总金额（本位币）
        param.setTotalCurAmt(recOrderDTO.getTotalCurAmt());
        //实际支付金额（本位币）
        param.setRealPayCurAmt(recOrderDTO.getRealRecCurAmt());
        //预计付款日期
        param.setApDate(recOrderDTO.getReDate());
        //是否预付
        param.setApFlag(recOrderDTO.getReFlag());
        //汇率
        param.setExchangeRate(recOrderDTO.getExchangeRate());
        //状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(recOrderDTO.getRedState());
        //红冲对应原单号
        String redSourceNo = recOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank(redSourceNo)) {
            List<PayOrderDO> payOrderDOS = payOrderRepoProc.queryBySourceNo(redSourceNo);
            if (CollUtil.isNotEmpty(payOrderDOS)) {
                PayOrderDO payOrderDO = payOrderDOS.get(0);
                param.setRedSourceNo(payOrderDO.getPayOrderNo());
                param.setRedSourceId(payOrderDO.getId());
                param.setRedState(true);
            }
        }
        Map<String, List<RecOrderDtlDTO>> groupedData =
                recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getRecAccount() + e.getEs16()));
        log.info("分组后 groupedData:{}", JSONUtil.toJsonStr(groupedData));
        //拟定状态
        param.setProposedStatus("DRAFT");
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = groupedData.entrySet().stream().map(
                entry -> {
                    BigDecimal realRecAmtTotal = BigDecimal.ZERO;
                    BigDecimal realRecCurAmtTotal = BigDecimal.ZERO;
                    for (RecOrderDtlDTO recOrderDtlDTO : entry.getValue()) {
                        realRecAmtTotal = realRecAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecAmt()) );
                        realRecCurAmtTotal = realRecCurAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecCurAmt()) );
                    }
                    RecOrderDtlDTO payorderDtlDto = entry.getValue().get(0);
                    BigDecimal totalAmt =
                            entry.getValue().stream().filter(e -> e.getTotalAmt() != null).map(RecOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalCurAmt =
                            entry.getValue().stream().filter(e -> e.getTotalCurAmt() != null).map(RecOrderDtlDTO::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    PayOrderDtlSaveParam payOrderDtlSaveParam = new PayOrderDtlSaveParam();
                    //来源行号
                    payOrderDtlSaveParam.setSourceLine(payorderDtlDto.getSourceLine());
                    payOrderDtlSaveParam.setSourceLineId(payorderDtlDto.getSourceLineId());
                    //付款方式
                    payOrderDtlSaveParam.setPayType(payorderDtlDto.getRecType());
                    //我方银行账户
                    payOrderDtlSaveParam.setPayBank(payorderDtlDto.getEs17());
                    //我方银行账号
                    payOrderDtlSaveParam.setPayAccount(payorderDtlDto.getEs16());
                    //总金额
                    payOrderDtlSaveParam.setTotalAmt(totalAmt);
                    //总金额（本位币）
                    payOrderDtlSaveParam.setTotalCurAmt(totalCurAmt);
                    //收款方银行账户
                    payOrderDtlSaveParam.setRecBank(payorderDtlDto.getRecBank());
                    //收款方银行账号
                    payOrderDtlSaveParam.setRecAccount(payorderDtlDto.getRecAccount());
                    //实际支付金额
                    payOrderDtlSaveParam.setRealPayAmt(realRecAmtTotal);
                    //实际支付金额（本位币）
                    payOrderDtlSaveParam.setRealPayCurAmt(realRecCurAmtTotal);
                    //已核销金额
                    payOrderDtlSaveParam.setVerAmt(BigDecimal.ZERO);
                    //未核销金额
                    payOrderDtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
                    //核销中金额
                    payOrderDtlSaveParam.setUnVerAmt(param.getTotalAmt());
                    return payOrderDtlSaveParam;
                }
        ).collect(Collectors.toList());
        param.setPayOrderDtlSaveParams(payOrderDtlSaveParams);
        log.info("生成付款单参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }

    private String getCustType2(RecOrderDTO recOrderDTO) {
        List<CrmCustBaseDTO> custBaseInfoList =
                rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(recOrderDTO.getCustCode()));
        if (CollUtil.isEmpty(custBaseInfoList)) {
            throw new com.elitescloud.boot.exception.BusinessException("客户编码" + recOrderDTO.getCustCode() +
                    "对应客户信息不存在");
        }
        CrmCustBaseDTO crmCustBaseDTO = custBaseInfoList.get(0);
        return crmCustBaseDTO.getCustType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(businessId);
        if (recOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(recOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }

    private void updateVerState(Long id){
        //处理核销状态
        RecOrderDTO newRecOrderDTO = recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> newRecOrderDtlDTOList = recOrderDtlRepoProc.queryByMasId(id);

        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newRecOrderDtlDTOList)) {
            for (RecOrderDtlDTO recOrderDtlDTO : newRecOrderDtlDTOList) {
                if(null != recOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(recOrderDtlDTO.getVerAmt());
                }
                if(recOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(recOrderDtlDTO.getApplyVerAmTing());
                }
                if(recOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(recOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newRecOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newRecOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newRecOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)){
            recOrderRepoProc.updateVerState(verState,id);
        }

    }

}
