package com.elitesland.fin.application.web.test;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Brian
 * @date 2024/7/16 16:59
 */
@Slf4j
@RestController
@RequestMapping("/fin/test")
@RequiredArgsConstructor
@Api(value = "测试", tags = {"测试"})
public class TestController {
    @Autowired
    private RedisUtils redisUtils;
    @PostMapping("redis/del")
    @ApiOperation("批量删除redis key")
    public ApiResult<PagingVO<PayOrderVO>> del(@RequestBody List<String> keyList) {
        if(CollectionUtils.isNotEmpty(keyList)){
            keyList.stream().forEach(v->{
                redisUtils.del(v);
                log.info("-----------删除redis key:{}成功",v);
            });
        }
        return ApiResult.ok();
    }
    @PostMapping("redis/get")
    @ApiOperation("批量获取redis key的值")
    public ApiResult<Map> get(@RequestBody List<String> keyList) {
        Map map = new HashMap();
        if(CollectionUtils.isNotEmpty(keyList)){
            keyList.stream().forEach(v->{
                map.put(v,redisUtils.get(v));
                log.info("-----------删除redis key:{}成功",v);
            });
        }
        log.info("-----------批量获取redis成功：{}", JSON.toJSONString(map));
        return ApiResult.ok(map);
    }
    @PostMapping("redis/sederializer")
    @ApiOperation("序列化/反序列化redis key的值")
    public ApiResult sederializer() {
        String key="fin:sederializer:student";
        List<User> users = new ArrayList<>();
        users.add(new User(1, "张三", LocalDateTime.now().minusDays(500)));
        users.add(new User(1, "李四", LocalDateTime.now().minusDays(1000)));
        redisUtils.set(key, JSON.toJSONString(users));
        Object usersNew =redisUtils.get(key);
        log.info("-----------获取redis key:{}成功", usersNew);
        return ApiResult.ok();
    }
    @Data

    class User{
        int id;
        String name;
        LocalDateTime birthDay;

        public User() {
        }

        public User(int id, String name, LocalDateTime birthDay) {
            this.id = id;
            this.name = name;
            this.birthDay = birthDay;
        }
    }

}
