package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlGroupConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.*;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDtlDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.factory.aporder.ApOrderFactory;
import com.elitesland.fin.infr.repo.aporder.*;
import com.elitesland.fin.repo.expense.ExpLedgerRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.rpc.ystsupp.RmiSupportRpcService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcParam;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.provider.PurAccountCheckDtlProvider;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import com.esotericsoftware.minlog.Log;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.boot.exception.BusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aporder
 * @date 2022/3/16 10:45
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApOrderDomainServiceImpl implements ApOrderDomainService {

    private final RmiSupportRpcService rmiSupportRpcService;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ApOrderFactory apOrderFactory;
    private final ApOrderDtlGroupRepo apOrderDtlGroupRepo;
    private final ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc;
    //发号器生成付款单号
    private final SeqNumProvider sysNumberRuleService;
    private final ApOrderToPayDomainService apOrderToPayDomainService;
    private final RmiPurRpcService rmiPurRpcService;
    private final PurAccountProvider purAccountProvider;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final InputInvService inputInvService;
    private final PurSuppOutService purSuppOutService;
    private final ExpLedgerRepoProc expLedgerRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final InvStkProvider invStkProvider;
    private final ApTypeDomainService apTypeDomainService;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long save(ApOrder apOrder) {

        if (Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(apOrder.getProtocolCode())){
            handlePurSuppProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }

        //非手工
        if (!Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }


        //明细赋值
        apOrder.dtlAssign();
        if (apOrder.getVerAmt() == null) {
            // 设置默认
            apOrder.setDef();
        }
        // 单头信息输入的校验
        apOrder.check();
        // 校验明细行
        apOrder.checkDtlList();
        // 手工来源
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            // 校验明细金额
            apOrder.checkAmt();
            // 校验明细金额/单头/汇总金额
            apOrder.checkAmtSum();

        }
        // 对账单来源
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            // 设置默认值
            apOrder.setPacckDef();
            // 进行统计的计算
            apOrder.countByPacck();
            // 汇总列表数据添加
            List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
            apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        }
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        // 数据的新增
        ApOrderDO apOrderRes = saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    /**
     * 处理手工时付款协议为空取供应商的
     *
     * @return
     */
    private void handlePurSuppProtocolCode(ApOrder apOrder){
        if (StringUtils.isBlank(apOrder.getProtocolCode())){
            //主表就默认取供应商维护的付款协议
            Map<String, PurSuppBaseRpcDTO> suppMap = purSuppOutService.findSimpleSuppMapByCodes(Collections.singletonList(apOrder.getSuppCode()));
            if (MapUtil.isNotEmpty(suppMap) && suppMap.containsKey(apOrder.getSuppCode())){
                PurSuppBaseRpcDTO purSuppBaseRpcDTO = suppMap.get(apOrder.getSuppCode());
                if (Objects.nonNull(purSuppBaseRpcDTO)){
                    if (StringUtils.isBlank(purSuppBaseRpcDTO.getProtocolCode())){
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应付单的供应商("+apOrder.getSuppCode()+")的付款协议为空");
                    }else {
                        apOrder.setProtocolCode(purSuppBaseRpcDTO.getProtocolCode());
                    }

                }else {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "手工时付款协议为空时供应商不存在");
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "手工时付款协议为空时供应商不存在");
            }
        }

    }

    /**
     * 处理非手工时付款协议为空取对应来源单据的
     *
     * @return
     */
    private void handleOtherProtocolCode(ApOrder apOrder){
        List<String> relateDoc2NoList = apOrder.getApOrderDtlList().stream().map(ApOrderDtl::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, PurAccountCheckDtlRpcDTO> purAccountCheckDtlMap = rmiPurRpcService.findPurAccountCheckDtlMapByCodes(relateDoc2NoList);

        apOrder.getApOrderDtlList().forEach(apOrderDtl -> {
            if (StringUtils.isBlank(apOrderDtl.getProtocolCode())){
                if (MapUtil.isNotEmpty(purAccountCheckDtlMap) && purAccountCheckDtlMap.containsKey(apOrderDtl.getSourceNo())){
                    PurAccountCheckDtlRpcDTO purAccountCheckDtlRpcDTO = purAccountCheckDtlMap.get(apOrderDtl.getSourceNo());
                    if (Objects.nonNull(purAccountCheckDtlRpcDTO)){
                        if (StringUtils.isBlank(purAccountCheckDtlRpcDTO.getProtocolCode())){
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应付单明细的来源单号("+apOrderDtl.getSourceNo()+")的付款协议为空");
                        }else {
                            apOrderDtl.setProtocolCode(purAccountCheckDtlRpcDTO.getProtocolCode());
                        }

                    }else {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "付款协议为空时来源单据不存在");
                    }
                }else {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "付款协议为空时来源单据不存在");
                }
            }

        });



    }

    private void handleOtherAssemble(ApOrder apOrder){
        if (StringUtils.isBlank(apOrder.getInOutCust()) || StringUtils.isBlank(apOrder.getRelevanceOuCode())){
            Map<String, PurSuppBaseRpcDTO> suppMap = purSuppOutService.findSimpleSuppMapByCodes(Collections.singletonList(apOrder.getSuppCode()));

            //供应商的内外部类型
            if (MapUtil.isNotEmpty(suppMap) && suppMap.containsKey(apOrder.getSuppCode())){
                PurSuppBaseRpcDTO purSuppBaseRpcDTO = suppMap.get(apOrder.getSuppCode());
                if (Objects.nonNull(purSuppBaseRpcDTO)){
                    if (StringUtils.isBlank(apOrder.getInOutCust()) && StringUtils.isNotBlank(purSuppBaseRpcDTO.getIoType())) {
                        apOrder.setInOutCust(purSuppBaseRpcDTO.getIoType());
                    }
                    //系统内供应商关联的团内公司，系统外供应商空着
                    if (Objects.equals(purSuppBaseRpcDTO.getSuppType2(),"INNER") && StringUtils.isBlank(apOrder.getRelevanceOuCode())){
                        apOrder.setRelevanceOuCode(purSuppBaseRpcDTO.getOuCode2());
                    }
                    /*if (Objects.equals(purSuppBaseRpcDTO.getIoType(),"INSIDE") && StringUtils.isBlank(apOrder.getRelevanceOuCode())){
                        apOrder.setRelevanceOuCode(purSuppBaseRpcDTO.getOuCode2());
                    }*/
                }
            }
        }

    }

    /**
     * 根据明细生成汇总List
     *
     * @return
     */
    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        // 获取明细的List
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        List<ApOrderDtlGroup> resList = new ArrayList<>();
        for (Map.Entry<String,List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            // 对集合中元素进行计算
            // 数量的总和
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额的总和
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额（本位币）taxCurAmt
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额 exclTaxAmt
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额（本位币）exclTaxCurAmt
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额 totalAmt
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额（本位币）totalCurAmt
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);

            // 拼接返回对象
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
            // 页面选择参数 (设置费用部门/费用类型)
        }
        return resList;
    }


    /**
     * 对 应付单主表/明细表/汇总明细表
     * 进行数据库新增
     *
     * @param apOrder
     * @return1
     */
    @Transactional(rollbackFor = {Exception.class})
    public ApOrderDO saveOrUpdate(ApOrder apOrder) {
        String ouCode = apOrder.getOuCode();
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO =
                rmiSupportRpcService.findSimpleByOuCodes(ouCode).orElseThrow(new BusinessException("无法获取公司信息," +
                        "无法进行应付暂估差异计算"));
        String taxpayerType = orgOuRpcSimpleDTO.getTaxpayerType();
        log.info("公司编码:{},纳税人类型:{}", ouCode, taxpayerType);
        if (StrUtil.isBlank(taxpayerType)) {
            throw new BusinessException("无法公司获取纳税人类型,公司编码:" + ouCode);
        }
        boolean sType = "S".equals(taxpayerType); //小规模纳税人
        boolean vType = "V".equals(taxpayerType); //一般纳税人
        boolean manualModel = apOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode());

        if (CharSequenceUtil.isBlank(apOrder.getApOrderNo())) {
            // 发号器-生成应付单号
            String apOrderNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.YFD, null);
            apOrder.setApOrderNo(apOrderNo);
        }
        ApOrderDO apOrderDO = ApOrderConvert.INSTANCE.convert(apOrder);
        //新增时锁版本默认值0
        if (apOrderDO.getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.AP_ORDER, apOrderDO);
        ApOrderDO apOrderRes = apOrderRepo.save(apOrderDO);
        // 应付单明细单的新增
        // 根据应付单id删除明细行
        apOrderDtlRepoProc.delByMasId(Lists.newArrayList(apOrderRes.getId()));
        List<ApOrderDtl> apOrderDtlList = apOrder.getApOrderDtlList();
        List<ApOrderDtlDO> apOrderDtlDOS = ApOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        //处理收付款协议
        //计算收款协议（必填）、起算日期、到期付款日字段。
        List<String> protocolCodeList = apOrderDtlDOS.stream().filter(v->StringUtils.isNotBlank(v.getProtocolCode())).map(v -> v.getProtocolCode()).collect(Collectors.toList());
        //1、查询当前收款协议配置，参数协议代码
        List<ReceiptPaymentAgreementVO> receiptPaymentAgreementVOS =null;
        if(CollectionUtils.isNotEmpty(protocolCodeList)){
            receiptPaymentAgreementVOS=receiptPaymentAgreementDomainService.selectPaymentByCodes(protocolCodeList);
        }
        Map<String, Long> protocolCodeIdMap=new HashMap<>();
        Map<Long, List<ReceiptPaymentAgreementDtlVO>> protocolDetailMap=new HashMap<>();
        if(CollectionUtils.isNotEmpty(receiptPaymentAgreementVOS)){
            protocolCodeIdMap = receiptPaymentAgreementVOS.stream().collect(Collectors.toMap(v -> v.getProtocolCode(), v -> v.getId()));
            ReceiptPaymentAgreementDtlPageParam queryVO = new ReceiptPaymentAgreementDtlPageParam();
            queryVO.setMasIdList(receiptPaymentAgreementVOS.stream().map(v->v.getId()).collect(Collectors.toList()));
            List<ReceiptPaymentAgreementDtlVO> receiptPaymentAgreementDtlVOS = receiptPaymentAgreementDtlDomainService.selectByParam(queryVO);
            protocolDetailMap = receiptPaymentAgreementDtlVOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        }
        for (ApOrderDtlDO x : apOrderDtlDOS) {
            x.setMasId(apOrderRes.getId());
            if (Objects.isNull(x.getId())){
                x.setAuditDataVersion(0);
            }
            x.setVerAmt(BigDecimal.ZERO);
            x.setUnVerAmt(x.getTotalAmt());
            x.setApplyVerAmTing(BigDecimal.ZERO);
            ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO=null;
            if(protocolCodeIdMap.containsKey(x.getProtocolCode())){
                if(protocolDetailMap.containsKey(protocolCodeIdMap.get(x.getProtocolCode()))){
                    receiptPaymentAgreementDtlVO = protocolDetailMap.get(protocolCodeIdMap.get(x.getProtocolCode())).get(0);
                }
            }
            LocalDateTime startCalDate = arOrderDomainService.calculateStartCalDate(apOrder.getCreateMode(), apOrder.getBuDate(), receiptPaymentAgreementDtlVO);
            //设置起算日期
            x.setStartCalDate(startCalDate!=null?startCalDate.toLocalDate():null);
            LocalDateTime expirePayDate = arOrderDomainService.calculateExpirePayDate(x.getStartCalDate(), receiptPaymentAgreementDtlVO);
            //设置到期付款日期
            x.setExpirePayDate(expirePayDate!=null?expirePayDate.toLocalDate():null);
            if (manualModel) {
                x.setInvoicePriceVariance(BigDecimal.ZERO);
                //if (Objects.isNull(x.getCostPrice())){
                    if (vType) {
                        x.setCostPrice(x.getExclTaxPrice());
                    } else if (sType) {
                        x.setCostPrice(x.getPrice());
                    }
                //}

            } else {
                //计算ipv
                if (vType && x.getCostPrice() != null) {
                    BigDecimal costPriceAmt = getOrDefaultNumber(x.getCostPrice()).multiply(getOrDefaultNumber(x.getQty())).setScale(2, RoundingMode.HALF_UP);
                    x.setInvoicePriceVariance(x.getExclTaxAmt().subtract(costPriceAmt));
                }
                if (sType && x.getCostPrice() != null) {
                    BigDecimal costPriceAmt = getOrDefaultNumber(x.getCostPrice()).multiply(getOrDefaultNumber(x.getQty())).setScale(2, RoundingMode.HALF_UP);
                    x.setInvoicePriceVariance(x.getTotalAmt().subtract(costPriceAmt));
                }
            }
            apOrderDtlRepo.save(x);
        };
        // 应付单汇总数据新增
        // 根据应付单id删除汇总行
        apOrderDtlGroupRepoProc.delByMasId(Lists.newArrayList(apOrderRes.getId()));
        List<ApOrderDtlGroup> apOrderDtlGroups = apOrder.getApOrderDtlGroupList();
        //对账单来源需要计算汇总ipv
        if (!manualModel) {
            genDtlGroupAgain(apOrderDtlGroups, apOrderDtlDOS);
        }
        if (null != apOrderDtlGroups) {
            List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = ApOrderDtlGroupConvert.INSTANCE.convert(apOrderDtlGroups);
            apOrderDtlGroupDOS.stream().forEach(x -> {
                x.setMasId(apOrderRes.getId());
                apOrderDtlGroupRepo.save(x);
            });
        }
        return apOrderRes;
    }

    //设置汇总的IPV
    private void genDtlGroupAgain(List<ApOrderDtlGroup> apOrderDtlGroups, List<ApOrderDtlDO> apOrderDtlDOS) {

        Map<String, List<ApOrderDtlDO>> dtlMap =
                apOrderDtlDOS.stream().collect(Collectors.groupingBy(ApOrderDtlDO::getItemCode));
        for (ApOrderDtlGroup re : apOrderDtlGroups) {
            String itemCode = re.getItemCode();
            List<ApOrderDtlDO> list = dtlMap.get(itemCode);
            BigDecimal ipvSum =
                    list.stream().filter(e -> e.getInvoicePriceVariance() != null).map(ApOrderDtlDO::getInvoicePriceVariance).reduce(BigDecimal.ZERO,
                    BigDecimal::add);
            re.setInvoicePriceVariance(ipvSum);
        }
    }

    private BigDecimal getOrDefaultNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        } else {
            return bigDecimal;
        }
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = {Exception.class})
    //@Transactional(rollbackFor = {Exception.class})
    public Long commit(ApOrder apOrder) {

        if (Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(apOrder.getProtocolCode())){
            handlePurSuppProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }

        //非手工
        if (!Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }

        //明细赋值
        apOrder.dtlAssign();
        // 校验单头与明细
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        // 校验明细金额
        apOrder.checkAmt();
        // 金额数据校验(单头，明细，汇总)金额的校验
        apOrder.checkAmtSum();
        // 状态为待审批，有自动审核传值的情况
        if (StringUtils.isBlank(apOrder.getOrderState()) ||
                Objects.equals(apOrder.getOrderState(),UdcEnum.APPLY_STATUS_DRAFT.getValueCode())){
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());

        }
        // 进行数据的新增或保存
        ApOrderDO apOrderRes = saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long newCommit(ApOrder apOrder) {

        if (Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(apOrder.getProtocolCode())){
            handlePurSuppProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }

        //非手工
        if (!Objects.equals(apOrder.getCreateMode(),UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(apOrder);
            handleOtherAssemble(apOrder);
        }

        //明细赋值
        apOrder.dtlAssign();
        // 校验单头与明细
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        // 校验明细金额
        apOrder.checkAmt();
        // 金额数据校验(单头，明细，汇总)金额的校验
        apOrder.checkAmtSum();
        // 状态为待审批，有自动审核传值的情况
        if (StringUtils.isBlank(apOrder.getOrderState())  ||
                Objects.equals(apOrder.getOrderState(),UdcEnum.APPLY_STATUS_DRAFT.getValueCode())){
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());

        }
        // 进行数据的新增或保存
        ApOrderDO apOrderRes = saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        apOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSourceNo(String sourceNo, Long id) {
        apOrderRepoProc.updateSourceNo(sourceNo, id);
    }


    @Override
    public ApOrderDTO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = get(id);

        Map<String, OrgOuRpcSimpleDTO> ouMap =  StringUtils.isBlank(apOrderDTO.getRelevanceOuCode()) ? new HashMap<>() : rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(apOrderDTO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(apOrderDTO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)){
            apOrderDTO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        if (Objects.isNull(apOrderDTO.getApTypeId())){
            ApTypePageParam apTypeParam = new ApTypePageParam();
            apTypeParam.setApTypeCode(apOrderDTO.getApTypeCode());
            List<ApTypeDTO> apTypeDTOList =  StringUtils.isBlank(apOrderDTO.getApTypeCode()) ? new ArrayList<>() : apTypeDomainService.selectByParam(apTypeParam);
            Map<String, ApTypeDTO> apTypeMap = CollectionUtil.isEmpty(apTypeDTOList) ? new HashMap<>() : apTypeDTOList.stream().collect(Collectors.toMap(ApTypeDTO::getApTypeCode, t -> t, (t1, t2) -> t1));
            ApTypeDTO apTypeDTO = apTypeMap.get(apOrderDTO.getApTypeCode());
            if (Objects.nonNull(apTypeDTO)){
                apOrderDTO.setApTypeId(apTypeDTO.getId());
            }
        }


        // 新增明细列表
        List<ApOrderDtlDTO> apOrderDtlDOS = apOrderDtlRepoProc.listByMisId(id);

        List<String> protocolCodeList = StringUtils.isBlank(apOrderDTO.getProtocolCode()) ? new ArrayList<>() : Collections.singletonList(apOrderDTO.getProtocolCode());
        List<String> dtlProtocolCodeList = apOrderDtlDOS.stream().map(ApOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> protocolCodeAllList = Stream.of(dtlProtocolCodeList, protocolCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = receiptPaymentAgreementDomainService.selectPaymentAgreementByCodes(protocolCodeAllList);
        handleApOrderDTO(apOrderDTO,agreementMap);
        handleApOrderDtlDTO(apOrderDtlDOS,agreementMap);

        // 新增汇总列表
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDOS);
        List<ApOrderDtlGroupDTO> apOrderDtlGroupDTOS = apOrderDtlGroupRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlGroupDTOList(apOrderDtlGroupDTOS);
        apOrderDTO.setInvoicePriceVariance(apOrderDtlDOS.stream().filter(e -> e.getInvoicePriceVariance() != null).map(ApOrderDtlDTO::getInvoicePriceVariance).reduce(BigDecimal.ZERO, BigDecimal::add));
        return apOrderDTO;
    }

    private void handleApOrderDTO(ApOrderDTO apOrderDTO,Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(apOrderDTO.getProtocolCode())){
            ReceiptPaymentAgreementVO agreementVO = agreementMap.get(apOrderDTO.getProtocolCode());
            if (Objects.nonNull(agreementVO)){
                apOrderDTO.setProtocolName(agreementVO.getProtocolName());
            }
        }
    }

    private void handleApOrderDtlDTO(List<ApOrderDtlDTO> apOrderDtlDOS,Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (CollectionUtil.isNotEmpty(apOrderDtlDOS)){
            apOrderDtlDOS.forEach(apOrderDtlDTO -> {
                if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(apOrderDtlDTO.getProtocolCode())){
                    ReceiptPaymentAgreementVO agreementVO = agreementMap.get(apOrderDtlDTO.getProtocolCode());
                    if (Objects.nonNull(agreementVO)){
                        apOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                    }
                }
            });
        }

    }


    @Override
    public List<ApOrderDTO> queryByIds(List<Long> ids) {
        return apOrderRepoProc.queryByIds(ids);
    }

    @Override
    public List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam) {
        List<ApOrderDTO> res = apOrderRepoProc.getApOrderList(apOrderParam);
        return res;
    }

    @Override
    public List<ApOrderDTO> selectApOrderByParam(ApOrderParam apOrderParam){
        List<ApOrderDTO> res = apOrderRepoProc.selectApOrderByParam(apOrderParam);
        if (CollectionUtil.isEmpty(res)){
            return Collections.EMPTY_LIST;
        }
        return res;
    }

    @Override
    public Boolean queryByApTypeId(Long apTypeId) {
        return apOrderRepoProc.queryByApTypeId(apTypeId);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    @Retryable(value = {BusinessException.class}, maxAttempts = 5, backoff = @Backoff(value = 500))
    public void updateVerAmt(Long id, BigDecimal amt) {
        ApVerDTO apVerDTO = apOrderRepoProc.queryVerAmtById(id);
        if (Objects.isNull(apVerDTO)){
            throw new BusinessException("未查询到应付单信息");
        }
        BigDecimal totalAmt = Objects.isNull(apVerDTO.getTotalAmt()) ? BigDecimal.ZERO : apVerDTO.getTotalAmt();
        if (apVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前核销金额大于应付单金额，请刷新页面重新输入");
        }
        apVerDTO.setAmtAndVerState(amt);
        long rows = apOrderRepoProc.updateVerAmt(apVerDTO);
        if (rows == 0) {
            throw new BusinessException("应付单更新已核销金额失败");
        }
    }

    @Override
    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = apOrderFactory.page(apOrderPageParam);
        return res;
    }
    @Override
    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = apOrderFactory.writeoffPage(apOrderPageParam);
        return res;
    }

    @Override
    public ApOrderDTO get(Long id) {
        ApOrderDTO apOrderDTO = apOrderRepoProc.get(id);
        // 增加明细查询
        List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDTOS);
        return apOrderDTO;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = apOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void delByApOrderNoOrSourceNos(List<String> sourceNos,String sourceType) {

        List<ApOrderDO> arOrderDOList = new ArrayList<>();
        if (Objects.equals(FinConstant.AP_AR_DELETE_EXP,sourceType)){
            arOrderDOList = apOrderRepo.findAllByApOrderNoIn(sourceNos);
        }else if (Objects.equals(FinConstant.AP_AR_DELETE_OTHER,sourceType)){
            arOrderDOList = apOrderRepo.findAllBySourceNoIn(sourceNos);
        }

        List<Long> ids = arOrderDOList.stream().map(ApOrderDO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        //del(ids);
        //复制删除方法 避免应付应收互相调用
        List<ApOrderDTO> apOrderDTOList = apOrderRepoProc.queryByIds(ids);
        HashMap<String, List<String>> createSourceMap = new HashMap<>();
        apOrderDTOList.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("应付单非草稿状态不能删除");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List<String> sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList<>());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            //红冲原单处理
            if (Objects.nonNull(x.getRedSourceNo())) {
                apOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
            //去掉进项发票中的应付单号
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(x.getCreateMode())) {
                inputInvService.removeApOrderNo(x.getCreateMode(),x.getSourceNo());
            }

        });


        for (Entry<String, List<String>> entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AP_DOC_CLS", entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                //对账单
                case FIN_AP_DOC_CLS_PACCK:
                    rmiPurRpcService.batchUpdateDocStatus(PurAccountDTO.builder().docStatus(UdcEnum.PUR_ACCOUNT_CHECK_STATUS_CONFIRMED.getValueCode()).docNos(entry.getValue()).build());
                    break;
                default:

            }
        }

        List<Long> idList = apOrderDTOList.stream().map(ApOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expApOrderDtlSourceDocNos = null;
        List<Long> invIoIdList = null;
        if (CollectionUtils.isNotEmpty(idList)) {
            List<ApOrderDtlDO> apOrderDtlDOList = apOrderDtlRepo.findAllByMasIdIn(idList);
            expApOrderDtlSourceDocNos = apOrderDtlDOList.stream().map(ApOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            invIoIdList = apOrderDtlDOList.stream().map(ApOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        }

        Long res = apOrderRepoProc.del(ids);
        // 删除明细信息
        apOrderDtlRepoProc.delByMasId(ids);
        // 删除汇总信息
        apOrderDtlGroupRepoProc.delByMasId(ids);

        //删除时需要更新费用台账的生成财务单据状态为待生成
        //List<String> sourceNoList = apOrderDTOList.stream().map(ApOrderDTO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        //expLedgerRepoProc.updateFinFlagBySourceDocNos(sourceNoList,"0");


        if (Objects.equals(FinConstant.AP_AR_DELETE_EXP,sourceType) && CollectionUtil.isNotEmpty(expApOrderDtlSourceDocNos)){
            expLedgerRepoProc.updateFinFlagBySourceDocNos(expApOrderDtlSourceDocNos,"0");

        }

        //应付单删除时增加逻辑，更新库存流水的标记为0
        if (Objects.equals(FinConstant.AP_AR_DELETE_OTHER,sourceType) && CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }

    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {

        List<ApOrderDTO> apOrderDTOList = apOrderRepoProc.queryByIds(ids);
        HashMap<String, List<String>> createSourceMap = new HashMap<>();
        apOrderDTOList.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("应付单非草稿状态不能删除");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List<String> sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList<>());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            //红冲原单处理
            if (Objects.nonNull(x.getRedSourceNo())) {
                apOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
            //去掉进项发票中的应付单号
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(x.getCreateMode())) {
                inputInvService.removeApOrderNo(x.getCreateMode(),x.getSourceNo());
            }

        });



        for (Entry<String, List<String>> entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AP_DOC_CLS", entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                //对账单
                case FIN_AP_DOC_CLS_PACCK:
                    rmiPurRpcService.batchUpdateDocStatus(PurAccountDTO.builder().docStatus(UdcEnum.PUR_ACCOUNT_CHECK_STATUS_CONFIRMED.getValueCode()).docNos(entry.getValue()).build());
                    break;
                default:

            }
        }

        /**
         * 公司间应付单 判断来源单据类型=‘运费台账’ 删除时根据来源系统单号判断就行；
         * 公司间应付单的来源单据类型！=‘运费台账’ ，删除时就按之前删库存流水的那个逻辑
         *
         */
        //区分是否是费用台账还是其它(逻辑性库存流水或者其它)
        //费用台账应付单
        List<ApOrderDTO> expApOrderDTOList = apOrderDTOList.stream().filter(apOrderDTO -> Objects.equals(FinConstant.AP_TYPE_CODE_YFD02_SYS,apOrderDTO.getApTypeCode()) &&
                Objects.equals(apOrderDTO.getCreateMode(),"EXP")).collect(Collectors.toList());
        //其它应付单(逻辑性库存流水或者其它)
        List<ApOrderDTO> otherpApOrderDTOList = apOrderDTOList.stream().filter(apOrderDTO -> !(Objects.equals(FinConstant.AP_TYPE_CODE_YFD02_SYS,apOrderDTO.getApTypeCode()) &&
                Objects.equals(apOrderDTO.getCreateMode(),"EXP"))).collect(Collectors.toList());

        List<Long>  expApIdList = expApOrderDTOList.stream().map(ApOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expApOrderDtlSourceDocNos = null;
        if (CollectionUtils.isNotEmpty(expApIdList)) {
            List<ApOrderDtlDO> expApOrderDtlDOList = apOrderDtlRepo.findAllByMasIdIn(expApIdList);
            expApOrderDtlSourceDocNos = expApOrderDtlDOList.stream().map(ApOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }

        List<Long> otherpApIdList = otherpApOrderDTOList.stream().map(ApOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> invIoIdList = null;
        if (CollectionUtils.isNotEmpty(otherpApIdList)) {
            List<ApOrderDtlDO> otherpApOrderDtlDOList = apOrderDtlRepo.findAllByMasIdIn(otherpApIdList);
            invIoIdList = otherpApOrderDtlDOList.stream().map(ApOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }

        Long res = apOrderRepoProc.del(ids);
        // 删除明细信息
        apOrderDtlRepoProc.delByMasId(ids);
        // 删除汇总信息
        apOrderDtlGroupRepoProc.delByMasId(ids);


        /**
         * 逻辑性库存流水生成的应收应付单删除时，需要判断来源系统单号一致的应收单和应付单是否都是待审核状态，是的话，把来源系统单号一致的应收应付单全删掉。
         * 费用台州生成的应收应付单删除时，需要判断来源系统单号对应的应收单和应付单是否都是待审核状态，是的话，把来源系统单号对应的应收应付单全删掉。
         *
         */
        //删除关联的应收单
        //且应付单/应收单删除时需要把来源单号和应收单/应付单完全一致的【草稿】应收单/应付单也删除（提示一下），
        // 如果对应应收单/应付单不是草稿状态就不允许删除，提示出来。

        List<String> expApSourceNoList = expApOrderDTOList.stream().map(ApOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank(s)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expApSourceNoList)) {
            arOrderDomainService.delByArOrderNoOrSourceNos(expApSourceNoList,FinConstant.AP_AR_DELETE_EXP);
        }
        List<String> otherpApSourceNoList = otherpApOrderDTOList.stream().map(ApOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank(s)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(otherpApSourceNoList)) {
            arOrderDomainService.delByArOrderNoOrSourceNos(otherpApSourceNoList,FinConstant.AP_AR_DELETE_OTHER);
        }

        //删除时需要更新费用台账的生成财务单据状态为待生成
        if (CollectionUtil.isNotEmpty(expApOrderDtlSourceDocNos)){
            expLedgerRepoProc.updateFinFlagBySourceDocNos(expApOrderDtlSourceDocNos,"0");

        }

        //应付单删除时增加逻辑，更新库存流水的标记为0
        if (CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }


        return res;
    }

    @Override
    public void restDocState(List<Long> ids) {
        List<ApOrderDO> apOrderDOS = apOrderRepo.findAllById(ids);
        //检查
        checkCancelDoc(apOrderDOS);
        // 如果来源是采购对账单，回写采购对账单开票数量
        List<Long> relatePurAccIds = apOrderDOS.stream().filter(a -> UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(a.getCreateMode())).map(ApOrderDO::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(relatePurAccIds)) {
            List<ApOrderDtlDTO> apOrderDtlDTOList = apOrderDtlRepoProc.listByMasIds(relatePurAccIds);
            if (!CollectionUtils.isEmpty(apOrderDtlDTOList)) {
                List<PurAccountCheckQtyDTO> purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                    PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                    purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                    purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                    purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine()).negate());
                    return purAccountCheckQtyDTO;
                }).collect(Collectors.toList());
                purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
            }
        }


        //重置
        apOrderDOS.forEach(apOrderDO -> {
            apOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            apOrderDO.setProposedStatus(null);
            apOrderDO.setProcInstId(null);
            apOrderDO.setProcInstStatus(null);
        });
        apOrderRepo.saveAll(apOrderDOS);
    }

    /**
     * 取消单据检查
     * @param apOrderDOS
     */
    void checkCancelDoc(List<ApOrderDO> apOrderDOS) {
        if (CollectionUtils.isEmpty(apOrderDOS)){
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }
        List<Long> ids = apOrderDOS.stream().map(ApOrderDO::getId).collect(Collectors.toList());

        List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMasIds(ids);

        Map<Long, List<ApOrderDtlDTO>> listMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId));

        Map<Long, List<ApOrderToPayDTO>> apOrderPayMap = apOrderToPayDomainService.queryByApId(ids).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        apOrderDOS.forEach(apOrderDO -> {
            String perfix = "单号：" + apOrderDO.getApOrderNo() + "-";
            if (CollectionUtils.isNotEmpty(apOrderPayMap.get(apOrderDO.getId()))){
                throw new BusinessException(perfix + "已经生成付款单");
            }
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(apOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(apOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "拟定状态必须为草稿或拟定失败");
            }
//            if (!(BigDecimal.ZERO.compareTo(apOrderDO.getVerAmt()) == 0)) {
//                throw new BusinessException(perfix + "已核销金额必须为0");
//            }

            if(listMap.containsKey(apOrderDO.getId()) && CollUtil.isNotEmpty(listMap.get(apOrderDO.getId()))){
                // 根据明细，统计已核销金额大于0不能核销
                if(CollUtil.isNotEmpty(listMap.get(apOrderDO.getId()))){
                    BigDecimal verAmt = listMap.get(apOrderDO.getId()).stream().map(ApOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (!(BigDecimal.ZERO.compareTo(verAmt)==0)){
                        throw new BusinessException( perfix + "已核销金额必须为0");
                    }
                }
            }

            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "单据状态必须为审核通过");
            }
            if (Boolean.TRUE.equals(apOrderDO.getRedState())){
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据已红冲");
            }
        });
    }



    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApOrder redPunchCreate(Long id) {
        ApOrderDO apOrderDO = apOrderRepo.findById(id).get();
        apOrderDO.setRedState(Boolean.TRUE);
        apOrderRepo.save(apOrderDO);
        ApOrder newApOrder = BeanUtils.toBean(apOrderDO, ApOrder.class);

        newApOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newApOrder.setProcInstId(null);
        newApOrder.setProcInstStatus(null);
        newApOrder.setRedState(null);
        newApOrder.setRedSourceNo(apOrderDO.getApOrderNo());
        newApOrder.setRedSourceId(apOrderDO.getId());
        newApOrder.setTaxAmt(apOrderDO.getTaxAmt().negate());
        newApOrder.setTotalAmt(apOrderDO.getTotalAmt().negate());
        newApOrder.setExclTaxAmt(apOrderDO.getExclTaxAmt().negate());
        newApOrder.setTotalCurAmt(apOrderDO.getTotalCurAmt().negate());
        newApOrder.setTaxCurAmt(apOrderDO.getTaxCurAmt().negate());
        newApOrder.setExclTaxCurAmt(apOrderDO.getExclTaxCurAmt().negate());
        newApOrder.setId(null);
        newApOrder.setApOrderNo(null);
        newApOrder.setProposedStatus(null);
        newApOrder.setAuditUser(null);
        newApOrder.setApprovedTime(null);
        newApOrder.setAuditUserId(null);
        newApOrder.setRemark(null);

        List<ApOrderDtlDO> dtls = apOrderDtlRepo.findAllByMasId(id);
        List<ApOrderDtl> newDtls = dtls.stream().map(dtl -> {
            ApOrderDtl dtlDO = BeanUtils.toBean(dtl, ApOrderDtl.class);

            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlList(newDtls);
        List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = apOrderDtlGroupRepo.findAllByMasId(id);
        List<ApOrderDtlGroup> groupList = apOrderDtlGroupDOS.stream().map(dtl -> {
            ApOrderDtlGroup dtlDO = BeanUtils.toBean(dtl, ApOrderDtlGroup.class);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlGroupList(groupList);

        return newApOrder;
    }



}
