package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDtlDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.repo.expense.ExpLedgerRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.order.param.SalDoRespDTO;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.arorder
 * @date 2022/4/12 16:18
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ArOrderDomainServiceImpl implements ArOrderDomainService {

    private final ArOrderRepo arOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlRepo arOrderDtlRepo;
    private final ArOrderFactory arOrderFactory;
    private final SaleInvRepo saleInvRepo;

    //发号器生成付款单号
    private final SeqNumProvider sysNumberRuleService;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrderRpcService rmiOrderRpcService;

    private final ExpLedgerRepoProc expLedgerRepoProc;

    private ApOrderDomainService apOrderDomainService;
    @Autowired
    @Lazy
    public void setApOrderDomainService(ApOrderDomainService apOrderDomainService) {
        this.apOrderDomainService = apOrderDomainService;
    }
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final InvStkProvider invStkProvider;


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long save(ArOrder arOrder) {

        if (Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(arOrder.getProtocolCode())){
            handlePurSuppProtocolCode(arOrder);
            handleOtherAssemble(arOrder);
        }
        //非手工
        if (!Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(arOrder);
            handleOtherAssemble(arOrder);
        }

        //明细赋值
        arOrder.dtlAssign();
        if (arOrder.getVerAmt() == null) {
            //默认核销状态
            arOrder.setDef();
        }
        // 单头信息输入的校验
        arOrder.check();
        // 校验明细行
        arOrder.checkDtlList();
        // 来源为销售订单
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        if (arOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            arOrder.setSoDef();
            arOrder.countBySo();
        }
        // 数据的新增
        ArOrderDO apOrderRes = saveOrUpdate(arOrder);
        return apOrderRes.getId();
    }


    /**
     * 处理手工时收款协议为空取主客户的
     *
     * @return
     */
    private void handlePurSuppProtocolCode(ArOrder arOrder){
        if (StringUtils.isBlank(arOrder.getProtocolCode())){
            //如果是手动新增应收单，主表上就默认取主客户维护的收款协议
            Map<String, CustBaseDTO> custMap = rmiSaleRpcService.findBaseCustMapByCodes(Collections.singletonList(arOrder.getCustCode()));
            if (MapUtil.isNotEmpty(custMap) && custMap.containsKey(arOrder.getCustCode())){
                CustBaseDTO crmCustBaseDTO = custMap.get(arOrder.getCustCode());
                if (Objects.nonNull(crmCustBaseDTO)){
                    if (StringUtils.isBlank(crmCustBaseDTO.getPaymentTerm())){
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应收单的来源单号("+arOrder.getSourceNo()+")的收款协议为空");
                    }else {
                        arOrder.setProtocolCode(crmCustBaseDTO.getPaymentTerm());
                    }

                }else {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "手工时收款协议为空时客户不存在");
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "手工时收款协议为空时客户不存在");
            }
        }

    }

    /**
     * 处理非手工时收款协议为空取对应来源单据的
     *
     * @return
     */
    private void handleOtherProtocolCode(ArOrder arOrder){
        List<String> docNos = arOrder.getDtlList().stream().map(ArOrderDtl::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        //正新没有订单域
        //Map<String, SalDoRespDTO> salDoRespDTOMap = rmiOrderRpcService.findSalDoMapByCodes(docNos);

        arOrder.getDtlList().forEach(arOrderDtl -> {
            if (StringUtils.isBlank(arOrderDtl.getProtocolCode())){
                Map<String, SalDoRespDTO> salDoRespDTOMap = rmiOrderRpcService.findSalDoMapByCodes(Collections.singletonList(arOrderDtl.getSourceNo()));
                if (MapUtil.isNotEmpty(salDoRespDTOMap) && salDoRespDTOMap.containsKey(arOrderDtl.getSourceNo())){
                    SalDoRespDTO salDoRespDTO = salDoRespDTOMap.get(arOrderDtl.getSourceNo());
                    if (Objects.nonNull(salDoRespDTO)){
                        if (StringUtils.isBlank(salDoRespDTO.getPaymentTerm())){
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应收单明细的来源单号("+arOrderDtl.getSourceNo()+")的收款协议为空");
                        }else {
                            arOrderDtl.setProtocolCode(salDoRespDTO.getPaymentTerm());
                        }

                    }else {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "收款协议为空时来源单据不存在");
                    }
                }else {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "收款协议为空时来源单据不存在");
                }
            }

        });

    }

    private void handleOtherAssemble(ArOrder arOrder){
        if (StringUtils.isBlank(arOrder.getInOutCust()) || StringUtils.isBlank(arOrder.getRelevanceOuCode())) {

            Map<String, CustBaseDTO> custMap = rmiSaleRpcService.findBaseCustMapByCodes(Collections.singletonList(arOrder.getCustCode()));

            //客户的内外部类型
            if (MapUtil.isNotEmpty(custMap) && custMap.containsKey(arOrder.getCustCode())){
                CustBaseDTO crmCustBaseDTO = custMap.get(arOrder.getCustCode());
                if (Objects.nonNull(crmCustBaseDTO)){
                    if (StringUtils.isBlank(arOrder.getInOutCust())) {
                        if (StringUtils.isNotBlank(crmCustBaseDTO.getInOutCust())) {
                            arOrder.setInOutCust(crmCustBaseDTO.getInOutCust());
                        }
                    }
                    //系统内客户对应的团内公司，系统外客户空着
                    /*if (Objects.equals(crmCustBaseDTO.getInOutCust(),"IN") && StringUtils.isBlank(arOrder.getRelevanceOuCode())){
                        arOrder.setRelevanceOuCode(crmCustBaseDTO.getCorBusinCode());
                    }*/
                    if (Objects.equals(crmCustBaseDTO.getCustType2(),"C") && StringUtils.isBlank(arOrder.getRelevanceOuCode())){
                        arOrder.setRelevanceOuCode(crmCustBaseDTO.getCorBusinCode());
                    }
                }
            }
        }

    }

    /**
     * 对 应收单主表/明细表/汇总明细表
     * 进行数据库新增
     *
     * @param arOrder
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    public ArOrderDO saveOrUpdate(ArOrder arOrder) {
        if (CharSequenceUtil.isBlank(arOrder.getArOrderNo())) {
            // 发号器-生成应付单号
            String apOrderNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.YSD, null);
            arOrder.setArOrderNo(apOrderNo);
        }
        //弹性域-值传递处理begin
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.AR_ORDER,arOrder);
        //弹性域-值传递处理end
        ArOrderDO apOrderDO = ArOrderConvert.INSTANCE.convert(arOrder);
        //新增时锁版本默认值0
        if (apOrderDO.getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ArOrderDO apOrderRes = arOrderRepo.save(apOrderDO);
        // 应收单明细单的新增
        // 根据应收单id删除明细行
        arOrderDtlRepoProc.delByMasId(Lists.newArrayList(apOrderRes.getId()));
        List<ArOrderDtl> apOrderDtlList = arOrder.getDtlList();
        List<ArOrderDtlDO> apOrderDtlDOS = ArOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        //处理收付款协议
        //计算收款协议（必填）、起算日期、到期付款日字段。
        //List<String> protocolCodeList = apOrderDtlDOS.stream().filter(v->StringUtils.isNotBlank(v.getEs19())).map(v -> v.getEs19()).collect(Collectors.toList());
        List<String> protocolCodeList = apOrderDtlDOS.stream().filter(v->StringUtils.isNotBlank(v.getProtocolCode())).map(v -> v.getProtocolCode()).collect(Collectors.toList());

        //1、查询当前收款协议配置，参数协议代码
        List<ReceiptPaymentAgreementVO> receiptPaymentAgreementVOS = null;
        if(CollectionUtils.isNotEmpty(protocolCodeList)){
            receiptPaymentAgreementVOS=receiptPaymentAgreementDomainService.selectReceiptByCodes(protocolCodeList);
        }
        Map<String, Long> protocolCodeIdMap=new HashMap<>();
        Map<Long, List<ReceiptPaymentAgreementDtlVO>> protocolDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(receiptPaymentAgreementVOS)){
            protocolCodeIdMap = receiptPaymentAgreementVOS.stream().collect(Collectors.toMap(v -> v.getProtocolCode(), v -> v.getId()));
            ReceiptPaymentAgreementDtlPageParam queryVO = new ReceiptPaymentAgreementDtlPageParam();
            queryVO.setMasIdList(receiptPaymentAgreementVOS.stream().map(v->v.getId()).collect(Collectors.toList()));
            List<ReceiptPaymentAgreementDtlVO> receiptPaymentAgreementDtlVOS = receiptPaymentAgreementDtlDomainService.selectByParam(queryVO);
            protocolDetailMap = receiptPaymentAgreementDtlVOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        }
        for (ArOrderDtlDO x : apOrderDtlDOS) {
            x.setMasId(apOrderRes.getId());
            if(x.getId()==null){
                x.setAuditDataVersion(0);
            }
            x.setVerAmt(BigDecimal.ZERO);
            x.setUnVerAmt(x.getTotalAmt());
            x.setApplyVerAmTing(BigDecimal.ZERO);
            ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO=null;
            if(protocolCodeIdMap.containsKey(x.getProtocolCode())){
                if(protocolDetailMap.containsKey(protocolCodeIdMap.get(x.getProtocolCode()))){
                    //receiptPaymentAgreementDtlVO = protocolDetailMap.get(protocolCodeIdMap.get(protocolCodeIdMap.get(x.getEs19()))).get(0);
                    List<ReceiptPaymentAgreementDtlVO> receiptPaymentAgreementDtlVOList = protocolDetailMap.get(protocolCodeIdMap.get(x.getProtocolCode()));
                    if (CollectionUtil.isNotEmpty(receiptPaymentAgreementDtlVOList)){
                        receiptPaymentAgreementDtlVO = receiptPaymentAgreementDtlVOList.get(0);
                    }
                }
            }
            //设置起算日期
            x.setEs23(calculateStartCalDate(arOrder.getCreateMode(),arOrder.getBuDate(),receiptPaymentAgreementDtlVO));
            //设置到期付款日期
            if(Objects.nonNull(x.getEs23())){
                x.setEs24(calculateExpirePayDate(x.getEs23().toLocalDate(), receiptPaymentAgreementDtlVO));
            }
            arOrderDtlRepo.save(x);
        }
        return apOrderRes;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = {Exception.class})
    //@Transactional(rollbackFor = {Exception.class})
    public Long commit(ArOrder arOrder, Boolean auto) {

        if (Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(arOrder.getProtocolCode())){
            handlePurSuppProtocolCode(arOrder);
            handleOtherAssemble(arOrder);
        }
        //非手工
        if (!Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(arOrder);
            handleOtherAssemble(arOrder);

        }
        //明细赋值
        arOrder.dtlAssign();
        // 校验单头与明细
        arOrder.check();
        arOrder.checkDtlList();
        //手工才校验
        if (Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            // 校验明细金额
            arOrder.checkAmt();
            // 金额数据校验(单头，明细，汇总)金额的校验
            arOrder.checkAmtSum();
        }
        // 进行数据的新增或保存
        if (arOrder.getVerAmt() == null) {
            //默认核销状态
            arOrder.setDef();
        }
        //是否自动审核
        if (auto) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long newCommit(ArOrder arOrder, Boolean auto) {
        if (Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) &&
                StringUtils.isBlank(arOrder.getProtocolCode())){
            handlePurSuppProtocolCode(arOrder);
            handleOtherAssemble(arOrder);
        }
        //非手工
        if (!Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())){
            handleOtherProtocolCode(arOrder);
            handleOtherAssemble(arOrder);

        }
        //明细赋值
        arOrder.dtlAssign();
        // 校验单头与明细
        arOrder.check();
        arOrder.checkDtlList();
        //手工才校验
        if (Objects.equals(arOrder.getCreateMode(),UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            // 校验明细金额
            arOrder.checkAmt();
            // 金额数据校验(单头，明细，汇总)金额的校验
            arOrder.checkAmtSum();
        }
        // 进行数据的新增或保存
        if (arOrder.getVerAmt() == null) {
            //默认核销状态
            arOrder.setDef();
        }
        //是否自动审核
        if (auto) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }



    @Override
    public ArOrderDTO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderDTO = get(id);

        Map<String, OrgOuRpcSimpleDTO> ouMap = StringUtils.isBlank(arOrderDTO.getRelevanceOuCode()) ? new HashMap<>() : rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(arOrderDTO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(arOrderDTO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)){
            arOrderDTO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }

        // 新增明细列表
        List<ArOrderDtlDTO> arOrderDtlDTOList = arOrderDtlRepoProc.listByMisId(id);


        List<String> protocolCodeList = StringUtils.isBlank(arOrderDTO.getProtocolCode()) ? new ArrayList<>() : Collections.singletonList(arOrderDTO.getProtocolCode());
        List<String> dtlProtocolCodeList = arOrderDtlDTOList.stream().map(ArOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> protocolCodeAllList = Stream.of(dtlProtocolCodeList, protocolCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = receiptPaymentAgreementDomainService.selectReceiptAgreementByCodes(protocolCodeAllList);
        handleArOrderDTO(arOrderDTO,agreementMap);
        handleArOrderDtlDTO(arOrderDtlDTOList,agreementMap);

        // 新增汇总列表
        arOrderDTO.setArOrderDtlDTOList(arOrderDtlDTOList);
        return arOrderDTO;
    }

    private void handleArOrderDTO(ArOrderDTO arOrderDTO, Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(arOrderDTO.getProtocolCode())){
            ReceiptPaymentAgreementVO agreementVO = agreementMap.get(arOrderDTO.getProtocolCode());
            if (Objects.nonNull(agreementVO)){
                arOrderDTO.setProtocolName(agreementVO.getProtocolName());
            }
        }
    }

    private void handleArOrderDtlDTO(List<ArOrderDtlDTO> arOrderDtlDTOS,Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (CollectionUtil.isNotEmpty(arOrderDtlDTOS)){
            arOrderDtlDTOS.forEach(arOrderDtlDTO -> {
                if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(arOrderDtlDTO.getProtocolCode())){
                    ReceiptPaymentAgreementVO agreementVO = agreementMap.get(arOrderDtlDTO.getProtocolCode());
                    if (Objects.nonNull(agreementVO)){
                        arOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                    }
                }
            });
        }

    }

    @Override
    public Boolean queryByArTypeId(Long arTypeId) {
        return arOrderRepoProc.queryByArTypeId(arTypeId);
    }

    @Override
    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        List<ArOrderDTO> res = arOrderRepoProc.getArOrderList(arOrderParam);
        return res;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = arOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前核销金额大于应收单金额，请刷新页面重新输入");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = arOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0) {
            throw new BusinessException("应付单更新已核销金额失败");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        arOrderRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSourceNo(String sourceNo, Long id) {
        arOrderRepoProc.updateSourceNo(sourceNo, id);
    }

    @Override
    public PagingVO<ArExportEntity> exportDefault(ArOrderPageParam param) {
        return arOrderRepoProc.exportDefault(param);
    }


    @Override
    public void restDocState(List<Long> ids) {
        List<ArOrderDO> arOrderDOs = arOrderRepo.findAllById(ids);
        //检查
        checkCancelDoc(arOrderDOs);
        //重置
        arOrderDOs.forEach(arOrderDO -> {
            arOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            arOrderDO.setProposedStatus(null);
            arOrderDO.setProcInstId(null);
            arOrderDO.setProcInstStatus(null);
        });
        arOrderRepo.saveAll(arOrderDOs);
    }

    /**
     * 取消单据检查
     * @param arOrderDOs
     */
    void checkCancelDoc(List<ArOrderDO> arOrderDOs) {
        if (CollectionUtils.isEmpty(arOrderDOs)){
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }

        List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMasIds(arOrderDOs.stream().map(ArOrderDO::getId).collect(Collectors.toList()));

        Map<Long, List<ArOrderDtlDTO>> listMap = arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId));

        arOrderDOs.forEach(arOrderDO -> {
            String perfix = "单号：" + arOrderDO.getArOrderNo() + "-";

            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(arOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(arOrderDO.getProposedStatus())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "拟定状态必须为草稿或拟定失败");
            }
//            if (!(BigDecimal.ZERO.compareTo(arOrderDO.getVerAmt()) == 0)) {
//                throw new com.elitescloud.boot.exception.BusinessException(perfix + "已核销金额必须为0");
//            }
            if(listMap.containsKey(arOrderDO.getId()) && CollUtil.isNotEmpty(listMap.get(arOrderDO.getId()))){
                // 根据明细，统计已核销金额大于0不能核销
                if(CollUtil.isNotEmpty(listMap.get(arOrderDO.getId()))){
                    BigDecimal verAmt = listMap.get(arOrderDO.getId()).stream().map(ArOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (!(BigDecimal.ZERO.compareTo(verAmt)==0)){
                        throw new com.elitescloud.boot.exception.BusinessException( perfix + "已核销金额必须为0");
                    }
                }
            }

            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(arOrderDO.getOrderState())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据状态必须为审核通过");
            }
            if (Boolean.TRUE.equals(arOrderDO.getRedState())){
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据已红冲");
            }
        });

    }
    @Override
    public ArOrderSaveParam redPunchCreate(Long id) {
        ArOrderDO arOrderDO = arOrderRepo.findById(id).get();
        arOrderDO.setRedState(Boolean.TRUE);
        arOrderRepo.save(arOrderDO);
        ArOrderDO newArOrder = new ArOrderDO();
        BeanUtils.copyProperties(arOrderDO, newArOrder);

        newArOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newArOrder.setProcInstId(null);
        newArOrder.setProcInstStatus(null);
        newArOrder.setRedState(null);
        newArOrder.setRedSourceNo(arOrderDO.getArOrderNo());
        newArOrder.setRedSourceId(arOrderDO.getId());
        newArOrder.setTaxAmt(arOrderDO.getTaxAmt().negate());
        newArOrder.setTotalAmt(arOrderDO.getTotalAmt().negate());
        newArOrder.setExclTaxAmt(arOrderDO.getExclTaxAmt().negate());
        newArOrder.setTotalCurAmt(arOrderDO.getTotalCurAmt().negate());
        newArOrder.setTaxCurAmt(arOrderDO.getTaxCurAmt().negate());
        newArOrder.setExclTaxCurAmt(arOrderDO.getExclTaxCurAmt().negate());
        newArOrder.setId(null);
        newArOrder.setArOrderNo(null);
        newArOrder.setProposedStatus(null);
        newArOrder.setAuditUser(null);
        newArOrder.setApprovedTime(null);
        newArOrder.setAuditUserId(null);
        newArOrder.setRemark(null);

        List<ArOrderDtlDO> dtls = arOrderDtlRepo.findAllByMasId(id);
        List<ArOrderDtlDO> newDtls = dtls.stream().map(dtl -> {
            ArOrderDtlDO dtlDO = new ArOrderDtlDO();
            BeanUtils.copyProperties(dtl, dtlDO);

            dtlDO.setId(null);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            dtlDO.setExclTaxPrice(dtl.getExclTaxPrice());
            return dtlDO;
        }).collect(Collectors.toList());
        ArOrderSaveParam saveParam = ArOrderConvert.INSTANCE.convertParam(newArOrder);
        saveParam.setArOrderDtlParamList(ArOrderDtlConvert.INSTANCE.convertList(newDtls));
        return saveParam;
    }

    @Override
    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = arOrderFactory.page(arOrderPageParam);
        return res;
    }
    @Override
    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = arOrderFactory.writeoffPage(arOrderPageParam);
        return res;
    }
    @Override
    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(id);
        // 增加明细查询
        List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMisId(id);
        arOrderDTO.setArOrderDtlDTOList(arOrderDtlDTOS);
        return arOrderDTO;
    }


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = arOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void delByArOrderNoOrSourceNos(List<String> sourceNos,String sourceType) {
        List<ArOrderDO> arOrderDOList = new ArrayList<>();
        if (Objects.equals(FinConstant.AP_AR_DELETE_EXP,sourceType)){
            arOrderDOList = arOrderRepo.findAllByArOrderNoIn(sourceNos);

        }else if (Objects.equals(FinConstant.AP_AR_DELETE_OTHER,sourceType)){
            arOrderDOList = arOrderRepo.findAllBySourceNoIn(sourceNos);
        }


        List<Long> ids = arOrderDOList.stream().map(ArOrderDO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        //del(ids);

        //复制删除方法 避免应付应收互相调用
        // 非草稿状态不能删除
        List<ArOrderDTO> arOrderDTOS = arOrderRepoProc.queryByIds(ids);
        HashMap<String, List<String>> createSourceMap = new HashMap<>();
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("应收单非草稿状态不能删除");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List<String> sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList<>());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            //红冲原单处理
            if (Objects.nonNull(x.getRedSourceNo())) {
                arOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });

        for (Entry<String, List<String>> entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AR_DOC_CLS", entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                //销售发票
                case FIN_AR_DOC_CLS_SINV:
                    List<SaleInvDO> saleInvDOS = saleInvRepo.findByApplyNoIn(entry.getValue());
                    saleInvDOS.forEach(saleInvDO -> saleInvDO.setArFlag(Boolean.FALSE));
                    saleInvRepo.saveAll(saleInvDOS);
                    break;
                default:

            }
        }

        List<Long> idList = arOrderDTOS.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expArOrderDtlSourceDocNos = null;
        List<Long> invIoIdList = null;
        if (CollectionUtils.isNotEmpty(idList)) {
            List<ArOrderDtlDO> arOrderDtlDOList = arOrderDtlRepo.findAllByMasIdIn(idList);
            expArOrderDtlSourceDocNos = arOrderDtlDOList.stream().map(ArOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            invIoIdList = arOrderDtlDOList.stream().map(ArOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        }



        Long res = arOrderRepoProc.del(ids);
        // 删除明细信息
        arOrderDtlRepoProc.delByMasId(ids);

        //删除时需要更新费用台账的生成财务单据状态为待生成
        //List<String> sourceNoList = arOrderDTOS.stream().map(ArOrderDTO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
       // expLedgerRepoProc.updateFinFlagBySourceDocNos(sourceNoList,"0");
        if (Objects.equals(FinConstant.AP_AR_DELETE_EXP,sourceType) && CollectionUtil.isNotEmpty(expArOrderDtlSourceDocNos)){
            expLedgerRepoProc.updateFinFlagBySourceDocNos(expArOrderDtlSourceDocNos,"0");
        }
        //应付单删除时增加逻辑，更新库存流水的标记为0
        if (Objects.equals(FinConstant.AP_AR_DELETE_OTHER,sourceType) && CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }

    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {
        // 非草稿状态不能删除
        List<ArOrderDTO> arOrderDTOS = arOrderRepoProc.queryByIds(ids);
        HashMap<String, List<String>> createSourceMap = new HashMap<>();
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("应收单非草稿状态不能删除");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List<String> sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList<>());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            //红冲原单处理
            if (Objects.nonNull(x.getRedSourceNo())) {
                arOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });


        for (Entry<String, List<String>> entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AR_DOC_CLS", entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                //销售发票
                case FIN_AR_DOC_CLS_SINV:
                    List<SaleInvDO> saleInvDOS = saleInvRepo.findByApplyNoIn(entry.getValue());
                    saleInvDOS.forEach(saleInvDO -> saleInvDO.setArFlag(Boolean.FALSE));
                    saleInvRepo.saveAll(saleInvDOS);
                    break;
                default:

            }
        }



        /**
         * 公司间应收单 判断来源单据类型=‘运费台账’ 删除时根据来源系统单号判断就行；
         * 公司间应收单的来源单据类型！=‘运费台账’ ，删除时就按之前删库存流水的那个逻辑
         *
         */
        //区分是否是费用台账还是其它(逻辑性库存流水或者其它)
        //费用台账应收单
        List<ArOrderDTO> expArOrderDTOList = arOrderDTOS.stream().filter(arOrderDTO -> Objects.equals(FinConstant.AR_TYPE_CODE_YSD02_SYS,arOrderDTO.getArTypeCode()) &&
                Objects.equals(arOrderDTO.getCreateMode(),"EXP")).collect(Collectors.toList());
        //其它应收单(逻辑性库存流水或者其它)
        List<ArOrderDTO> otherpArOrderDTOList = arOrderDTOS.stream().filter(arOrderDTO -> !(Objects.equals(FinConstant.AR_TYPE_CODE_YSD02_SYS,arOrderDTO.getArTypeCode()) &&
                Objects.equals(arOrderDTO.getCreateMode(),"EXP"))).collect(Collectors.toList());

        List<Long>  expArIdList = expArOrderDTOList.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expArOrderDtlSourceDocNos = null;
        if (CollectionUtils.isNotEmpty(expArIdList)) {
            List<ArOrderDtlDO> expArOrderDtlDOList = arOrderDtlRepo.findAllByMasIdIn(expArIdList);
            expArOrderDtlSourceDocNos = expArOrderDtlDOList.stream().map(ArOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }

        List<Long> otherpArIdList = otherpArOrderDTOList.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> invIoIdList = null;
        if (CollectionUtils.isNotEmpty(otherpArIdList)) {
            List<ArOrderDtlDO> otherpArOrderDtlDOList = arOrderDtlRepo.findAllByMasIdIn(otherpArIdList);
            invIoIdList = otherpArOrderDtlDOList.stream().map(ArOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }


       /* List<Long> idList = arOrderDTOS.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> arOrderDtlSourceDocNos = null;
        if (CollectionUtils.isNotEmpty(idList)) {
            List<ArOrderDtlDO> arOrderDtlDOList = arOrderDtlRepo.findAllByMasIdIn(idList);
            arOrderDtlSourceDocNos = arOrderDtlDOList.stream().map(ArOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        }*/

        Long res = arOrderRepoProc.del(ids);
        // 删除明细信息
        arOrderDtlRepoProc.delByMasId(ids);

        /**
         * 逻辑性库存流水生成的应收应付单删除时，需要判断来源系统单号一致的应收单和应付单是否都是待审核状态，是的话，把来源系统单号一致的应收应付单全删掉。
         * 费用台州生成的应收应付单删除时，需要判断来源系统单号对应的应收单和应付单是否都是待审核状态，是的话，把来源系统单号对应的应收应付单全删掉。
         *
         */
        //删除关联的应付单
        //且应付单/应收单删除时需要把来源单号和应收单/应付单完全一致的【草稿】应收单/应付单也删除（提示一下），
        // 如果对应应收单/应付单不是草稿状态就不允许删除，提示出来。

        List<String> expArSourceNoList = expArOrderDTOList.stream().map(ArOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank(s)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expArSourceNoList)) {
            apOrderDomainService.delByApOrderNoOrSourceNos(expArSourceNoList,FinConstant.AP_AR_DELETE_EXP);
        }
        List<String> otherpArSourceNoList = otherpArOrderDTOList.stream().map(ArOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank(s)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(otherpArSourceNoList)) {
            apOrderDomainService.delByApOrderNoOrSourceNos(otherpArSourceNoList,FinConstant.AP_AR_DELETE_OTHER);
        }


       /* List<String> sourceNoList = arOrderDTOS.stream().map(ArOrderDTO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sourceNoList)) {
            apOrderDomainService.delByApOrderNos(sourceNoList);
        }*/

        //删除时需要更新费用台账的生成财务单据状态为待生成
        //expLedgerRepoProc.updateFinFlagBySourceDocNos(sourceNoList,"0");

        if (CollectionUtil.isNotEmpty(expArOrderDtlSourceDocNos)){
            expLedgerRepoProc.updateFinFlagBySourceDocNos(expArOrderDtlSourceDocNos,"0");

        }

        //应收单删除时增加逻辑，更新库存流水的标记为0
        if (CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }

        return res;
    }
    /**
     * 计算起算日期
     * @return
     */
    public LocalDateTime calculateStartCalDate(String createMode,LocalDateTime buDate,ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO){
        log.info("计算应收单付款起算日期,收款协议明细参数：{}", JSON.toJSONString(receiptPaymentAgreementDtlVO));
        if(StringUtils.isBlank(createMode)){
            log.error("计算应收单付款起算日期，单据来源为空");
            throw new BusinessException("计算应收单付款起算日期，单据来源为空");
        }
        LocalDate startCalDate=null;
        //手工
        if(createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())){
            startCalDate= LocalDate.now();
            //销售订单
        }else if(createMode.equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())){
            if(null!=receiptPaymentAgreementDtlVO){
                startCalDate=LocalDate.from(buDate);
            }
            //库存流水
        }else if(createMode.equals(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode())){
            if(null!=receiptPaymentAgreementDtlVO){
                startCalDate=LocalDate.from(buDate);
            }
        }
        if(startCalDate==null){
            return null;
        }
        LocalDateTime now=LocalDateTime.now();
        return  now.withYear(startCalDate.getYear()).withMonth(startCalDate.getMonthValue()).withDayOfMonth(startCalDate.getDayOfMonth())
                .withHour(12).withMinute(0).withSecond(0);
    }
    public LocalDateTime calculateExpirePayDate(LocalDate startCalDate,ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO){
        log.info("计算应收单到期付款日期,收款协议明细参数：{}", JSON.toJSONString(receiptPaymentAgreementDtlVO));
        LocalDate expirePayDate=null;
        if(null!=startCalDate&&null!=receiptPaymentAgreementDtlVO&&StringUtils.isNotBlank(receiptPaymentAgreementDtlVO.getPeriodType())){
            expirePayDate = LocalDate.of(startCalDate.getYear(), startCalDate.getMonth(), startCalDate.getDayOfMonth());
            //固定
            if(UdcEnum.AGREEMENT_PERIOD_TYPE_IMMOBILIZATION.getValueCode().equals(receiptPaymentAgreementDtlVO.getPeriodType())){
                int effectiveAdditionalMonth = receiptPaymentAgreementDtlVO.getEffectiveAdditionalMonth()==null?0:receiptPaymentAgreementDtlVO.getEffectiveAdditionalMonth();
                expirePayDate=expirePayDate.plusMonths(effectiveAdditionalMonth);
                if(receiptPaymentAgreementDtlVO.getEffectiveDate()!=null){
                    if(receiptPaymentAgreementDtlVO.getEffectiveDate()<expirePayDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()){
                        expirePayDate=expirePayDate.withDayOfMonth(receiptPaymentAgreementDtlVO.getEffectiveDate());
                    }else{
                        expirePayDate=expirePayDate.withDayOfMonth(expirePayDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth());
                    }
                }
            //常规
            }else if(UdcEnum.AGREEMENT_PERIOD_TYPE_ROUTINE.getValueCode().equals(receiptPaymentAgreementDtlVO.getPeriodType())){
                if(receiptPaymentAgreementDtlVO.getValidityDateDelayDays()!=null){
                    int validityDateDelayDays = receiptPaymentAgreementDtlVO.getValidityDateDelayDays();
                    expirePayDate=expirePayDate.plusDays(validityDateDelayDays);
                }
                if(receiptPaymentAgreementDtlVO.getPeriodDays()!=null){
                    int periodDays = receiptPaymentAgreementDtlVO.getPeriodDays();
                    expirePayDate=expirePayDate.plusDays(periodDays);
                }
            }
        }
        if(expirePayDate==null){
            return null;
        }
        LocalDateTime now=LocalDateTime.now();
        return  now.withYear(expirePayDate.getYear()).withMonth(expirePayDate.getMonthValue()).withDayOfMonth(expirePayDate.getDayOfMonth())
                .withHour(12).withMinute(0).withSecond(0);
    }

    @Override
    public long countOverduePeriodPay(String custCode, String ouCode) {
        return arOrderRepoProc.countOverduePeriodPay(custCode,ouCode);
    }

}
