package com.elitesland.fin.infr.factory.saleinv;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvSumDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.factory.saleinv
 * @date 2022/5/11 10:14
 */
@RequiredArgsConstructor
@Component
public class SaleInvFactory {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;
    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;

    /*public Boolean filterDetails(SaleInvPageParam saleInvPageParam) {

        List<Predicate> ddtlPredicates = new ArrayList<>();
        List<Predicate> dtlPredicates = new ArrayList<>();

        List<Long> ids = new ArrayList<>();

        // 已开发票明细
        buildDDtlPredicates(saleInvPageParam, ddtlPredicates);
        if (CollectionUtils.isNotEmpty(ddtlPredicates)) {
            List<Long> masIds = jpaQueryFactory.selectDistinct(qSaleInvdDtlDO.masId)
                    .from(qSaleInvdDtlDO)
                    .where(ExpressionUtils.allOf(ddtlPredicates)).fetch();

            if (CollectionUtils.isEmpty(masIds)) {
                return Boolean.TRUE;
            }
            ids.addAll(masIds);
        }

        // 发票明细
        buildDtlPredicates(saleInvPageParam, dtlPredicates);
        if (CollectionUtils.isNotEmpty(dtlPredicates)) {
            List<Long> masIds = jpaQueryFactory.selectDistinct(qSaleInvDtlDO.masId)
                    .from(qSaleInvDtlDO)
                    .where(ExpressionUtils.allOf(dtlPredicates)).fetch();
            if (CollectionUtils.isEmpty(masIds)) {
                return Boolean.TRUE;
            }
            ids.addAll(masIds);
        }

        List<Long> masIds = ids.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        saleInvPageParam.setIds(masIds);

        return Boolean.FALSE;
    }*/

   /* private void buildDtlPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {
        // 销售发票明细
        //  来源单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getSourceNo())) {
            predicates.add(qSaleInvDtlDO.sourceNo.like("%" + saleInvPageParam.getSourceNo() + "%"));
        }

    }*/

    // 已开发票明细
    /*private void buildDDtlPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {

        // 发票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getInvNo())) {
            predicates.add(qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        // 原蓝票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getBlueInvNo())) {
            predicates.add(qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        // 开票日期/
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(qSaleInvdDtlDO.invDate.between(saleInvPageParam.getInvDateStart(), saleInvPageParam.getInvDateEnd()));
        }

        // 红冲状态
//        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRedState())) {
//            predicates.add(qSaleInvdDtlDO.redState.eq(saleInvPageParam.getRedState()));
//        }
//        // 开票状态
//        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvState())) {
//            predicates.add(qSaleInvdDtlDO.invState.eq(saleInvPageParam.getInvState()));
//        }
    }*/

    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam) {

        // 明细数据过滤 ture-没有数据 false-有数据
        Boolean filter = filterDetails(saleInvPageParam);

        if (filter) {
            return PagingVO.<SaleInvDTO>builder()
                    .total(0)
                    .records(List.of())
                    .build();
        }

        List<Predicate> predicates = new ArrayList<>();
        // 主表
        buildPredicates(saleInvPageParam, predicates);

        if (CollectionUtils.isNotEmpty(saleInvPageParam.getIds())) {
            predicates.add(qSaleInvDO.id.in(saleInvPageParam.getIds()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(saleInvPageParam.getConditions(), SaleInvDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
        JPAQuery<SaleInvDTO> query = jpaQueryFactory.select(Projections.bean(SaleInvDTO.class,
                        qSaleInvDO.id,
                        qSaleInvDO.createTime,
                        qSaleInvDO.updater,
                        qSaleInvDO.modifyTime,
                        qSaleInvDO.creator,
                        qSaleInvDO.remark,
                        qSaleInvDO.sourceSysNo,
                        qSaleInvDO.applyNo,
                        qSaleInvDO.ouCode,
                        qSaleInvDO.ouId,
                        qSaleInvDO.ouName,
                        qSaleInvDO.taxRate,
                        qSaleInvDO.invRegNo,
                        qSaleInvDO.currCode,
                        qSaleInvDO.currName,
                        qSaleInvDO.localCurrCode,
                        qSaleInvDO.localCurrName,
                        qSaleInvDO.totalAmt,
                        qSaleInvDO.totalCurAmt,
                        qSaleInvDO.saleInvTitle,
                        qSaleInvDO.saleTaxNo,
                        qSaleInvDO.saleTel,
                        qSaleInvDO.saleAdd,
                        qSaleInvDO.saleBank,
                        qSaleInvDO.saleBankAcc,
                        qSaleInvDO.saleRemark,
                        qSaleInvDO.saleId,
                        qSaleInvDO.saleName,
                        qSaleInvDO.saleCode,
                        qSaleInvDO.custInvTitle,
                        qSaleInvDO.custTaxNo,
                        qSaleInvDO.custAdd,
                        qSaleInvDO.custTel,
                        qSaleInvDO.custBank,
                        qSaleInvDO.custBankAcc,
                        qSaleInvDO.custRemark,
                        qSaleInvDO.custId,
                        qSaleInvDO.custName,
                        qSaleInvDO.custCode,
                        qSaleInvDO.invUser,
                        qSaleInvDO.recUser,
                        qSaleInvDO.revUser,
                        qSaleInvDO.auditUserId,
                        qSaleInvDO.pushMethod,
                        qSaleInvDO.phone,
                        qSaleInvDO.email,
                        qSaleInvDO.infoNo,
                        qSaleInvDO.expressNo,
                        qSaleInvDO.invState,
                        qSaleInvDO.auditUser,
                        qSaleInvDO.auditDate,
                        qSaleInvDO.orderState,
                        qSaleInvDO.exchangeRate,
                        qSaleInvDO.auditRejection,
                        qSaleInvDO.createMode,
                        qSaleInvDO.invType,
                        qSaleInvDO.invMerge,
                        qSaleInvDO.mainCustCode,
                        qSaleInvDO.mainCustId,
                        qSaleInvDO.mainCustName,
                        qSaleInvDO.settlementType,
                        qSaleInvDO.pkGroup,
                        qSaleInvDO.openInvType,
                        qSaleInvDO.invCustCode,
                        qSaleInvDO.invCustId,
                        qSaleInvDO.invCustName,
                        qSaleInvDO.drawDate,
                        qSaleInvDO.redPunchDate,
                        qSaleInvDO.docType3,
                        qSaleInvDO.recvContactName,
                        qSaleInvDO.recvContactTel,
                        qSaleInvDO.extensionInfo
                ))
                .from(qSaleInvDO)
                .where(ExpressionUtils.allOf(predicates));

        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, qSaleInvDO);

        return PagingVO.<SaleInvDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public SaleInvSumDTO selectListSum(SaleInvPageParam saleInvPageParam) {

        // 明细数据过滤 ture-没有数据 false-有数据
        Boolean filter = filterDetails(saleInvPageParam);

        if (filter) {
            return new SaleInvSumDTO();
        }

        List<Predicate> predicates = new ArrayList<>();
        // 主表
        buildPredicates(saleInvPageParam, predicates);

        if (CollectionUtils.isNotEmpty(saleInvPageParam.getIds())) {
            predicates.add(qSaleInvDO.id.in(saleInvPageParam.getIds()));
        }

        JPAQuery<SaleInvSumDTO> query = jpaQueryFactory.select(Projections.bean(SaleInvSumDTO.class,
                qSaleInvDO.totalAmt.sum().as("totalSumAmt")
        )).from(qSaleInvDO)
                .where(ExpressionUtils.allOf(predicates));

        return query.fetchOne();
    }


    private void buildPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {

        if (StrUtil.isNotBlank(saleInvPageParam.getMainCustCode())) {
            predicates.add(qSaleInvDO.mainCustCode.eq(saleInvPageParam.getMainCustCode()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getMainCustCodeList())){
            predicates.add(qSaleInvDO.mainCustCode.in(saleInvPageParam.getMainCustCodeList()));
        }

        if (StrUtil.isNotBlank(saleInvPageParam.getMainCustName())) {
            predicates.add(qSaleInvDO.mainCustName.like("%" + saleInvPageParam.getMainCustName() + "%"));
        }


        if (ObjectUtil.isNotNull(saleInvPageParam.getMainCustId())) {
            predicates.add(qSaleInvDO.mainCustId.eq(saleInvPageParam.getMainCustId()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getMainCustIdList())){
            predicates.add(qSaleInvDO.mainCustId.in(saleInvPageParam.getMainCustIdList()));
        }

        if (null != saleInvPageParam.getOuId()) {
            predicates.add(qSaleInvDO.ouId.eq(saleInvPageParam.getOuId()));
        }
        // 来源单据
        if (!StringUtils.isEmpty(saleInvPageParam.getCreateMode())) {
            predicates.add(qSaleInvDO.createMode.eq(saleInvPageParam.getCreateMode()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getCreateModeList())){
            predicates.add(qSaleInvDO.createMode.in(saleInvPageParam.getCreateModeList()));
        }
        // 开票申请单号
        if (!StringUtils.isEmpty(saleInvPageParam.getApplyNo())) {
            predicates.add(qSaleInvDO.applyNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        // 来源系统单号
        if (!StringUtils.isEmpty(saleInvPageParam.getSourceSysNo())) {
            predicates.add(qSaleInvDO.sourceSysNo.eq(saleInvPageParam.getSourceSysNo()));
        }
        // 客户
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getCustName())) {
            predicates.add(qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add(qSaleInvDO.custId.eq(saleInvPageParam.getCustId()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getCustIdList())){
            predicates.add(qSaleInvDO.custId.in(saleInvPageParam.getCustIdList()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add(qSaleInvDO.custCode.eq(saleInvPageParam.getCustCode()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getCustCodeList())){
            predicates.add(qSaleInvDO.custCode.in(saleInvPageParam.getCustCodeList()));
        }
        // 发票类型
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvType())) {
            predicates.add(qSaleInvDO.invType.eq(saleInvPageParam.getInvType()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getInvTypeList())){
            predicates.add(qSaleInvDO.invType.in(saleInvPageParam.getInvTypeList()));
        }
        // 信息表编号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInfoNo())) {
            predicates.add(qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        // 快递单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getExpressNo())) {
            predicates.add(qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }

        // 开票金额/开始
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add(qSaleInvDO.totalAmt.goe(saleInvPageParam.getTotalAmtStart()));
        }
        // 开票金额/结束
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add(qSaleInvDO.totalAmt.loe(saleInvPageParam.getTotalAmtEnd()));
        }

        if (StringUtils.isNotEmpty(saleInvPageParam.getCustCode())) {
            predicates.add(qSaleInvDO.custCode.eq(saleInvPageParam.getCustCode()));
        }
        if(CollectionUtils.isNotEmpty(saleInvPageParam.getCustCodeList())){
            predicates.add(qSaleInvDO.custCode.in(saleInvPageParam.getCustCodeList()));
        }

        if (StringUtils.isNotEmpty(saleInvPageParam.getDocType3())) {
            predicates.add(qSaleInvDO.docType3.eq(saleInvPageParam.getDocType3()));
        }

        if (StringUtils.isNotEmpty(saleInvPageParam.getInvState())) {
            String orderState;
            if (StrUtil.equals(saleInvPageParam.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                orderState = UdcEnum.APPLY_STATUS_INV_SUCCESS.getValueCode();
            } else if (StrUtil.equals(saleInvPageParam.getInvState(), UdcEnum.INV_STATE_FAIL.getValueCode())) {
                orderState = UdcEnum.APPLY_STATUS_INV_FAIL.getValueCode();
            } else {
                orderState = saleInvPageParam.getInvState();
            }
            predicates.add(qSaleInvDO.orderState.eq(orderState));
        }

        if(CollectionUtils.isNotEmpty(saleInvPageParam.getInvStateList())){
            List<String> orderStateList = new ArrayList<>();

            for (String invState : saleInvPageParam.getInvStateList()) {
                String orderState = new String();
                if (StrUtil.equals(invState, UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                    orderState = UdcEnum.APPLY_STATUS_INV_SUCCESS.getValueCode();
                } else if (StrUtil.equals(invState, UdcEnum.INV_STATE_FAIL.getValueCode())) {
                    orderState = UdcEnum.APPLY_STATUS_INV_FAIL.getValueCode();
                } else {
                    orderState = invState;
                }
                orderStateList.add(orderState);
            }


            predicates.add(qSaleInvDO.orderState.in(orderStateList));

        }

        if (StringUtils.isNotEmpty(saleInvPageParam.getOrderState())) {
            predicates.add(qSaleInvDO.orderState.eq(saleInvPageParam.getOrderState()));
        }

        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRecvContactName())) {
            predicates.add(qSaleInvDO.recvContactName.like("%" + saleInvPageParam.getRecvContactName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRecvContactTel())) {
            predicates.add(qSaleInvDO.recvContactTel.like("%" + saleInvPageParam.getRecvContactTel() + "%"));
        }


        predicates.add(qSaleInvDO.deleteFlag.eq(0));

    }
    public Boolean filterDetails(SaleInvPageParam saleInvPageParam) {

        List<Predicate> ddtlPredicates = new ArrayList<>();
        List<Predicate> dtlPredicates = new ArrayList<>();

        List<Long> ids = new ArrayList<>();

        // 已开发票明细
        buildDDtlPredicates(saleInvPageParam, ddtlPredicates);
        if (CollectionUtils.isNotEmpty(ddtlPredicates)) {
            List<Long> masIds = jpaQueryFactory.selectDistinct(qSaleInvdDtlDO.masId)
                    .from(qSaleInvdDtlDO)
                    .where(ExpressionUtils.allOf(ddtlPredicates)).fetch();

            if (CollectionUtils.isEmpty(masIds)) {
                return Boolean.TRUE;
            }
            ids=masIds;
        }

        // 发票明细
        buildDtlPredicates(saleInvPageParam,dtlPredicates);
        if (CollectionUtils.isNotEmpty(ids)) {
            dtlPredicates.add(qSaleInvDtlDO.masId.in(ids));
        }
        if (CollectionUtils.isNotEmpty(dtlPredicates)) {
            List<Long> masIds = jpaQueryFactory.selectDistinct(qSaleInvDtlDO.masId)
                    .from(qSaleInvDtlDO)
                    .where(ExpressionUtils.allOf(dtlPredicates)).fetch();
            if (CollectionUtils.isEmpty(masIds)) {
                return Boolean.TRUE;
            }
            ids=masIds;
        }
        List<Long> masIds = ids.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        saleInvPageParam.setIds(masIds);

        return Boolean.FALSE;
    }
    private void buildDtlPredicates(SaleInvPageParam saleInvPageParam,List<Predicate> predicates) {
        // 销售发票明细
        //  来源单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getSourceNo())) {
            predicates.add(qSaleInvDtlDO.sourceNo.like("%" + saleInvPageParam.getSourceNo() + "%"));
        }

    }
    // 已开发票明细
    private void buildDDtlPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {

        // 发票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getInvNo())) {
            predicates.add(qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        // 原蓝票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getBlueInvNo())) {
            predicates.add(qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        // 开票日期/
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(qSaleInvdDtlDO.invDate.between(saleInvPageParam.getInvDateStart(), saleInvPageParam.getInvDateEnd()));
        }

        // 红冲状态
//        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRedState())) {
//            predicates.add(qSaleInvdDtlDO.redState.eq(saleInvPageParam.getRedState()));
//        }
//        // 开票状态
//        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvState())) {
//            predicates.add(qSaleInvdDtlDO.invState.eq(saleInvPageParam.getInvState()));
//        }
    }
}
