package com.elitesland.fin.infr.repo.arorder;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.service.excel.entity.ApOrderExportEntity;
import com.elitesland.fin.application.service.excel.entity.ArListExportEntity;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDtlDO;


import com.elitesland.fin.domain.entity.paymentperiod.QReceiptPaymentAgreementDO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderExcelDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:41
 */
@Component
@RequiredArgsConstructor
public class ArOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;
    private final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;

    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 总单Id
        if (null != arOrderDtlPageParam.getMasId()) {
            predicates.add(qArOrderDtlDO.masId.eq(arOrderDtlPageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderDtlPageParam.getMasIds())) {
            predicates.add(qArOrderDtlDO.masId.in(arOrderDtlPageParam.getMasIds()));
        }
        predicates.add(qArOrderDtlDO.deleteFlag.eq(0));
        JPAQuery<ArOrderDtlDTO> query = select(ArOrderDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        arOrderDtlPageParam.setPaging(query);
        arOrderDtlPageParam.fillOrders(query, qArOrderDtlDO);

        return PagingVO.<ArOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArOrderDtlDO.id,
                qArOrderDtlDO.sourceNo,
                qArOrderDtlDO.masId,
                qArOrderDtlDO.sourceLine,
                qArOrderDtlDO.itemId,
                qArOrderDtlDO.itemCode,
                qArOrderDtlDO.itemName,
                qArOrderDtlDO.itemType,
                qArOrderDtlDO.smallCateCode,
                qArOrderDtlDO.smallCateName,
                qArOrderDtlDO.uom,
                qArOrderDtlDO.uomName,
                qArOrderDtlDO.qty,
                qArOrderDtlDO.exclTaxPrice,
                qArOrderDtlDO.price,
                qArOrderDtlDO.taxRate,
                qArOrderDtlDO.totalAmt,
                qArOrderDtlDO.exclTaxAmt,
                qArOrderDtlDO.taxAmt,
                qArOrderDtlDO.totalCurAmt,
                qArOrderDtlDO.exclTaxCurAmt,
                qArOrderDtlDO.taxCurAmt,
                qArOrderDtlDO.remark,
                qArOrderDtlDO.buCode,
                qArOrderDtlDO.buId,
                qArOrderDtlDO.buName,
                qArOrderDtlDO.expensesType,
                qArOrderDtlDO.relateId,
                qArOrderDtlDO.es11,
                qArOrderDtlDO.es12,
                qArOrderDtlDO.es13,
                qArOrderDtlDO.es14,
                qArOrderDtlDO.es15,
                qArOrderDtlDO.es16,
                qArOrderDtlDO.es17,
                qArOrderDtlDO.es18,
                qArOrderDtlDO.es19,
                qArOrderDtlDO.es20,
                qArOrderDtlDO.es21,
                qArOrderDtlDO.es22,
                qArOrderDtlDO.es23,
                qArOrderDtlDO.es24,
                qArOrderDtlDO.docType,
                qArOrderDtlDO.docType2,
                qArOrderDtlDO.docCls,
                qArOrderDtlDO.verAmt,
                qArOrderDtlDO.unVerAmt,
                qArOrderDtlDO.applyVerAmTing,
                qArOrderDtlDO.protocolCode
        )).from(qArOrderDtlDO);
    }


    public List<Long> findBySourceId(String sourceId) {
        List<Long> res = jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public List<Long> findBySourceNoList(List<String> sourceNoList) {
        if (CollectionUtil.isEmpty(sourceNoList)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> res = jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.sourceNo.in(sourceNoList))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public List<Long> findUnverBySourceId(ArOrderPageParam arOrderPageParam) {
        String sourceId = arOrderPageParam.getSourceNoDtl();
        // 总单Id
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(sourceId)) {
            predicates.add(qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"));
        }
        predicates.add(qArOrderDtlDO.deleteFlag.eq(0));
        if (StringUtils.isNotBlank(arOrderPageParam.getWriteOfFAmtCon())) {
            if (FinConstant.WRITE_OFF_AMT_CON_GT.equals(arOrderPageParam.getWriteOfFAmtCon())) {
                predicates.add(qArOrderDtlDO.unVerAmt.gt(BigDecimal.ZERO));
            } else if (FinConstant.WRITE_OFF_AMT_CON_LT.equals(arOrderPageParam.getWriteOfFAmtCon())) {
                predicates.add(qArOrderDtlDO.unVerAmt.lt(BigDecimal.ZERO));
            }
        } else {
            predicates.add(qArOrderDtlDO.unVerAmt.ne(BigDecimal.ZERO));
        }
        return jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }

    public List<BigDecimal> countByMasId(Long id) {
        return jpaQueryFactory.select(qArOrderDtlDO.qty)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.eq(id))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.update(qArOrderDtlDO)
                .set(qArOrderDtlDO.deleteFlag, 1)
                .where(qArOrderDtlDO.masId.in(ids))
                .execute();
        return res;
    }

    public void delByMasId(List<Long> id) {
        jpaQueryFactory.delete(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.in(id))
                .execute();
    }

    @SysCodeProc
    public List<ArOrderDtlDTO> listByMisId(Long masId) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.masId.eq(masId))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

    @SysCodeProc
    public List<ArOrderDtlDTO> listByMasIds(Collection<Long> ids) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.masId.in(ids))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

    public List<ArOrderDtlDTO> listByIds(List<Long> ids) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.id.in(ids))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

    public List<ArOrderDtlHandleDTO> selectVerState() {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ArOrderDtlHandleDTO.class,
                        qArOrderDtlDO.masId,
                        qArOrderDtlDO.verAmt.sum().as("verAmtSum"),
                        qArOrderDtlDO.applyVerAmTing.sum().as("applyVerAmTingSum"),
                        qArOrderDtlDO.unVerAmt.sum().as("unVerAmtSum")
                ))
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.deleteFlag.eq(0).or(qArOrderDtlDO.deleteFlag.isNull()))
                .groupBy(qArOrderDtlDO.masId);

        return jpaQuery.fetch();
    }

    public Long countExportArOrder(ArOrderPageParam arOrderPageParam) {
        var jpaQuery = jpaQueryFactory.select(qArOrderDtlDO.count()).from(qArOrderDtlDO)
                .leftJoin(qArOrderDO).on(qArOrderDtlDO.masId.eq(qArOrderDO.id));
        var predicates = pageWhere(arOrderPageParam);
        if (StrUtil.isNotBlank(arOrderPageParam.getSourceNoDtl())) {
            predicates.add(qArOrderDtlDO.sourceNo.like("%" + arOrderPageParam.getSourceNoDtl() + "%"));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getDtlSourceNoList())) {
            predicates.add(qArOrderDtlDO.sourceNo.in(arOrderPageParam.getDtlSourceNoList()));
        }

        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add(qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate(arOrderPageParam.getConditions(), ArOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchCount();
    }

    public List<ArOrderExcelDTO> exportArOrder(ArOrderPageParam arOrderPageParam) {
        QReceiptPaymentAgreementDO receiptPaymentAgreementDO = QReceiptPaymentAgreementDO.receiptPaymentAgreementDO;

        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ArOrderExcelDTO.class,
                        qArOrderDO.id,
                        qArOrderDO.sourceNo,
                        qArOrderDO.ouCode,
                        qArOrderDO.ouId,
                        qArOrderDO.ouName,
                        qArOrderDO.arTypeId,
                        qArOrderDO.arTypeName,
                        qArOrderDO.arTypeCode,
                        qArOrderDO.currCode,
                        qArOrderDO.currName,
                        qArOrderDO.operator,
                        qArOrderDO.operUserId,
                        qArOrderDO.totalAmt,
                        qArOrderDO.totalCurAmt,
                        qArOrderDO.buDate,
                        qArOrderDO.auditUserId,
                        qArOrderDO.auditUser,
                        qArOrderDO.auditDate,
                        qArOrderDO.orderState,
                        qArOrderDO.exchangeRate,
                        qArOrderDO.initFlag,
                        qArOrderDO.taxFlag,
                        qArOrderDO.createTime,
                        qArOrderDO.exclTaxAmt,
                        qArOrderDO.taxAmt,
                        qArOrderDO.arOrderNo,
                        qArOrderDO.creator,
                        qArOrderDO.createMode,
                        qArOrderDO.remark,
                        qArOrderDO.exclTaxCurAmt,
                        qArOrderDO.verState,
                        qArOrderDO.verAmt,
                        qArOrderDO.orgId,
                        qArOrderDO.orgCode,
                        qArOrderDO.orgName,
                        qArOrderDO.saleUserId,
                        qArOrderDO.saleUser,
                        qArOrderDO.custName,
                        qArOrderDO.custId,
                        qArOrderDO.custCode,
                        qArOrderDO.docType,
                        qArOrderDO.docType2,
                        qArOrderDO.docCls,
                        qArOrderDO.approvedTime,
                        qArOrderDO.submitTime,
                        qArOrderDO.settlementType,
                        qArOrderDO.redSourceNo,
                        qArOrderDO.redSourceId,
                        qArOrderDO.redState,
                        qArOrderDO.inOutCust,
                        qArOrderDO.protocolCode,
                        qArOrderDO.relevanceOuCode,
                        qArOrderDtlDO.sourceNo.as("detailSourceNo"),
                        qArOrderDtlDO.sourceLine,
                        qArOrderDtlDO.itemCode,
                        qArOrderDtlDO.itemId,
                        qArOrderDtlDO.itemName,
                        qArOrderDtlDO.smallCateCode,
                        qArOrderDtlDO.smallCateName,
                        qArOrderDtlDO.uom,
                        qArOrderDtlDO.uomName,
                        qArOrderDtlDO.qty,
                        qArOrderDtlDO.exclTaxPrice,
                        qArOrderDtlDO.price,
                        qArOrderDtlDO.taxRate,
                        qArOrderDtlDO.totalAmt.as("detailTotalAmt"),
                        qArOrderDtlDO.exclTaxAmt.as("detailExclTaxAmt"),
                        qArOrderDtlDO.taxAmt.as("detailTaxAmt"),
                        qArOrderDtlDO.verAmt,
                        qArOrderDtlDO.unVerAmt,
                        qArOrderDtlDO.applyVerAmTing.as("applyVerAmt"),
                        qArOrderDtlDO.protocolCode,
                        receiptPaymentAgreementDO.protocolName
                )).from(qArOrderDtlDO)
                .leftJoin(qArOrderDO).on(qArOrderDtlDO.masId.eq(qArOrderDO.id))
                .leftJoin(receiptPaymentAgreementDO).on(qArOrderDtlDO.protocolCode.eq(receiptPaymentAgreementDO.protocolCode)
                        .and(receiptPaymentAgreementDO.protocolType.eq(UdcEnum.AGREEMENT_PROTOCOL_TYPE_RECEIPT.getValueCode())));
        var predicates = pageWhere(arOrderPageParam);
        if (StrUtil.isNotBlank(arOrderPageParam.getSourceNoDtl())) {
            predicates.add(qArOrderDtlDO.sourceNo.like("%" + arOrderPageParam.getSourceNoDtl() + "%"));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getDtlSourceNoList())) {
            predicates.add(qArOrderDtlDO.sourceNo.in(arOrderPageParam.getDtlSourceNoList()));
        }

        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add(qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        arOrderPageParam.setPaging(jpaQuery);
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate(arOrderPageParam.getConditions(), ArOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(qArOrderDO.id.desc(), qArOrderDtlDO.id.desc());
        return jpaQuery.fetch();
    }

    private List<Predicate> pageWhere(ArOrderPageParam arOrderPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        checkParam(arOrderPageParam, predicates);
        // 来源单据
        if (Objects.nonNull(arOrderPageParam.getEs2())) {
            predicates.add(qArOrderDO.es2.like("%" + arOrderPageParam.getEs2() + "%"));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCreateMode())) {
            predicates.add(qArOrderDO.createMode.eq(arOrderPageParam.getCreateMode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCreateModeList())) {
            predicates.add(qArOrderDO.createMode.in(arOrderPageParam.getCreateModeList()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedState())) {
            predicates.add(qArOrderDO.redState.eq(arOrderPageParam.getRedState()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedSourceNo())) {
            predicates.add(qArOrderDO.redSourceNo.like("%" + arOrderPageParam.getRedSourceNo() + "%"));
        }
        // 是否期初
        if (null != arOrderPageParam.getInitFlag()) {
            predicates.add(qArOrderDO.initFlag.eq(arOrderPageParam.getInitFlag()));
        }
        if (arOrderPageParam.getProposedStatus() != null) {
            predicates.add(qArOrderDO.proposedStatus.eq(arOrderPageParam.getProposedStatus()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getProtocolCode())) {
            predicates.add(qArOrderDO.protocolCode.eq(arOrderPageParam.getProtocolCode()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getProtocolCodeList())) {
            predicates.add(qArOrderDO.protocolCode.in(arOrderPageParam.getProtocolCodeList()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getRelevanceOuCodeList())) {
            predicates.add(qArOrderDO.relevanceOuCode.in(arOrderPageParam.getRelevanceOuCodeList()));
        }

        // 销售组织
        buildPredicates(arOrderPageParam, predicates);

        predicates.add(qArOrderDO.deleteFlag.eq(0));
        return predicates;
    }

    private void buildPredicates(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(arOrderPageParam.getOrgCode())) {
            predicates.add(qArOrderDO.orgCode.eq(arOrderPageParam.getOrgCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrgCodeList())) {
            predicates.add(qArOrderDO.orgCode.in(arOrderPageParam.getOrgCodeList()));
        }
        if (null != arOrderPageParam.getOrgId()) {
            predicates.add(qArOrderDO.orgId.eq(arOrderPageParam.getOrgId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrgIdList())) {
            predicates.add(qArOrderDO.orgId.in(arOrderPageParam.getOrgIdList()));
        }
        // 客户
        if (null != arOrderPageParam.getCustId()) {
            predicates.add(qArOrderDO.custId.eq(arOrderPageParam.getCustId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCustIdList())) {
            predicates.add(qArOrderDO.custId.in(arOrderPageParam.getCustIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCustName())) {
            predicates.add(qArOrderDO.custName.like("%" + arOrderPageParam.getCustName() + "%"));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCustCode())) {
            predicates.add(qArOrderDO.custCode.eq(arOrderPageParam.getCustCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCustCodeList())) {
            predicates.add(qArOrderDO.custCode.in(arOrderPageParam.getCustCodeList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrCode())) {
            predicates.add(qArOrderDO.currCode.eq(arOrderPageParam.getCurrCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())) {
            predicates.add(qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        // 销售业务员
        if (StringUtils.isNotBlank(arOrderPageParam.getSaleUser())) {
            predicates.add(qArOrderDO.saleUser.like("%" + arOrderPageParam.getSaleUser() + "%"));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getSaleUserList())) {
            predicates.add(qArOrderDO.saleUser.in(arOrderPageParam.getSaleUserList()));
        }
        // 销售部门
        if (null != arOrderPageParam.getBuId()) {
            predicates.add(qArOrderDO.buId.eq(arOrderPageParam.getBuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getBuIdList())) {
            predicates.add(qArOrderDO.buId.in(arOrderPageParam.getBuIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getBuCode())) {
            predicates.add(qArOrderDO.buCode.eq(arOrderPageParam.getBuCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getBuCodeList())) {
            predicates.add(qArOrderDO.buCode.in(arOrderPageParam.getBuCodeList()));
        }
        // 审核日期
        if (null != arOrderPageParam.getAuditDateStart() && null != arOrderPageParam.getAuditDateEnd()) {
            predicates.add(qArOrderDO.auditDate.between(arOrderPageParam.getAuditDateStart(), arOrderPageParam.getAuditDateEnd()));
        }
        if (ObjectUtil.isNotNull(arOrderPageParam.getOuId())) {
            predicates.add(qArOrderDO.ouId.eq(arOrderPageParam.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())) {
            predicates.add(qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getOuCode())) {
            predicates.add(qArOrderDO.ouCode.eq(arOrderPageParam.getOuCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuCodeList())) {
            predicates.add(qArOrderDO.ouCode.in(arOrderPageParam.getOuCodeList()));
        }
    }

    private void checkParam(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        // 公司
        if (null != arOrderPageParam.getOuId()) {
            predicates.add(qArOrderDO.ouId.eq(arOrderPageParam.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())) {
            predicates.add(qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        // 币种
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrCode())) {
            predicates.add(qArOrderDO.currCode.eq(arOrderPageParam.getCurrCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())) {
            predicates.add(qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrName())) {
            predicates.add(qArOrderDO.currName.eq(arOrderPageParam.getCurrName()));
        }
        // 业务日期
        if (null != arOrderPageParam.getBuDateStart() && null != arOrderPageParam.getBuDateEnd()) {
            predicates.add(qArOrderDO.buDate.between(arOrderPageParam.getBuDateStart(), arOrderPageParam.getBuDateEnd()));
        }
        // 来源系统单号
        if (StringUtils.isNotBlank(arOrderPageParam.getSourceNo())) {
            predicates.add(qArOrderDO.sourceNo.like('%' + arOrderPageParam.getSourceNo() + '%'));
        }

        // 应收单类型
        if (null != arOrderPageParam.getArTypeId()) {
            predicates.add(qArOrderDO.arTypeId.eq(arOrderPageParam.getArTypeId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getArTypeIdList())) {
            predicates.add(qArOrderDO.arTypeId.in(arOrderPageParam.getArTypeIdList()));
        }
        // 单据状态
        if (StringUtils.isNotBlank(arOrderPageParam.getOrderState())) {
            predicates.add(qArOrderDO.orderState.eq(arOrderPageParam.getOrderState()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrderStateList())) {
            predicates.add(qArOrderDO.orderState.in(arOrderPageParam.getOrderStateList()));
        }
        // 核销状态
        if (StringUtils.isNotBlank(arOrderPageParam.getVerState())) {
            predicates.add(qArOrderDO.verState.eq(arOrderPageParam.getVerState()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getVerStateList())) {
            predicates.add(qArOrderDO.verState.in(arOrderPageParam.getVerStateList()));
        }
        // 应付单号
        if (StringUtils.isNotBlank(arOrderPageParam.getArOrderNo())) {
            predicates.add(qArOrderDO.arOrderNo.like('%' + arOrderPageParam.getArOrderNo() + '%'));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getArOrderNoList())) {
            predicates.add(qArOrderDO.arOrderNo.in(arOrderPageParam.getArOrderNoList()));
        }
        // 含税金额
        if (null != arOrderPageParam.getTotalAmtStart()) {
            predicates.add(qArOrderDO.totalAmt.goe(arOrderPageParam.getTotalAmtStart()));
        }
        if (null != arOrderPageParam.getTotalAmtEnd()) {
            predicates.add(qArOrderDO.totalAmt.loe(arOrderPageParam.getTotalAmtEnd()));
        }
        // 经办人
        if (StringUtils.isNotBlank(arOrderPageParam.getOperator())) {
            predicates.add(qArOrderDO.operator.like('%' + arOrderPageParam.getOperator() + '%'));
        }
        // 创建人
        if (StringUtils.isNotBlank(arOrderPageParam.getCreator())) {
            predicates.add(qArOrderDO.creator.like('%' + arOrderPageParam.getCreator() + '%'));
        }
        // 审核人
        if (StringUtils.isNotBlank(arOrderPageParam.getAuditUser())) {
            predicates.add(qArOrderDO.auditUser.like('%' + arOrderPageParam.getAuditUser() + '%'));
        }
    }
}
