package com.elitesland.fin.infr.repo.payorder;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:45
 */
@Component
@RequiredArgsConstructor
public class PayOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPayOrderDtlDO qPayOrderDtlDO = QPayOrderDtlDO.payOrderDtlDO;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;

    public List<Long> queryBySourceNo(String sourceNo) {
        return jpaQueryFactory.select(qPayOrderDtlDO.masId)
                .from(qPayOrderDtlDO)
                .where(qPayOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))
                .fetch();
    }

    public List<Long> queryBySourceNoList(List<String> sourceNoList) {
        if (CollectionUtil.isEmpty(sourceNoList)){
            return Collections.EMPTY_LIST;
        }
        return jpaQueryFactory.select(qPayOrderDtlDO.masId)
                .from(qPayOrderDtlDO)
                .where(qPayOrderDtlDO.sourceNo.in(sourceNoList))
                .fetch();
    }

    public List<Long> queryUnverBySourceNo(PayOrderPageParam param) {
        String sourceNo=param.getSourceNoDtl();
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(sourceNo)) {
            predicates.add(qPayOrderDtlDO.sourceNo.like("%" + sourceNo + "%"));
        }
        predicates.add(qPayOrderDtlDO.deleteFlag.eq(0));
        if(StringUtils.isNotBlank(param.getWriteOfFAmtCon())){
            if(FinConstant.WRITE_OFF_AMT_CON_GT.equals(param.getWriteOfFAmtCon())){
                predicates.add(qPayOrderDtlDO.unVerAmt.gt(BigDecimal.ZERO));
            }else if(FinConstant.WRITE_OFF_AMT_CON_LT.equals(param.getWriteOfFAmtCon())){
                predicates.add(qPayOrderDtlDO.unVerAmt.lt(BigDecimal.ZERO));
            }
        }else{
            predicates.add(qPayOrderDtlDO.unVerAmt.ne(BigDecimal.ZERO));
        }
        return jpaQueryFactory.select(qPayOrderDtlDO.masId)
                .from(qPayOrderDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }
    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.id.in(ids))
                .fetch();
    }

    public List<PayOrderDtlDTO> queryBySourceIdList(List<Long> sourceIdList) {
        return selectJoin(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.sourceId.in(sourceIdList).and(qPayOrderDtlDO.masId.eq(qPayOrderDO.id)).and(qPayOrderDO.orderState.eq("DRAFT")))
                .fetch();
    }

    @SysCodeProc
    public List<PayOrderDtlDTO> queryByMasId(Long masId) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.masId.in(masId))
                .fetch();
    }

    public void deleteByMasIds(List<Long> masIds) {
        jpaQueryFactory.delete(qPayOrderDtlDO)
                .where(qPayOrderDtlDO.masId.in(masIds))
                .execute();
    }

    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (param.getMisId() != null) {
            predicates.add(qPayOrderDtlDO.masId.eq(param.getMisId()));
        }
        if(CollectionUtils.isNotEmpty(param.getMasIds())){
            predicates.add(qPayOrderDtlDO.masId.in(param.getMasIds()));
        }
        JPAQuery<PayOrderDtlDTO> query = select(PayOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qPayOrderDtlDO);
        return PagingVO.<PayOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayOrderDtlDO.id,
                qPayOrderDtlDO.masId,
                qPayOrderDtlDO.payType,
                qPayOrderDtlDO.payBank,
                qPayOrderDtlDO.payAccount,
                qPayOrderDtlDO.recBank,
                qPayOrderDtlDO.recAccount,
                qPayOrderDtlDO.sourceNo,
                qPayOrderDtlDO.sourceLine,
                qPayOrderDtlDO.sourceId,
                qPayOrderDtlDO.sourceLineId,
                qPayOrderDtlDO.realPayAmt,
                qPayOrderDtlDO.realPayCurAmt,
                qPayOrderDtlDO.totalAmt,
                qPayOrderDtlDO.totalCurAmt,
                qPayOrderDtlDO.expensesType,
                qPayOrderDtlDO.buId,
                qPayOrderDtlDO.buName,
                qPayOrderDtlDO.buCode,
                qPayOrderDtlDO.verAmt,
                qPayOrderDtlDO.unVerAmt,
                qPayOrderDtlDO.applyVerAmTing,
                qPayOrderDtlDO.remark)
        ).from(qPayOrderDtlDO);
    }

    private <T> JPAQuery<T> selectJoin(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayOrderDtlDO.id,
                qPayOrderDtlDO.masId,
                qPayOrderDtlDO.payType,
                qPayOrderDtlDO.payBank,
                qPayOrderDtlDO.payAccount,
                qPayOrderDtlDO.recBank,
                qPayOrderDtlDO.recAccount,
                qPayOrderDtlDO.sourceNo,
                qPayOrderDtlDO.sourceLine,
                qPayOrderDtlDO.sourceId,
                qPayOrderDtlDO.sourceLineId,
                qPayOrderDtlDO.realPayAmt,
                qPayOrderDtlDO.realPayCurAmt,
                qPayOrderDtlDO.totalAmt,
                qPayOrderDtlDO.totalCurAmt,
                qPayOrderDtlDO.expensesType,
                qPayOrderDtlDO.buId,
                qPayOrderDtlDO.buName,
                qPayOrderDtlDO.buCode,
                qPayOrderDtlDO.verAmt,
                qPayOrderDtlDO.unVerAmt,
                qPayOrderDtlDO.applyVerAmTing,
                qPayOrderDtlDO.remark)
        ).from(qPayOrderDtlDO, qPayOrderDO);
    }

    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.masId.in(masIds))
                .fetch();
    }

    public List<PayOrderDtlDO> findAllByIdsIn(List<Long> ids) {
        return jpaQueryFactory.selectFrom(qPayOrderDtlDO).where(qPayOrderDtlDO.id.in(ids)).fetch();
    }
}
