package com.elitesland.fin.repo.expense;


import com.elitesland.fin.entity.expense.ExpRuleConfigDtlDO;
import com.elitesland.fin.entity.expense.QExpRuleConfigDtlDO;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/13 13:23
 * @Description:
 */
@Slf4j
@Component
@AllArgsConstructor
public class ExpRuleConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public List<ExpRuleConfigDtlDO> findByMasIdsIn(List<Long> masIdList){
        val jpaQDO = QExpRuleConfigDtlDO.expRuleConfigDtlDO;
        return jpaQueryFactory.selectFrom(jpaQDO).where(jpaQDO.masId.in(masIdList)).fetch();
    }

    public void updateDynamically(List<ExpRuleConfigDtlDO> expRuleConfigDtlDOList) {
        val jpaQDO = QExpRuleConfigDtlDO.expRuleConfigDtlDO;
        for (ExpRuleConfigDtlDO param : expRuleConfigDtlDOList) {
            JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);

            updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
            updateClause.where(jpaQDO.id.eq(param.getId())).execute();
        }
    }

    public void deleteByParam(ExpRuleConfigDtlDO expRuleConfigDtlDO) {
        val jpaQDO = QExpRuleConfigDtlDO.expRuleConfigDtlDO;
        JPADeleteClause jpaDeleteClause = jpaQueryFactory.delete(jpaQDO);
        if (expRuleConfigDtlDO.getMasId() != null) {
            jpaDeleteClause.where(jpaQDO.masId.eq(expRuleConfigDtlDO.getMasId()));
        }
        jpaDeleteClause.execute();
    }

}